/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentDeclarations;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentMacros;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentReferences;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SystemMacroImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.AbstractObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public class UIDObjectFactory
extends AbstractObjectFactory {
    private static UIDObjectFactory theFactory;
    private static final short FIRST_INDEX = 52;
    private static final short UID_PROJECT_UID = 52;
    private static final short UID_NAMESPACE_UID = 53;
    private static final short UID_FILE_UID = 54;
    private static final short UID_TYPEDEF_UID = 55;
    private static final short UID_CLASSIFIER_UID = 56;
    private static final short UID_FORWARD_CLASS_UID = 57;
    private static final short UID_UNNAMED_CLASSIFIER_UID = 58;
    private static final short UID_MACRO_UID = 59;
    private static final short UID_BUILT_IN_MACRO_UID = 60;
    private static final short UID_INCLUDE_UID = 61;
    private static final short UID_INHERITANCE_UID = 62;
    private static final short UID_UNNAMED_OFFSETABLE_DECLARATION_UID = 63;
    private static final short UID_DECLARATION_UID = 64;
    private static final short UID_BUILT_IN_UID = 65;
    private static final short UID_INSTANTIATION_UID = 66;
    private static final short UID_INSTANTIATION_SELF_UID = 67;
    private static final short UID_UNRESOLVED_CLASS = 68;
    private static final short UID_UNRESOLVED_FILE = 69;
    private static final short UID_UNRESOLVED_NAMESPACE = 70;
    public static final short LAST_INDEX = 70;
    private static final Comparator<FileComponentDeclarations.OffsetSortedKey> OSKComparator;
    private static final Comparator<FileComponentMacros.NameSortedKey> NSKComparator;
    private static final Comparator<FileComponentReferences.ReferenceImpl> ReferenceComparator;

    protected UIDObjectFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIDObjectFactory getDefaultFactory() {
        UIDObjectFactory out = theFactory;
        if (out != null) return theFactory;
        out = theFactory;
        Class<UIDObjectFactory> clazz = UIDObjectFactory.class;
        synchronized (UIDObjectFactory.class) {
            out = theFactory;
            if (out != null) return theFactory;
            theFactory = out = new UIDObjectFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theFactory;
        }
    }

    public void writeUID(CsmUID<?> anUID, RepositoryDataOutput aStream) throws IOException {
        if (anUID instanceof SelfPersistent) {
            super.writeSelfPersistent((SelfPersistent)anUID, aStream);
        } else if (anUID != null) {
            CndUtils.assertUnconditional((String)(anUID + ", " + anUID.getObject()));
            super.writeSelfPersistent(null, aStream);
        } else {
            super.writeSelfPersistent(null, aStream);
        }
    }

    public <T> CsmUID<T> readUID(RepositoryDataInput aStream) throws IOException {
        assert (aStream != null);
        SelfPersistent out = super.readSelfPersistent(aStream);
        assert (out == null || out instanceof CsmUID);
        return (CsmUID)out;
    }

    public <T> void writeUIDCollection(Collection<CsmUID<T>> aCollection, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aStream != null);
        if (aCollection == null) {
            aStream.writeInt(-1);
        } else {
            aCollection = sync ? UIDObjectFactory.copySyncCollection(aCollection) : aCollection;
            int collSize = aCollection.size();
            aStream.writeInt(collSize);
            for (CsmUID<T> uid : aCollection) {
                assert (uid != null);
                this.writeUID(uid, aStream);
            }
        }
    }

    public <A, T extends Collection<CsmUID<A>>> T readUIDCollection(T aCollection, RepositoryDataInput aStream) throws IOException {
        assert (aCollection != null);
        assert (aStream != null);
        int collSize = aStream.readInt();
        return this.readUIDCollection(aCollection, aStream, collSize);
    }

    public <A, T extends Collection<CsmUID<A>>> T readUIDCollection(T aCollection, RepositoryDataInput aStream, int collSize) throws IOException {
        if (collSize == -1) {
            return null;
        }
        for (int i = 0; i < collSize; ++i) {
            CsmUID<T> anUID = this.readUID(aStream);
            assert (anUID != null);
            aCollection.add(anUID);
        }
        return aCollection;
    }

    public <T> void writeStringToUIDMap(Map<CharSequence, CsmUID<T>> aMap, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        aMap = sync ? UIDObjectFactory.copySyncMap(aMap) : aMap;
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<CharSequence, CsmUID<T>> anEntry : aMap.entrySet()) {
            CharSequence key = anEntry.getKey();
            assert (key != null);
            PersistentUtils.writeUTF(key, aStream);
            CsmUID<T> anUID = anEntry.getValue();
            assert (anUID != null);
            this.writeUID(anUID, aStream);
        }
    }

    public <T> void writeStringToUIDMapSet(Map<CharSequence, Set<CsmUID<T>>> aMap, RepositoryDataOutput aStream) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<CharSequence, Set<CsmUID<T>>> anEntry : aMap.entrySet()) {
            CharSequence key = anEntry.getKey();
            assert (key != null);
            PersistentUtils.writeUTF(key, aStream);
            collSize = anEntry.getValue().size();
            aStream.writeInt(collSize);
            for (CsmUID<T> anUID : anEntry.getValue()) {
                assert (anUID != null);
                this.writeUID(anUID, aStream);
            }
        }
    }

    public <T> void writeOffsetSortedToUIDMap(Map<FileComponentDeclarations.OffsetSortedKey, CsmUID<T>> aMap, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        aMap = sync ? UIDObjectFactory.copySyncMap(aMap) : aMap;
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<T>> anEntry : aMap.entrySet()) {
            anEntry.getKey().write(aStream);
            CsmUID<T> anUID = anEntry.getValue();
            assert (anUID != null);
            this.writeUID(anUID, aStream);
        }
    }

    public <T> void writeNameSortedToUIDMap(Map<FileComponentMacros.NameSortedKey, CsmUID<T>> aMap, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        aMap = sync ? UIDObjectFactory.copySyncMap(aMap) : aMap;
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<T>> anEntry : aMap.entrySet()) {
            anEntry.getKey().write(aStream);
            CsmUID<T> anUID = anEntry.getValue();
            assert (anUID != null);
            this.writeUID(anUID, aStream);
        }
    }

    public <T> void writeNameSortedToUIDMap2(Map<NamespaceImpl.FileNameSortedKey, CsmUID<T>> aMap, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        aMap = sync ? UIDObjectFactory.copySyncMap(aMap) : aMap;
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<T>> anEntry : aMap.entrySet()) {
            anEntry.getKey().write(aStream);
            CsmUID<T> anUID = anEntry.getValue();
            assert (anUID != null);
            this.writeUID(anUID, aStream);
        }
    }

    public void writeStringToArrayUIDMap(Map<CharSequence, Object> aMap, RepositoryDataOutput aStream, boolean sync) throws IOException {
        assert (aMap != null);
        assert (aStream != null);
        aMap = sync ? UIDObjectFactory.copySyncMap(aMap) : aMap;
        int collSize = aMap.size();
        aStream.writeInt(collSize);
        for (Map.Entry<CharSequence, Object> anEntry : aMap.entrySet()) {
            CharSequence key = anEntry.getKey();
            assert (key != null);
            PersistentUtils.writeUTF(key, aStream);
            Object o = anEntry.getValue();
            if (o instanceof CsmUID) {
                aStream.writeInt(1);
                this.writeUID((CsmUID)o, aStream);
                continue;
            }
            CsmUID[] arr = (CsmUID[])o;
            aStream.writeInt(arr.length);
            for (CsmUID uid : arr) {
                assert (uid != null);
                this.writeUID(uid, aStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<CsmUID<T>> copySyncCollection(Collection<CsmUID<T>> col) {
        ArrayList<CsmUID<T>> out;
        Collection<CsmUID<T>> collection = col;
        synchronized (collection) {
            out = new ArrayList<CsmUID<T>>(col);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Map<K, V> copySyncMap(Map<K, V> map) {
        HashMap<K, V> out;
        Map<K, V> map2 = map;
        synchronized (map2) {
            out = new HashMap<K, V>(map);
        }
        return out;
    }

    public <T> void readStringToUIDMap(Map<CharSequence, CsmUID<T>> aMap, RepositoryDataInput aStream, APTStringManager manager, int collSize) throws IOException {
        for (int i = 0; i < collSize; ++i) {
            CharSequence key = PersistentUtils.readUTF(aStream, manager);
            assert (key != null);
            CsmUID<T> uid = this.readUID(aStream);
            assert (uid != null);
            aMap.put(key, uid);
        }
    }

    public <T> void readStringToUIDMapSet(Map<CharSequence, Set<CsmUID<T>>> aMap, RepositoryDataInput aStream, APTStringManager manager, int collSize) throws IOException {
        for (int i = 0; i < collSize; ++i) {
            CharSequence key = PersistentUtils.readUTF(aStream, manager);
            assert (key != null);
            int aSize = aStream.readInt();
            HashSet<CsmUID<T>> set = new HashSet<CsmUID<T>>(aSize);
            for (int j = 0; j < aSize; ++j) {
                CsmUID<T> uid = this.readUID(aStream);
                assert (uid != null);
                set.add(uid);
            }
            aMap.put(key, set);
        }
    }

    public TreeMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> readOffsetSortedToUIDMap(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        assert (aStream != null);
        HelperDeclarationsSortedMap helper = new HelperDeclarationsSortedMap(this, aStream, manager);
        return new TreeMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>(helper);
    }

    public TreeMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> readNameSortedToUIDMap(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        assert (aStream != null);
        HelperMacrosSortedMap helper = new HelperMacrosSortedMap(this, aStream, manager);
        return new TreeMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>(helper);
    }

    public TreeMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> readReferencesSortedToUIDMap(RepositoryDataInput aStream, CsmUID<CsmFile> fileUID) throws IOException {
        assert (aStream != null);
        HelperReferencesSortedMap helper = new HelperReferencesSortedMap(this, aStream, fileUID);
        return new TreeMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>(helper);
    }

    public TreeMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> readNameSortedToUIDMap2(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        assert (aStream != null);
        HelperNamespaceDefinitionSortedMap helper = new HelperNamespaceDefinitionSortedMap(this, aStream, manager);
        return new TreeMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>(helper);
    }

    public TreeMap<CharSequence, Object> readStringToArrayUIDMap(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        assert (aStream != null);
        HelperCharSequencesSortedMap helper = new HelperCharSequencesSortedMap(this, aStream, manager);
        return new TreeMap<CharSequence, Object>(helper);
    }

    public TreeMap<CharSequence, CsmUID<CsmNamespaceDefinition>> readStringToUIDMap(RepositoryDataInput aStream, APTStringManager manager) throws IOException {
        assert (aStream != null);
        HelperCharSequencesSortedMap2 helper = new HelperCharSequencesSortedMap2(this, aStream, manager);
        return new TreeMap<CharSequence, CsmUID<CsmNamespaceDefinition>>(helper);
    }

    protected short getHandler(Object object) {
        int aHandler;
        if (object instanceof UIDUtilities.ProjectUID) {
            aHandler = 52;
        } else if (object instanceof UIDUtilities.NamespaceUID) {
            aHandler = 53;
        } else if (object instanceof UIDUtilities.FileUID) {
            aHandler = 54;
        } else if (object instanceof UIDUtilities.TypedefUID) {
            aHandler = 55;
        } else if (object instanceof UIDUtilities.ClassifierUID) {
            aHandler = 56;
        } else if (object instanceof UIDUtilities.ForwardClassUID) {
            aHandler = 57;
        } else if (object instanceof UIDUtilities.UnnamedClassifierUID) {
            aHandler = 58;
        } else if (object instanceof UIDUtilities.MacroUID) {
            aHandler = 59;
        } else if (object instanceof SystemMacroImpl.BuiltInMacroUID) {
            aHandler = 60;
        } else if (object instanceof UIDUtilities.IncludeUID) {
            aHandler = 61;
        } else if (object instanceof UIDUtilities.InheritanceUID) {
            aHandler = 62;
        } else if (object instanceof UIDUtilities.UnnamedOffsetableDeclarationUID) {
            aHandler = 63;
        } else if (object instanceof UIDUtilities.DeclarationUID) {
            aHandler = 64;
        } else if (object instanceof BuiltinTypes.BuiltInUID) {
            aHandler = 65;
        } else if (object instanceof Instantiation.InstantiationSelfUID) {
            aHandler = 67;
        } else if (object instanceof UIDUtilities.InstantiationUID) {
            aHandler = 66;
        } else if (object instanceof UIDUtilities.UnresolvedClassUID) {
            aHandler = 68;
        } else if (object instanceof UIDUtilities.UnresolvedFileUID) {
            aHandler = 69;
        } else if (object instanceof UIDUtilities.UnresolvedNamespaceUID) {
            aHandler = 70;
        } else {
            throw new IllegalArgumentException("The UID is an instance of unknow class");
        }
        return (short)aHandler;
    }

    protected SelfPersistent createObject(short handler, RepositoryDataInput aStream) throws IOException {
        SelfPersistent anUID;
        boolean share = false;
        switch (handler) {
            case 52: {
                share = true;
                anUID = new UIDUtilities.ProjectUID(aStream);
                break;
            }
            case 53: {
                share = true;
                anUID = new UIDUtilities.NamespaceUID(aStream);
                break;
            }
            case 54: {
                share = true;
                anUID = new UIDUtilities.FileUID(aStream);
                break;
            }
            case 55: {
                anUID = new UIDUtilities.TypedefUID(aStream);
                break;
            }
            case 56: {
                anUID = new UIDUtilities.ClassifierUID(aStream);
                break;
            }
            case 57: {
                anUID = new UIDUtilities.ForwardClassUID(aStream);
                break;
            }
            case 58: {
                anUID = new UIDUtilities.UnnamedClassifierUID(aStream);
                break;
            }
            case 59: {
                share = true;
                anUID = new UIDUtilities.MacroUID(aStream);
                break;
            }
            case 60: {
                share = true;
                anUID = new SystemMacroImpl.BuiltInMacroUID(aStream);
                break;
            }
            case 61: {
                share = true;
                anUID = new UIDUtilities.IncludeUID(aStream);
                break;
            }
            case 62: {
                share = true;
                anUID = new UIDUtilities.InheritanceUID(aStream);
                break;
            }
            case 63: {
                anUID = new UIDUtilities.UnnamedOffsetableDeclarationUID(aStream);
                break;
            }
            case 64: {
                anUID = new UIDUtilities.DeclarationUID(aStream);
                break;
            }
            case 65: {
                anUID = BuiltinTypes.readUID(aStream);
                share = false;
                break;
            }
            case 67: {
                anUID = new Instantiation.InstantiationSelfUID(aStream);
                share = false;
                break;
            }
            case 66: {
                anUID = new UIDUtilities.InstantiationUID(aStream);
                share = false;
                break;
            }
            case 68: {
                anUID = new UIDUtilities.UnresolvedClassUID(aStream);
                break;
            }
            case 69: {
                anUID = new UIDUtilities.UnresolvedFileUID(aStream);
                break;
            }
            case 70: {
                anUID = new UIDUtilities.UnresolvedNamespaceUID(aStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("The UID is an instance of unknown class: " + handler);
            }
        }
        if (share) {
            assert (anUID != null);
            assert (anUID instanceof CsmUID);
            CsmUID shared = UIDManager.instance().getSharedUID((CsmUID)anUID);
            assert (shared != null);
            assert (shared instanceof SelfPersistent);
            anUID = (SelfPersistent)shared;
        }
        return anUID;
    }

    static {
        OSKComparator = new Comparator<FileComponentDeclarations.OffsetSortedKey>(){

            @Override
            public int compare(FileComponentDeclarations.OffsetSortedKey o1, FileComponentDeclarations.OffsetSortedKey o2) {
                return o1.compareTo(o2);
            }
        };
        NSKComparator = new Comparator<FileComponentMacros.NameSortedKey>(){

            @Override
            public int compare(FileComponentMacros.NameSortedKey o1, FileComponentMacros.NameSortedKey o2) {
                return o1.compareTo(o2);
            }
        };
        ReferenceComparator = new Comparator<FileComponentReferences.ReferenceImpl>(){

            @Override
            public int compare(FileComponentReferences.ReferenceImpl o1, FileComponentReferences.ReferenceImpl o2) {
                return o1.compareTo(o2);
            }
        };
    }

    private static final class HelperReferencesSortedMap
    implements SortedMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final CsmUID<CsmFile> fileUID;

        private HelperReferencesSortedMap(UIDObjectFactory factory, RepositoryDataInput aStream, CsmUID<CsmFile> fileUID) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.fileUID = fileUID;
        }

        @Override
        public Comparator<? super FileComponentReferences.ReferenceImpl> comparator() {
            return ReferenceComparator;
        }

        @Override
        public SortedMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> subMap(FileComponentReferences.ReferenceImpl fromKey, FileComponentReferences.ReferenceImpl toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> headMap(FileComponentReferences.ReferenceImpl toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> tailMap(FileComponentReferences.ReferenceImpl fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentReferences.ReferenceImpl firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentReferences.ReferenceImpl lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size > 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmObject> get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmObject> put(FileComponentReferences.ReferenceImpl key, CsmUID<CsmObject> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmObject> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends FileComponentReferences.ReferenceImpl, ? extends CsmUID<CsmObject>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<FileComponentReferences.ReferenceImpl> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CsmUID<CsmObject>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>> entrySet() {
            return new Set<Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>>(){

                @Override
                public int size() {
                    return HelperReferencesSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperReferencesSortedMap.this.size > 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>> iterator() {
                    return new Iterator<Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperReferencesSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> next() {
                            if (this.current < HelperReferencesSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final CsmUID uid = HelperReferencesSortedMap.this.factory.readUID(HelperReferencesSortedMap.this.aStream);
                                    assert (uid != null);
                                    final FileComponentReferences.ReferenceImpl key = new FileComponentReferences.ReferenceImpl((CsmUID<CsmFile>)HelperReferencesSortedMap.this.fileUID, uid, HelperReferencesSortedMap.this.factory, HelperReferencesSortedMap.this.aStream);
                                    assert (key != null);
                                    return new Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>(){

                                        @Override
                                        public FileComponentReferences.ReferenceImpl getKey() {
                                            return key;
                                        }

                                        @Override
                                        public CsmUID<CsmObject> getValue() {
                                            return uid;
                                        }

                                        @Override
                                        public CsmUID<CsmObject> setValue(CsmUID<CsmObject> value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<FileComponentReferences.ReferenceImpl, CsmUID<CsmObject>>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class HelperCharSequencesSortedMap2
    implements SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperCharSequencesSortedMap2(UIDObjectFactory factory, RepositoryDataInput aStream, APTStringManager manager) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.manager = manager;
        }

        @Override
        public Comparator<? super CharSequence> comparator() {
            return CharSequences.comparator();
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> subMap(CharSequence fromKey, CharSequence toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> headMap(CharSequence toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<CharSequence, CsmUID<CsmNamespaceDefinition>> tailMap(CharSequence fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> put(CharSequence key, CsmUID<CsmNamespaceDefinition> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends CsmUID<CsmNamespaceDefinition>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<CharSequence> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CsmUID<CsmNamespaceDefinition>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> entrySet() {
            return new Set<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>>(){

                @Override
                public int size() {
                    return HelperCharSequencesSortedMap2.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperCharSequencesSortedMap2.this.size == 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> iterator() {
                    return new Iterator<Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperCharSequencesSortedMap2.this.size;
                        }

                        @Override
                        public Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>> next() {
                            if (this.current < HelperCharSequencesSortedMap2.this.size) {
                                ++this.current;
                                try {
                                    final CharSequence key = PersistentUtils.readUTF(HelperCharSequencesSortedMap2.this.aStream, HelperCharSequencesSortedMap2.this.manager);
                                    assert (key != null);
                                    final CsmUID uid = HelperCharSequencesSortedMap2.this.factory.readUID(HelperCharSequencesSortedMap2.this.aStream);
                                    assert (uid != null);
                                    return new Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>(){

                                        @Override
                                        public CharSequence getKey() {
                                            return key;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> getValue() {
                                            return uid;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> setValue(CsmUID<CsmNamespaceDefinition> value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<CharSequence, CsmUID<CsmNamespaceDefinition>>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class HelperCharSequencesSortedMap
    implements SortedMap<CharSequence, Object> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperCharSequencesSortedMap(UIDObjectFactory factory, RepositoryDataInput aStream, APTStringManager manager) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.manager = manager;
        }

        @Override
        public Comparator<? super CharSequence> comparator() {
            return CharSequences.comparator();
        }

        @Override
        public SortedMap<CharSequence, Object> subMap(CharSequence fromKey, CharSequence toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<CharSequence, Object> headMap(CharSequence toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<CharSequence, Object> tailMap(CharSequence fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(CharSequence key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends CharSequence, ? extends Object> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<CharSequence> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<CharSequence, Object>> entrySet() {
            return new Set<Map.Entry<CharSequence, Object>>(){

                @Override
                public int size() {
                    return HelperCharSequencesSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperCharSequencesSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<CharSequence, Object>> iterator() {
                    return new Iterator<Map.Entry<CharSequence, Object>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperCharSequencesSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<CharSequence, Object> next() {
                            if (this.current < HelperCharSequencesSortedMap.this.size) {
                                ++this.current;
                                try {
                                    CsmUID[] value;
                                    final CharSequence key = PersistentUtils.readUTF(HelperCharSequencesSortedMap.this.aStream, HelperCharSequencesSortedMap.this.manager);
                                    assert (key != null);
                                    int arrSize = HelperCharSequencesSortedMap.this.aStream.readInt();
                                    if (arrSize == 1) {
                                        value = HelperCharSequencesSortedMap.this.factory.readUID(HelperCharSequencesSortedMap.this.aStream);
                                        assert (value != null);
                                    } else {
                                        CsmUID[] uids = new CsmUID[arrSize];
                                        for (int k = 0; k < arrSize; ++k) {
                                            CsmUID uid = HelperCharSequencesSortedMap.this.factory.readUID(HelperCharSequencesSortedMap.this.aStream);
                                            assert (uid != null);
                                            uids[k] = uid;
                                        }
                                        value = uids;
                                    }
                                    return new Map.Entry<CharSequence, Object>(){

                                        @Override
                                        public CharSequence getKey() {
                                            return key;
                                        }

                                        @Override
                                        public Object getValue() {
                                            return value;
                                        }

                                        @Override
                                        public Object setValue(Object value2) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<CharSequence, Object> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<CharSequence, Object>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class HelperNamespaceDefinitionSortedMap
    implements SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperNamespaceDefinitionSortedMap(UIDObjectFactory factory, RepositoryDataInput aStream, APTStringManager manager) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.manager = manager;
        }

        @Override
        public Comparator<? super NamespaceImpl.FileNameSortedKey> comparator() {
            return NamespaceImpl.defenitionComparator;
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> subMap(NamespaceImpl.FileNameSortedKey fromKey, NamespaceImpl.FileNameSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> headMap(NamespaceImpl.FileNameSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> tailMap(NamespaceImpl.FileNameSortedKey fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NamespaceImpl.FileNameSortedKey firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NamespaceImpl.FileNameSortedKey lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> put(NamespaceImpl.FileNameSortedKey key, CsmUID<CsmNamespaceDefinition> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmNamespaceDefinition> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends NamespaceImpl.FileNameSortedKey, ? extends CsmUID<CsmNamespaceDefinition>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<NamespaceImpl.FileNameSortedKey> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CsmUID<CsmNamespaceDefinition>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> entrySet() {
            return new Set<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>>(){

                @Override
                public int size() {
                    return HelperNamespaceDefinitionSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperNamespaceDefinitionSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> iterator() {
                    return new Iterator<Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>>(){
                        int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperNamespaceDefinitionSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> next() {
                            if (this.current < HelperNamespaceDefinitionSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final NamespaceImpl.FileNameSortedKey key = new NamespaceImpl.FileNameSortedKey(HelperNamespaceDefinitionSortedMap.this.aStream);
                                    final CsmUID value = HelperNamespaceDefinitionSortedMap.this.factory.readUID(HelperNamespaceDefinitionSortedMap.this.aStream);
                                    assert (value != null);
                                    return new Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>(){

                                        @Override
                                        public NamespaceImpl.FileNameSortedKey getKey() {
                                            return key;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> getValue() {
                                            return value;
                                        }

                                        @Override
                                        public CsmUID<CsmNamespaceDefinition> setValue(CsmUID<CsmNamespaceDefinition> value2) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<NamespaceImpl.FileNameSortedKey, CsmUID<CsmNamespaceDefinition>>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class HelperMacrosSortedMap
    implements SortedMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperMacrosSortedMap(UIDObjectFactory factory, RepositoryDataInput aStream, APTStringManager manager) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.manager = manager;
        }

        @Override
        public Comparator<? super FileComponentMacros.NameSortedKey> comparator() {
            return NSKComparator;
        }

        @Override
        public SortedMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> subMap(FileComponentMacros.NameSortedKey fromKey, FileComponentMacros.NameSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> headMap(FileComponentMacros.NameSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> tailMap(FileComponentMacros.NameSortedKey fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentMacros.NameSortedKey firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentMacros.NameSortedKey lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size > 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmMacro> get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmMacro> put(FileComponentMacros.NameSortedKey key, CsmUID<CsmMacro> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmMacro> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends FileComponentMacros.NameSortedKey, ? extends CsmUID<CsmMacro>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<FileComponentMacros.NameSortedKey> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CsmUID<CsmMacro>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>> entrySet() {
            return new Set<Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>>(){

                @Override
                public int size() {
                    return HelperMacrosSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperMacrosSortedMap.this.size > 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>> iterator() {
                    return new Iterator<Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperMacrosSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> next() {
                            if (this.current < HelperMacrosSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final FileComponentMacros.NameSortedKey key = new FileComponentMacros.NameSortedKey(HelperMacrosSortedMap.this.aStream);
                                    assert (key != null);
                                    final CsmUID uid = HelperMacrosSortedMap.this.factory.readUID(HelperMacrosSortedMap.this.aStream);
                                    assert (uid != null);
                                    return new Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>(){

                                        @Override
                                        public FileComponentMacros.NameSortedKey getKey() {
                                            return key;
                                        }

                                        @Override
                                        public CsmUID<CsmMacro> getValue() {
                                            return uid;
                                        }

                                        @Override
                                        public CsmUID<CsmMacro> setValue(CsmUID<CsmMacro> value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<FileComponentMacros.NameSortedKey, CsmUID<CsmMacro>>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class HelperDeclarationsSortedMap
    implements SortedMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> {
        private final RepositoryDataInput aStream;
        private final int size;
        private final UIDObjectFactory factory;
        private final APTStringManager manager;

        private HelperDeclarationsSortedMap(UIDObjectFactory factory, RepositoryDataInput aStream, APTStringManager manager) throws IOException {
            this.size = aStream.readInt();
            this.aStream = aStream;
            this.factory = factory;
            this.manager = manager;
        }

        @Override
        public Comparator<? super FileComponentDeclarations.OffsetSortedKey> comparator() {
            return OSKComparator;
        }

        @Override
        public SortedMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> subMap(FileComponentDeclarations.OffsetSortedKey fromKey, FileComponentDeclarations.OffsetSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> headMap(FileComponentDeclarations.OffsetSortedKey toKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedMap<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> tailMap(FileComponentDeclarations.OffsetSortedKey fromKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentDeclarations.OffsetSortedKey firstKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileComponentDeclarations.OffsetSortedKey lastKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> put(FileComponentDeclarations.OffsetSortedKey key, CsmUID<CsmOffsetableDeclaration> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CsmUID<CsmOffsetableDeclaration> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends FileComponentDeclarations.OffsetSortedKey, ? extends CsmUID<CsmOffsetableDeclaration>> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<FileComponentDeclarations.OffsetSortedKey> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CsmUID<CsmOffsetableDeclaration>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> entrySet() {
            return new Set<Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>>(){

                @Override
                public int size() {
                    return HelperDeclarationsSortedMap.this.size;
                }

                @Override
                public boolean isEmpty() {
                    return HelperDeclarationsSortedMap.this.size == 0;
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Iterator<Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> iterator() {
                    return new Iterator<Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>>(){
                        private int current = 0;

                        @Override
                        public boolean hasNext() {
                            return this.current < HelperDeclarationsSortedMap.this.size;
                        }

                        @Override
                        public Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> next() {
                            if (this.current < HelperDeclarationsSortedMap.this.size) {
                                ++this.current;
                                try {
                                    final FileComponentDeclarations.OffsetSortedKey key = new FileComponentDeclarations.OffsetSortedKey(HelperDeclarationsSortedMap.this.aStream);
                                    assert (key != null);
                                    final CsmUID uid = HelperDeclarationsSortedMap.this.factory.readUID(HelperDeclarationsSortedMap.this.aStream);
                                    assert (uid != null);
                                    return new Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>(){

                                        @Override
                                        public FileComponentDeclarations.OffsetSortedKey getKey() {
                                            return key;
                                        }

                                        @Override
                                        public CsmUID<CsmOffsetableDeclaration> getValue() {
                                            return uid;
                                        }

                                        @Override
                                        public CsmUID<CsmOffsetableDeclaration> setValue(CsmUID<CsmOffsetableDeclaration> value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<FileComponentDeclarations.OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

