/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.util.Collection;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.generated.CPPParser;

public class TraceUtils {
    public static String getTokenTypeName(Token token) {
        return TraceUtils.getTokenTypeName(token.getType());
    }

    public static String getTokenTypeName(AST ast) {
        return TraceUtils.getTokenTypeName(ast.getType());
    }

    public static String getTokenTypeName(int tokenType) {
        try {
            return CPPParser._tokenNames[tokenType];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String getMacroString(PreprocHandler preprocHandler, Collection<String> logMacros) {
        StringBuilder sb = new StringBuilder();
        if (logMacros != null) {
            for (String macro : logMacros) {
                sb.append(String.format(" #defined(%s)=%b", macro, ((APTMacroCallback)preprocHandler.getMacroMap()).isDefined((CharSequence)macro)));
            }
        }
        return sb.toString();
    }

    public static final String getPreprocStateString(PreprocHandler.State preprocState) {
        return String.format("valid=%b, compile-context=%b, cleaned=%b", preprocState.isValid(), preprocState.isCompileContext(), preprocState.isCleaned());
    }

    public static final String getPreprocStartEntryString(PreprocHandler.State preprocState) {
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)preprocState);
        if (startEntry == null) {
            return "no start entry info";
        }
        return String.format("start file=%s, start-prj=%s", startEntry.getStartFile(), startEntry.getStartFileProject());
    }

    public static String traceMap(Map<?, ?> mapping, int indent) {
        StringBuilder out = new StringBuilder();
        if (mapping != null && !mapping.isEmpty()) {
            for (Map.Entry<?, ?> entry : mapping.entrySet()) {
                TraceUtils.repeat(out, indent, ' ').append("[").append(entry.getKey()).append("]=>{");
                out.append(entry.getValue()).append("}\n");
            }
        }
        return out.toString();
    }

    public static StringBuilder repeat(StringBuilder b, int level, char character) {
        for (int i = 0; i < level; ++i) {
            b.append(character);
        }
        return b;
    }

    public static void updateTraceFlag(String flag, boolean value) {
        TraceFlags.validate(flag, value);
    }
}

