/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.AID;
import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.FileModel;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WrapperParseErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeploymentXmlModel
extends FileModel<DeploymentXmlAppletEntry> {
    private static final String DEPLOYMENT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public DeploymentXmlModel() {
    }

    public DeploymentXmlModel(InputStream in) throws IOException {
        this(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentXmlModel(InputStream in, ParseErrorHandler handler) throws IOException {
        handler = handler == null ? ParseErrorHandler.DEFAULT : handler;
        handler = new WrapperParseErrorHandler(handler, this);
        try {
            handler = new WrapperParseErrorHandler(handler, this);
            try {
                Document doc = null;
                doc = Portability.parse(in);
                NodeList root = doc.getElementsByTagName("deploy");
                if (root == null) {
                    handler.handleError(new IOException("No root element <deploy>"));
                } else if (root.getLength() > 1 || root.getLength() == 0) {
                    handler.handleError(new IOException("Missing or multiple <deploy> elements: " + root.getLength()));
                }
                NodeList applets = doc.getElementsByTagName("applet");
                int len = applets.getLength();
                int ix = 0;
                for (int i = 0; i < len; ++i) {
                    Node nd = applets.item(i);
                    if (nd.getNodeType() != 1) continue;
                    Element el = (Element)nd;
                    try {
                        this.add(new DeploymentXmlAppletEntry(el, ix, handler));
                        ++ix;
                        continue;
                    }
                    catch (IOException ioe) {
                        handler.handleError(ioe);
                    }
                }
            }
            catch (IOException x) {
                handler.handleError(x);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    protected String getProblemInternal() {
        ArrayList<AID> allInstanceAids = new ArrayList<AID>();
        for (DeploymentXmlAppletEntry e : this.getData()) {
            for (DeploymentXmlInstanceEntry i : e.getData()) {
                AID aid = i.getInstanceAID();
                if (aid == null) continue;
                allInstanceAids.add(aid);
            }
        }
        HashSet hs = new HashSet(allInstanceAids);
        if (hs.size() < allInstanceAids.size()) {
            return Portability.getString("DUPLICATE_AIDS");
        }
        if (this.isEmpty()) {
            return Portability.getString("EMPTY_DEPLOYMENT_MODEL");
        }
        return null;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder(DEPLOYMENT_HEADER);
        sb.append(Portability.getString("WARNING_COMMENT"));
        sb.append("<deploy>\n");
        for (DeploymentXmlAppletEntry a : this.getData()) {
            sb.append(a.toXml());
            sb.append('\n');
        }
        sb.append("</deploy>\n");
        return sb.toString();
    }
}

