/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.OverviewControllerUI;
import org.openide.util.Lookup;

public class OverviewController
extends AbstractController {
    public static final String SHOW_SYSPROPS_URL = "file:/sysprops";
    public static final String SHOW_THREADS_URL = "file:/threads";
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static final String THREAD_URL_PREFIX = "file://thread/";
    private static final String LINE_PREFIX = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private HeapFragmentWalker heapFragmentWalker;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;
    private Properties systemProperties;
    private String stackTrace;
    private JavaClass java_lang_Class;
    private ThreadObjectGCRoot oome;
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;

    public OverviewController(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.heapFragmentWalker = summaryController.getHeapFragmentWalker();
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OverviewControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OverviewControllerUI(this);
    }

    void showInThreads(Instance instance) {
        ((OverviewControllerUI)((Object)this.getPanel())).showInThreads(instance);
    }

    public String computeSummary() {
        File file = this.heapFragmentWalker.getHeapDumpFile();
        Heap heap = this.heapFragmentWalker.getHeapFragment();
        HeapSummary hsummary = heap.getSummary();
        long finalizers = this.computeFinalizers(heap);
        int nclassloaders = 0;
        JavaClass cl = heap.getJavaClassByName("java.lang.ClassLoader");
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        this.oome = this.getOOMEThread(heap);
        if (cl != null) {
            nclassloaders = cl.getInstancesCount();
            Collection jcs = cl.getSubClasses();
            for (JavaClass jc : jcs) {
                nclassloaders += jc.getInstancesCount();
            }
        }
        String filename = LINE_PREFIX + Bundle.OverviewController_FileItemString(file != null && file.exists() ? file.getAbsolutePath() : Bundle.OverviewController_NotAvailableMsg());
        String filesize = LINE_PREFIX + Bundle.OverviewController_FileSizeItemString(file != null && file.exists() ? numberFormat.format((double)file.length() / 1048576.0) + " MB" : Bundle.OverviewController_NotAvailableMsg());
        String dateTaken = LINE_PREFIX + Bundle.OverviewController_DateTakenItemString(new Date(hsummary.getTime()).toString());
        String liveBytes = LINE_PREFIX + Bundle.OverviewController_TotalBytesItemString(numberFormat.format(hsummary.getTotalLiveBytes()));
        String liveClasses = LINE_PREFIX + Bundle.OverviewController_TotalClassesItemString(numberFormat.format(heap.getAllClasses().size()));
        String liveInstances = LINE_PREFIX + Bundle.OverviewController_TotalInstancesItemString(numberFormat.format(hsummary.getTotalLiveInstances()));
        String classloaders = LINE_PREFIX + Bundle.OverviewController_ClassloadersItemString(numberFormat.format(nclassloaders));
        String gcroots = LINE_PREFIX + Bundle.OverviewController_GcRootsItemString(numberFormat.format(heap.getGCRoots().size()));
        String finalizersInfo = LINE_PREFIX + Bundle.OverviewController_FinalizersItemString(finalizers >= 0L ? numberFormat.format(finalizers) : Bundle.OverviewController_NotAvailableMsg());
        String oomeString = "";
        if (this.oome != null) {
            Instance thread = this.oome.getInstance();
            String threadName = OverviewController.htmlize(this.getThreadName(heap, thread));
            String threadUrl = "<a href='file://thread/" + thread.getJavaClass().getName() + "/" + thread.getInstanceId() + "'>" + threadName + "</a>";
            oomeString = "<br><br>&nbsp;&nbsp;&nbsp;&nbsp;" + Bundle.OverviewController_OOMELabelString() + "<br>" + LINE_PREFIX + Bundle.OverviewController_OOMEItemString(threadUrl);
        }
        String memoryRes = Icons.getResource((String)"ProfilerIcons.HeapDump");
        return "<b><img border='0' align='bottom' src='nbresloc:/" + memoryRes + "'>&nbsp;&nbsp;" + Bundle.OverviewController_SummaryString() + "</b><br><hr>" + dateTaken + "<br>" + filename + "<br>" + filesize + "<br><br>" + liveBytes + "<br>" + liveClasses + "<br>" + liveInstances + "<br>" + classloaders + "<br>" + gcroots + "<br>" + finalizersInfo + oomeString;
    }

    public String computeEnvironment() {
        String sysinfoRes = Icons.getResource((String)"HeapWalkerIcons.SystemInfo");
        String header = "<b><img border='0' align='bottom' src='nbresloc:/" + sysinfoRes + "'>&nbsp;&nbsp;" + Bundle.OverviewController_EnvironmentString() + "</b><br><hr>";
        Properties sysprops = this.getSystemProperties();
        if (sysprops == null) {
            return header + LINE_PREFIX + Bundle.OverviewController_NotAvailableMsg();
        }
        String patchLevel = sysprops.getProperty("sun.os.patch.level", "");
        String os = LINE_PREFIX + Bundle.OverviewController_OsItemString(sysprops.getProperty("os.name", Bundle.OverviewController_NotAvailableMsg()), sysprops.getProperty("os.version", ""), "unknown".equals(patchLevel) ? "" : patchLevel);
        String arch = LINE_PREFIX + Bundle.OverviewController_ArchitectureItemString(sysprops.getProperty("os.arch", Bundle.OverviewController_NotAvailableMsg()), sysprops.getProperty("sun.arch.data.model", "?") + "bit");
        String jdk = LINE_PREFIX + Bundle.OverviewController_JavaHomeItemString(sysprops.getProperty("java.home", Bundle.OverviewController_NotAvailableMsg()));
        String version = LINE_PREFIX + Bundle.OverviewController_JavaVersionItemString(sysprops.getProperty("java.version", Bundle.OverviewController_NotAvailableMsg()));
        String jvm = LINE_PREFIX + Bundle.OverviewController_JvmItemString(sysprops.getProperty("java.vm.name", Bundle.OverviewController_NotAvailableMsg()), sysprops.getProperty("java.vm.version", ""), sysprops.getProperty("java.vm.info", ""));
        String vendor = LINE_PREFIX + Bundle.OverviewController_JavaVendorItemString(sysprops.getProperty("java.vendor", Bundle.OverviewController_NotAvailableMsg()));
        return header + os + "<br>" + arch + "<br>" + jdk + "<br>" + version + "<br>" + jvm + "<br>" + vendor;
    }

    public String computeSystemProperties(boolean showSystemProperties) {
        String propertiesRes = Icons.getResource((String)"HeapWalkerIcons.Properties");
        String header = "<b><img border='0' align='bottom' src='nbresloc:/" + propertiesRes + "'>&nbsp;&nbsp;" + Bundle.OverviewController_SystemPropertiesString() + "</b><br><hr>";
        Properties sysprops = this.getSystemProperties();
        if (sysprops == null) {
            return header + LINE_PREFIX + Bundle.OverviewController_NotAvailableMsg();
        }
        return header + (showSystemProperties ? this.formatSystemProperties(sysprops) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/sysprops'>" + Bundle.OverviewController_ShowSysPropsLinkString() + "</a>");
    }

    public String computeThreads(boolean showThreads) {
        String threadsWindowRes = Icons.getResource((String)"ProfilerIcons.WindowThreads");
        return "<b><img border='0' align='bottom' src='nbresloc:/" + threadsWindowRes + "'>&nbsp;&nbsp;" + Bundle.OverviewController_ThreadsString() + "</b><br><hr>" + (showThreads ? this.getStackTrace() : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/threads'>" + Bundle.OverviewController_ShowThreadsLinkString() + "</a><br>&nbsp;");
    }

    public void showURL(final String _urls) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                String urls = _urls;
                if (urls.startsWith(OverviewController.OPEN_THREADS_URL)) {
                    urls = urls.substring(OverviewController.OPEN_THREADS_URL.length());
                    String[] parts = urls.split("\\|");
                    String className = parts[0];
                    String method = parts[1];
                    int linenumber = Integer.parseInt(parts[2]);
                    GoToSource.openSource((Lookup.Provider)OverviewController.this.heapFragmentWalker.getHeapDumpProject(), (String)className, (String)method, (int)linenumber);
                } else if (urls.startsWith(OverviewController.INSTANCE_URL_PREFIX)) {
                    urls = urls.substring(OverviewController.INSTANCE_URL_PREFIX.length());
                    final String[] id = urls.split("/");
                    long instanceId = Long.parseLong(id[2]);
                    final Instance i = OverviewController.this.heapFragmentWalker.getHeapFragment().getInstanceByID(instanceId);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (i != null) {
                                OverviewController.this.heapFragmentWalker.getClassesController().showInstance(i);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveInstanceMsg(id[1], id[0]));
                            }
                        }
                    });
                } else if (urls.startsWith(OverviewController.CLASS_URL_PREFIX)) {
                    urls = urls.substring(OverviewController.CLASS_URL_PREFIX.length());
                    final String[] id = urls.split("/");
                    long jclsid = Long.parseLong(id[1]);
                    final JavaClass c = OverviewController.this.heapFragmentWalker.getHeapFragment().getJavaClassByID(jclsid);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (c != null) {
                                OverviewController.this.heapFragmentWalker.getClassesController().showClass(c);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(id[0]));
                            }
                        }
                    });
                } else if (urls.startsWith(OverviewController.THREAD_URL_PREFIX)) {
                    urls = urls.substring(OverviewController.THREAD_URL_PREFIX.length());
                    String[] id = urls.split("/");
                    long threadid = Long.parseLong(id[1]);
                    final Instance i = OverviewController.this.heapFragmentWalker.getHeapFragment().getInstanceByID(threadid);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (i != null) {
                                OverviewController.this.showInThreads(i);
                            } else {
                                System.err.println(">>> OverviewController: unexpected null instance for showInThreads");
                            }
                        }
                    });
                }
            }
        });
    }

    private long computeFinalizers(Heap heap) {
        Long len;
        Instance queue;
        JavaClass finalizerClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (finalizerClass != null && (queue = (Instance)finalizerClass.getValueOfStaticField("queue")) != null && (len = (Long)queue.getValueOfField("queueLength")) != null) {
            return len;
        }
        return -1L;
    }

    private ThreadObjectGCRoot getOOMEThread(Heap heap) {
        Collection roots = heap.getGCRoots();
        for (GCRoot root : roots) {
            ThreadObjectGCRoot threadRoot;
            StackTraceElement[] stackTrace;
            if (!root.getKind().equals("thread object") || (stackTrace = (threadRoot = (ThreadObjectGCRoot)root).getStackTrace()) == null || stackTrace.length < 1) continue;
            StackTraceElement ste = stackTrace[0];
            if (!OutOfMemoryError.class.getName().equals(ste.getClassName()) || !"<init>".equals(ste.getMethodName())) continue;
            return threadRoot;
        }
        return null;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.heapFragmentWalker.getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String formatSystemProperties(Properties properties) {
        StringBuilder text = new StringBuilder(200);
        ArrayList keys = new ArrayList();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement());
        }
        Collections.sort(keys);
        for (String key : keys) {
            String val = properties.getProperty(key);
            if ("line.separator".equals(key) && val != null) {
                val = val.replace("\n", "\\n");
                val = val.replace("\r", "\\r");
            }
            text.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            text.append(key);
            text.append("</b>=");
            text.append(val);
            text.append("</nobr><br>");
        }
        return text.toString();
    }

    private synchronized String getStackTrace() {
        if (this.stackTrace == null) {
            boolean gotoSourceAvailable = this.heapFragmentWalker.getHeapDumpProject() != null && GoToSource.isAvailable();
            StringBuilder sb = new StringBuilder();
            Heap h = this.heapFragmentWalker.getHeapFragment();
            Collection roots = h.getGCRoots();
            Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = this.computeJavaFrameMap(roots);
            sb.append("<pre>");
            for (GCRoot root : roots) {
                if (!root.getKind().equals("thread object")) continue;
                ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
                Instance threadInstance = threadRoot.getInstance();
                if (threadInstance != null) {
                    String threadName = this.getThreadName(h, threadInstance);
                    Boolean daemon = (Boolean)threadInstance.getValueOfField("daemon");
                    Integer priority = (Integer)threadInstance.getValueOfField("priority");
                    Long threadId = (Long)threadInstance.getValueOfField("tid");
                    Integer threadStatus = (Integer)threadInstance.getValueOfField("threadStatus");
                    StackTraceElement[] stack = threadRoot.getStackTrace();
                    Map<Integer, List<JavaFrameGCRoot>> localsMap = javaFrameMap.get(threadRoot);
                    String style = "";
                    if (threadRoot.equals(this.oome)) {
                        style = "style=\"color: #FF0000\"";
                    }
                    sb.append("&nbsp;&nbsp;<a name=").append(threadInstance.getInstanceId()).append("></a><b ").append(style).append(">");
                    sb.append("\"").append(OverviewController.htmlize(threadName)).append("\"").append(daemon != false ? " daemon" : "").append(" prio=").append(priority);
                    if (threadId != null) {
                        sb.append(" tid=").append(threadId);
                    }
                    if (threadStatus != null) {
                        Thread.State tState = OverviewController.toThreadState(threadStatus);
                        sb.append(" ").append((Object)tState);
                    }
                    sb.append("</b><br>");
                    if (stack != null) {
                        for (int i = 0; i < stack.length; ++i) {
                            List<JavaFrameGCRoot> locals;
                            String stackElHref;
                            StackTraceElement stackElement = stack[i];
                            String stackElementText = OverviewController.htmlize(stackElement.toString());
                            if (gotoSourceAvailable) {
                                String className = stackElement.getClassName();
                                String method = stackElement.getMethodName();
                                int lineNo = stackElement.getLineNumber();
                                String stackUrl = OPEN_THREADS_URL + className + "|" + method + "|" + lineNo;
                                stackElHref = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
                            } else {
                                stackElHref = stackElementText;
                            }
                            sb.append("    at ").append(stackElHref).append("<br>");
                            if (localsMap == null || (locals = localsMap.get(i)) == null) continue;
                            for (JavaFrameGCRoot localVar : locals) {
                                Instance localInstance = localVar.getInstance();
                                if (localInstance != null) {
                                    sb.append("       Local Variable: ").append(this.printInstance(localInstance)).append("<br>");
                                    continue;
                                }
                                sb.append("       Unknown Local Variable<br>");
                            }
                        }
                    }
                } else {
                    sb.append("&nbsp;&nbsp;Unknown thread<br>");
                }
                sb.append("<br>");
            }
            sb.append("</pre>");
            this.stackTrace = sb.toString();
        }
        return this.stackTrace;
    }

    private String getThreadName(Heap heap, Instance threadInstance) {
        Object threadName = threadInstance.getValueOfField("name");
        if (threadName == null) {
            return "*null*";
        }
        return DetailsSupport.getDetailsString((Instance)threadName, heap);
    }

    private Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot root : roots) {
            ArrayList<JavaFrameGCRoot> locals;
            if (!"Java frame".equals(root.getKind())) continue;
            JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
            ThreadObjectGCRoot threadObj = frameGCroot.getThreadGCRoot();
            Integer frameNo = frameGCroot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> stackMap = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)javaFrameMap.get(threadObj);
            if (stackMap == null) {
                stackMap = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                javaFrameMap.put(threadObj, stackMap);
            }
            if ((locals = (ArrayList<JavaFrameGCRoot>)stackMap.get(frameNo)) == null) {
                locals = new ArrayList<JavaFrameGCRoot>(2);
                stackMap.put(frameNo, locals);
            }
            locals.add(frameGCroot);
        }
        return javaFrameMap;
    }

    private String printInstance(Instance in) {
        JavaClass javaClass;
        JavaClass jcls = in.getJavaClass();
        if (jcls == null) {
            return "unknown instance #" + in.getInstanceId();
        }
        if (jcls.equals(this.getJavaClass()) && (javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(in.getInstanceId())) != null) {
            String className = javaClass.getName();
            return "<a href='file://class/" + className + "/" + javaClass.getJavaClassId() + "'>class " + className + "</a>";
        }
        String className = jcls.getName();
        return "<a href='file://instance/" + className + "/" + in.getInstanceNumber() + "/" + in.getInstanceId() + "' name='" + in.getInstanceId() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }

    private JavaClass getJavaClass() {
        if (this.java_lang_Class == null) {
            this.java_lang_Class = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(Class.class.getName());
        }
        return this.java_lang_Class;
    }

    private static String htmlize(String value) {
        return value.replace(">", "&gt;").replace("<", "&lt;");
    }

    private static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }
}

