/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class J2SESampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2se-project/3";
    private static final String SOURCE_ENCODING = "source.encoding";

    private J2SESampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        FileObject prjLoc = J2SESampleProjectGenerator.createProjectFolder(projectLocation);
        if (template.getExt().endsWith("zip")) {
            block17: {
                J2SESampleProjectGenerator.unzip(template.getInputStream(), prjLoc);
                try {
                    File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                    Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
                    NodeList nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                    if (nlist == null) break block17;
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        J2SESampleProjectGenerator.replaceText(e, name);
                    }
                    J2SESampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                    File privateProperties = J2SESampleProjectGenerator.createPrivateProperties(prjLoc);
                    Properties p = new Properties();
                    p.put("javadoc.preview", "true");
                    p.put("compile.on.save", "true");
                    OutputStream out = new FileOutputStream(privateProperties);
                    try {
                        p.store(out, null);
                    }
                    finally {
                        out.close();
                    }
                    FileObject projectProps = prjLoc.getFileObject("nbproject/project.properties");
                    if (projectProps == null) break block17;
                    FileLock lock = projectProps.lock();
                    try {
                        EditableProperties props = new EditableProperties();
                        InputStream in = projectProps.getInputStream();
                        try {
                            props.load(in);
                        }
                        finally {
                            in.close();
                        }
                        props.put(SOURCE_ENCODING, "UTF-8");
                        out = projectProps.getOutputStream(lock);
                        try {
                            props.store(out);
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try {
                    OutputStream out = destFile.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private static File createPrivateProperties(FileObject fo) throws IOException {
        String[] nameElements = "nbproject/private/private.properties".split("/");
        for (int i = 0; i < nameElements.length - 1; ++i) {
            FileObject tmp = fo.getFileObject(nameElements[i]);
            if (tmp == null) {
                tmp = fo.createFolder(nameElements[i]);
            }
            fo = tmp;
        }
        fo = fo.createData(nameElements[nameElements.length - 1]);
        return FileUtil.toFile((FileObject)fo);
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

