/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.openide.util.Exceptions;

public abstract class ListenerProxy<T> {
    private final List<PropertyChangeListener> l = new LinkedList<PropertyChangeListener>();
    private final T obj;
    private final PropertyChangeListener pcl = new PCL(this);

    protected ListenerProxy(T obj) {
        this.obj = obj;
    }

    protected final T get() {
        return this.obj;
    }

    final void addNotify() {
        this.attach(this.get(), this.pcl);
    }

    final void removeNotify() {
        this.detach(this.get(), this.pcl);
    }

    protected final Object lock() {
        return this.l;
    }

    protected abstract void attach(T var1, PropertyChangeListener var2);

    protected abstract void detach(T var1, PropertyChangeListener var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.l;
        synchronized (list) {
            boolean empty = this.l.isEmpty();
            this.l.add(listener);
            if (empty) {
                this.addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.l;
        synchronized (list) {
            this.l.remove(listener);
            if (this.l.isEmpty()) {
                this.removeNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fire(String name, Object old, Object nue) {
        PropertyChangeListener[] ls;
        List<PropertyChangeListener> list = this.l;
        synchronized (list) {
            ls = this.l.toArray(new PropertyChangeListener[this.l.size()]);
        }
        if (ls.length > 0) {
            Fire f = new Fire(ls, name, old, nue);
            this.fireChanges(f);
        }
    }

    protected abstract void onChange(String var1, Object var2, Object var3);

    protected void fireChanges(Runnable run) {
        run.run();
    }

    private final class Fire
    implements Runnable {
        private final String name;
        private final PropertyChangeListener[] ls;
        private final Object old;
        private final Object nue;

        private Fire(PropertyChangeListener[] ls, String name, Object old, Object nue) {
            this.ls = ls;
            this.name = name;
            this.old = old;
            this.nue = nue;
        }

        @Override
        public void run() {
            PropertyChangeEvent pce = new PropertyChangeEvent(ListenerProxy.this, this.name, this.old, this.nue);
            for (PropertyChangeListener p : this.ls) {
                try {
                    p.propertyChange(pce);
                }
                catch (RuntimeException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private static final class PCL
    implements PropertyChangeListener {
        private final ListenerProxy<?> proxy;

        PCL(ListenerProxy<?> proxy) {
            this.proxy = proxy;
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            this.proxy.onChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

