/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdMap<KeyT, ValueT>
implements Native.assignable<std.map<KeyT, ValueT>>,
NativeCloneable<std.map<KeyT, ValueT>>,
Iterable<std_pair.pair<KeyT, ValueT>>,
Destructors.ClassWithDestructor {
    protected ValueT defaultValue;
    protected TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> treeMap;

    protected StdMap(ValueT defaultValue) {
        this(null, defaultValue);
    }

    protected StdMap(Comparator<KeyT> comparator, ValueT defaultValue) {
        this.treeMap = new TreeMap(comparator != null ? comparator : new DefaultComparator());
        this.defaultValue = defaultValue;
    }

    protected StdMap(std.map<KeyT, ValueT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    @Override
    public std.map<KeyT, ValueT> $assign(std.map<KeyT, ValueT> other) {
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put(entry.getKey(), std.make_pair(entry.getKey(), this.isDataPointerLike() ? ((std_pair.pair)entry.getValue()).second : Native.$tryClone(((std_pair.pair)entry.getValue()).second)));
        }
        return (std.map)this;
    }

    public void swap(std.map<KeyT, ValueT> other) {
        TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        ValueT tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public ValueT $at(KeyT key) {
        std_pair.pair<KeyT, ValueT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair(key, Native.$tryClone(this.defaultValue));
            this.treeMap.put(key, out);
        }
        return (ValueT)out.second;
    }

    public void $set(KeyT key, ValueT val) {
        this.treeMap.put(key, std.make_pair(key, this.isDataPointerLike() ? val : Native.$tryClone(val)));
    }

    public type$ref<ValueT> ref$at(final KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(key, std.make_pair(key, Native.$tryClone(this.defaultValue)));
        }
        return new type$ref<ValueT>(){

            @Override
            public ValueT $deref() {
                return StdMap.this.treeMap.get((Object)key).second;
            }

            @Override
            public ValueT $set(ValueT value) {
                StdMap.this.treeMap.get((Object)key).second = StdMap.this.isDataPointerLike() ? value : Native.$tryClone(value);
                return value;
            }

            @Override
            public type$ptr<ValueT> deref$ptr() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        return this.treeMap.size();
    }

    public boolean empty() {
        return this.treeMap.isEmpty();
    }

    public void clear() {
        if (!this.isDataPointerLike()) {
            for (Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> entry : this.treeMap.entrySet()) {
                Native.destroy(entry.getValue().second);
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator<KeyT, ValueT>> insert(std_pair.pair<KeyT, ValueT> val) {
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(val.first, std.make_pair(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
        return std.make_pair_T_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pair<KeyT, ValueT>> I, type$iterator<?, std_pair.pair<KeyT, ValueT>> E) {
        while (Native.$noteq_iter(I, E)) {
            std_pair.pair<KeyT, ValueT> val = I.$star();
            this.treeMap.put(val.first, std.make_pair(val.first, this.isDataPointerLike() ? val.second : Native.$tryClone(val.second)));
            I.$preInc();
        }
    }

    public void erase(iterator<KeyT, ValueT> position) {
        if (!this.isDataPointerLike()) {
            Native.destroy(((std_pair.pair)position.$star()).second);
        }
        ((iterator)position).erase();
    }

    public boolean erase(KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        if (!this.isDataPointerLike()) {
            Native.destroy(this.treeMap.get(key).second);
        }
        this.treeMap.remove(key);
        return true;
    }

    public iterator<KeyT, ValueT> lower_bound(KeyT key) {
        KeyT lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<KeyT, ValueT> upper_bound(KeyT key) {
        iterator<KeyT, ValueT> upperBound = this.lower_bound(key);
        while (upperBound.$noteq(this.end()) && this.treeMap.comparator().compare(key, ((iterator)upperBound).getKey()) >= 0) {
            upperBound.$preInc();
        }
        return upperBound;
    }

    public iterator<KeyT, ValueT> begin() {
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<KeyT, ValueT> end() {
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pair<KeyT, ValueT>> iterator() {
        return new JavaIterator<std_pair.pair<KeyT, ValueT>>(this.begin(), this.end());
    }

    public boolean count(KeyT key) {
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(KeyT key, ValueT val) {
        std_pair.pair<KeyT, ValueT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public iterator<KeyT, ValueT> find(KeyT key) {
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        Comparator<KeyT> comparator = this.treeMap.comparator();
        iterator<KeyT, ValueT> I = this.begin();
        iterator<KeyT, ValueT> E = this.end();
        while (I.$noteq(E)) {
            if (comparator.compare(((iterator)I).getKey(), key) == 0) {
                return I;
            }
            I.$preInc();
        }
        throw new AssertionError((Object)"Why not found???");
    }

    @Override
    public std.map<KeyT, ValueT> clone() {
        return new std.map((std.map)this);
    }

    @Override
    public void $destroy() {
        this.clear();
    }

    private boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        return "StdMap{" + this.treeMap + "}";
    }

    public static class iterator<KeyT, ValueT>
    implements type$iterator<iterator<KeyT, ValueT>, std_pair.pair<KeyT, ValueT>> {
        private final ValueT defaultValue;
        private final TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> map;
        private final boolean _const;
        private Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> currentEntry;

        private iterator(TreeMap<KeyT, std_pair.pair<KeyT, ValueT>> map2, Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> curr, ValueT defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map2;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private KeyT getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pair<KeyT, ValueT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pair<KeyT, ValueT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pair<KeyT, ValueT>> star$ref() {
            return new type$ref<std_pair.pair<KeyT, ValueT>>(){
                private final Map.Entry<KeyT, std_pair.pair<KeyT, ValueT>> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pair<KeyT, ValueT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pair<KeyT, ValueT> $set(std_pair.pair<KeyT, ValueT> value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pair<KeyT, ValueT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<KeyT, ValueT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT, ValueT> $postInc() {
            Object cloned = this.clone();
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<KeyT, ValueT> clone() {
            return new iterator<KeyT, ValueT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<KeyT, ValueT> const_clone() {
            return new iterator<KeyT, ValueT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<KeyT, ValueT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT, ValueT> $postDec() {
            Object cloned = this.clone();
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<KeyT, ValueT> $inc(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $dec(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT, ValueT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return this.defaultValue == null;
        }
    }

    private static class DefaultComparator<KeyT>
    implements Comparator<KeyT> {
        private DefaultComparator() {
        }

        @Override
        public int compare(KeyT o1, KeyT o2) {
            if (o1 instanceof Native.ComparableLower) {
                if (((Native.ComparableLower)o1).$less(o2)) {
                    return -1;
                }
                return ((Native.ComparableLower)o2).$less(o1) ? 1 : 0;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
        }
    }
}

