/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.util.Hashtable;
import javax.servlet.http.HttpUtils;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.Util;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.openide.util.NbBundle;

class EditPanelRequest
extends DataDisplay {
    private static final boolean debug = false;
    private static final String[] methodChoices = new String[]{"GET", "POST", "PUT"};
    private DisplayTable requestTable = null;
    private MonitorData monitorData = null;

    EditPanelRequest() {
    }

    void redisplayData() {
        this.setData(this.monitorData);
    }

    void setData(MonitorData md) {
        this.monitorData = md;
        this.setRequestTable();
        this.removeAll();
        int gridy = -1;
        int fullGridWidth = 0;
        this.addGridBagComponent(this, EditPanelRequest.createTopSpacer(), 0, ++gridy, fullGridWidth, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelRequest.createHeaderLabel(NbBundle.getBundle((Class)EditPanelRequest.class).getString("MON_Request_19"), NbBundle.getBundle((Class)EditPanelRequest.class).getString("ACS_MON_Request_19A11yDesc"), this.requestTable), 0, ++gridy, fullGridWidth, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.requestTable, 0, ++gridy, fullGridWidth, 1, 1.0, 0.0, 18, 2, tableInsets, 0, 0);
        this.addGridBagComponent(this, EditPanelRequest.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
        int gridx = -1;
        this.addGridBagComponent(this, EditPanelRequest.createGlue(), ++gridx, ++gridy, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    void setRequestTable() {
        String[] requestCategories = new String[]{NbBundle.getBundle((Class)EditPanelRequest.class).getString("MON_Request_URI"), NbBundle.getBundle((Class)EditPanelRequest.class).getString("MON_Method"), NbBundle.getBundle((Class)EditPanelRequest.class).getString("MON_Protocol")};
        this.requestTable = new DisplayTable(requestCategories, 1);
        RequestData rd = this.monitorData.getRequestData();
        this.requestTable.setValueAt(rd.getAttributeValue("uri"), 0, 1);
        this.requestTable.setValueAt(rd.getAttributeValue("method"), 1, 1);
        this.requestTable.setValueAt(rd.getAttributeValue("protocol"), 2, 1);
        JComboBox box = this.requestTable.setChoices(1, 1, methodChoices, false);
        box.getAccessibleContext().setAccessibleName(requestCategories[1]);
        box.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EditPanelRequest.class, (String)"ACS_MON_RequestMethod"));
        this.requestTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelRequest.class).getString("ACS_MON_RequestTable_19A11yName"));
        this.requestTable.setToolTipText(NbBundle.getBundle((Class)EditPanelRequest.class).getString("ACS_MON_RequestTable_19A11yDesc"));
        this.requestTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                RequestData rd = EditPanelRequest.this.monitorData.getRequestData();
                String method = rd.getAttributeValue("method");
                String newMethod = (String)EditPanelRequest.this.requestTable.getValueAt(1, 1);
                if (method != null && !method.equals(newMethod)) {
                    rd.setAttributeValue("method", newMethod);
                    if (method.equals("GET") && newMethod.equals("POST")) {
                        try {
                            String queryString = rd.getAttributeValue("queryString");
                            Hashtable ht = HttpUtils.parseQueryString((String)queryString);
                            rd.setAttributeValue("queryString", "");
                        }
                        catch (Exception queryString) {}
                    } else if (method.equals("POST") && newMethod.equals("GET")) {
                        Util.addParametersToQuery(rd);
                    }
                }
                String uri = (String)EditPanelRequest.this.requestTable.getValueAt(0, 1);
                uri = uri.trim();
                String protocol = (String)EditPanelRequest.this.requestTable.getValueAt(2, 1);
                protocol = protocol.trim();
                rd.setAttributeValue("uri", uri);
                rd.setAttributeValue("protocol", protocol);
            }
        });
    }

    public void repaint() {
        super.repaint();
    }

    void log(String s) {
        System.out.println("EditPanelRequest::" + s);
    }
}

