/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.ValidateCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.netbeans.modules.bugzilla.repository.RepositoryPanel;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.team.commons.LogUtils;
import org.openide.util.Cancellable;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BugzillaRepositoryController
implements RepositoryController,
DocumentListener,
ActionListener {
    private final BugzillaRepository repository;
    private final RepositoryPanel panel;
    private String errorMessage;
    private boolean validateError;
    private boolean populated = false;
    private TaskRunner taskRunner;
    private RequestProcessor rp;
    private final ChangeSupport support = new ChangeSupport((Object)this);

    BugzillaRepositoryController(BugzillaRepository repository) {
        this.repository = repository;
        this.panel = new RepositoryPanel(this);
        this.panel.nameField.getDocument().addDocumentListener(this);
        this.panel.userField.getDocument().addDocumentListener(this);
        this.panel.urlField.getDocument().addDocumentListener(this);
        this.panel.psswdField.getDocument().addDocumentListener(this);
        this.panel.validateButton.addActionListener(this);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpContext() {
        return new HelpCtx("org.netbeans.modules.bugzilla.repository.BugzillaRepository");
    }

    public boolean isValid() {
        return this.validate();
    }

    private String getUrl() {
        String url = this.panel.urlField.getText().trim();
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    private String getName() {
        return this.panel.nameField.getText().trim();
    }

    private String getUser() {
        return this.panel.userField.getText();
    }

    private char[] getPassword() {
        return this.panel.psswdField.getPassword();
    }

    private String getHttpUser() {
        return this.panel.httpCheckBox.isSelected() ? this.panel.httpUserField.getText() : null;
    }

    private char[] getHttpPassword() {
        return this.panel.httpCheckBox.isSelected() ? this.panel.httpPsswdField.getPassword() : new char[]{};
    }

    private boolean isLocalUserEnabled() {
        return this.panel.cbEnableLocalUsers.isSelected();
    }

    private boolean validate() {
        String url;
        if (this.validateError) {
            UIUtils.runInAWT((Runnable)new Runnable(){

                @Override
                public void run() {
                    BugzillaRepositoryController.this.panel.setValidateEnabled(true);
                }
            });
            return false;
        }
        this.panel.setValidateEnabled(false);
        if (!this.populated) {
            return false;
        }
        this.errorMessage = null;
        String name = this.panel.nameField.getText().trim();
        if (name.equals("")) {
            this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_MISSING_NAME");
            return false;
        }
        Collection repositories = null;
        if (this.repository.getTaskRepository() == null) {
            repositories = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
            for (Repository repo : repositories) {
                if (!name.equals(repo.getDisplayName())) continue;
                this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_NAME_ALREADY_EXISTS");
                return false;
            }
        }
        if ((url = this.getUrl()).equals("")) {
            this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_MISSING_URL");
            return false;
        }
        if (!this.isValid(url) || "http://".equals(url) || "https://".equals(url)) {
            this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_WRONG_URL_FORMAT");
            return false;
        }
        if (url.startsWith("http://netbeans.org/bugzilla")) {
            this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_WRONG_NETBEANS_URL_FORMAT");
            return false;
        }
        this.panel.setValidateEnabled(true);
        if (this.repository.getTaskRepository() == null) {
            for (Repository repo : repositories) {
                if (!url.trim().equals(repo.getUrl())) continue;
                this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_URL_ALREADY_EXISTS");
                return false;
            }
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void applyChanges() {
        this.repository.setInfoValues(this.getName(), this.getUrl(), this.getUser(), this.getPassword(), this.getHttpUser(), this.getHttpPassword(), this.isLocalUserEnabled());
        if (BugzillaUtil.isNbRepository(this.repository)) {
            NBRepositorySupport.getInstance().setNBBugzillaRepository(this.repository);
        }
    }

    public void cancelChanges() {
    }

    public void populate() {
        this.taskRunner = new TaskRunner(NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_ReadingRepoData")){

            @Override
            protected void preRun() {
                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateButton.setVisible(false);
                super.preRun();
            }

            @Override
            protected void postRun() {
                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateButton.setVisible(true);
                super.postRun();
            }

            @Override
            void execute() {
                UIUtils.runInAWT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RepositoryInfo info = BugzillaRepositoryController.this.repository.getInfo();
                        if (info != null) {
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.userField.setText(info.getUsername());
                            char[] psswd = info.getPassword();
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.psswdField.setText(psswd != null ? new String(psswd) : "");
                            String httpUser = info.getHttpUsername();
                            char[] httpPsswd = info.getHttpPassword();
                            if (httpUser != null && !httpUser.equals("")) {
                                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.httpCheckBox.setSelected(true);
                                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.httpUserField.setText(httpUser);
                            }
                            if (httpPsswd != null && httpPsswd.length > 0) {
                                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.httpCheckBox.setSelected(true);
                                ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.httpPsswdField.setText(new String(httpPsswd));
                            }
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.urlField.setText(info.getUrl());
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.nameField.setText(BugzillaRepositoryController.this.repository.getDisplayName());
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cbEnableLocalUsers.setSelected(BugzillaRepositoryController.this.repository.isShortUsernamesEnabled());
                        }
                        BugzillaRepositoryController.this.populated = true;
                        BugzillaRepositoryController.this.fireChange();
                    }
                });
            }
        };
        this.taskRunner.startTask();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.validateButton) {
            this.onValidate();
        }
    }

    private void onValidate() {
        this.taskRunner = new TaskRunner(NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_Validating")){

            @Override
            void execute() {
                BugzillaRepositoryController.this.validateError = false;
                BugzillaRepositoryController.this.repository.resetRepository(true);
                String name = BugzillaRepositoryController.this.getName();
                String url = BugzillaRepositoryController.this.getUrl();
                String user = BugzillaRepositoryController.this.getUser();
                String httpUser = BugzillaRepositoryController.this.getHttpUser();
                TaskRepository taskRepo = BugzillaRepository.createTemporaryTaskRepository(name, url, user, BugzillaRepositoryController.this.getPassword(), httpUser, BugzillaRepositoryController.this.getHttpPassword(), BugzillaRepositoryController.this.isLocalUserEnabled());
                ValidateCommand cmd = new ValidateCommand(taskRepo);
                BugzillaRepositoryController.this.repository.getExecutor().execute(cmd, false, false, false);
                if (cmd.hasFailed()) {
                    if (cmd.getErrorMessage() == null) {
                        this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] has failed, yet the returned error message is null.", Level.WARNING, name, url, user, BugzillaRepositoryController.this.getPassword(), httpUser, BugzillaRepositoryController.this.getHttpPassword());
                        BugzillaRepositoryController.this.errorMessage = NbBundle.getMessage(BugzillaRepositoryController.class, (String)"MSG_VALIDATION_FAILED");
                    } else {
                        BugzillaRepositoryController.this.errorMessage = cmd.getErrorMessage();
                        this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] has failed: " + BugzillaRepositoryController.this.errorMessage, Level.WARNING, name, url, user, BugzillaRepositoryController.this.getPassword(), httpUser, BugzillaRepositoryController.this.getHttpPassword());
                    }
                    BugzillaRepositoryController.this.validateError = true;
                } else {
                    UIUtils.runInAWT((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.connectionLabel.setVisible(true);
                        }
                    });
                    this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] ok.", Level.INFO, name, url, user, BugzillaRepositoryController.this.getPassword(), httpUser, BugzillaRepositoryController.this.getHttpPassword());
                }
                BugzillaRepositoryController.this.fireChange();
            }

            private void logValidateMessage(String msg, Level level, String name, String url, String user, char[] psswd, String httpUser, char[] httpPsswd) {
                Bugzilla.LOG.log(level, msg, new Object[]{name, url, user, LogUtils.getPasswordLog((char[])psswd), httpUser, LogUtils.getPasswordLog((char[])httpPsswd)});
            }
        };
        this.taskRunner.startTask();
    }

    private void validateErrorOff(DocumentEvent e) {
        if (e.getDocument() == this.panel.userField.getDocument() || e.getDocument() == this.panel.urlField.getDocument() || e.getDocument() == this.panel.psswdField.getDocument()) {
            this.validateError = false;
        }
    }

    void cancel() {
        if (this.taskRunner != null) {
            this.taskRunner.cancel();
        }
    }

    private boolean isValid(String url) {
        if (!url.startsWith("https://") && !url.startsWith("http://")) {
            return false;
        }
        try {
            new URI(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla Repository tasks", 1, true);
        }
        return this.rp;
    }

    public void addChangeListener(ChangeListener l) {
        this.support.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.support.removeChangeListener(l);
    }

    protected void fireChange() {
        this.support.fireChange();
    }

    private abstract class TaskRunner
    implements Runnable,
    Cancellable,
    ActionListener {
        private RequestProcessor.Task task;
        private ProgressHandle handle;
        private final String labelText;

        public TaskRunner(String labelText) {
            this.labelText = labelText;
        }

        final void startTask() {
            this.cancel();
            this.task = BugzillaRepositoryController.this.getRequestProcessor().create((Runnable)this);
            this.task.schedule(0);
        }

        @Override
        public final void run() {
            UIUtils.runInAWT((Runnable)new Runnable(){

                @Override
                public void run() {
                    TaskRunner.this.preRun();
                }
            });
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                UIUtils.runInAWT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TaskRunner.this.postRun();
                    }
                });
                throw throwable;
            }
            UIUtils.runInAWT((Runnable)new /* invalid duplicate definition of identical inner class */);
        }

        abstract void execute();

        protected void preRun() {
            this.handle = ProgressHandleFactory.createHandle((String)this.labelText, (Cancellable)this);
            JComponent comp = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.progressPanel.removeAll();
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.progressPanel.add((Component)comp, "Center");
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cancelButton.addActionListener(this);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.connectionLabel.setVisible(false);
            this.handle.start();
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.progressPanel.setVisible(true);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cancelButton.setVisible(true);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateButton.setVisible(false);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateLabel.setVisible(true);
            BugzillaRepositoryController.this.panel.enableFields(false);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateLabel.setText(this.labelText);
        }

        protected void postRun() {
            if (this.handle != null) {
                this.handle.finish();
            }
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cancelButton.removeActionListener(this);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.progressPanel.setVisible(false);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateLabel.setVisible(false);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.validateButton.setVisible(true);
            ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cancelButton.setVisible(false);
            BugzillaRepositoryController.this.panel.enableFields(true);
        }

        public boolean cancel() {
            boolean ret = true;
            this.postRun();
            if (this.task != null) {
                ret = this.task.cancel();
            }
            BugzillaRepositoryController.this.errorMessage = null;
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ((BugzillaRepositoryController)BugzillaRepositoryController.this).panel.cancelButton) {
                this.cancel();
            }
        }
    }
}

