/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.impl.TokenFilter;

public class PreprocessorFilter
implements TokenFilter {
    private static final int IFDEF_FOLD = 5;
    private static final int INCLUDES_FOLD = 4;
    private final TokenSequence ts;
    private final Stack<Token<CppTokenId>> ppStartDirectives = new Stack();
    private final List<CppFoldRecord> includeFolds = new ArrayList<CppFoldRecord>();
    private final List<CppFoldRecord> ifdefFolds = new ArrayList<CppFoldRecord>();
    private Token<CppTokenId> firstInclude = null;
    private Token<CppTokenId> firstEmbeddedInclude = null;
    private Token<CppTokenId> lastInclude = null;

    public PreprocessorFilter(TokenSequence ts) {
        this.ts = ts;
    }

    @Override
    public void visit(Token<CppTokenId> token) {
        assert (this.ts.token() == token) : this.ts.token() + " vs. " + token;
        if (token.id() != CppTokenId.PREPROCESSOR_DIRECTIVE) {
            this.addIncludesIfNeeded();
        } else {
            TokenSequence embedded = this.ts.embedded(CppTokenId.languagePreproc());
            while (embedded.moveNext()) {
                Token embeddedToken = embedded.offsetToken();
                Token ppToken = embedded.token();
                switch ((CppTokenId)ppToken.id()) {
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        this.include((Token<CppTokenId>)this.ts.offsetToken(), (Token<CppTokenId>)embeddedToken);
                        break;
                    }
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: {
                        this.onStartPreprocNode((Token<CppTokenId>)this.ts.offsetToken());
                        break;
                    }
                    case PREPROCESSOR_ENDIF: {
                        this.createEndifFold((Token<CppTokenId>)this.ts.offsetToken());
                        break;
                    }
                    case PREPROCESSOR_DEFINE: 
                    case PREPROCESSOR_UNDEF: 
                    case PREPROCESSOR_ELIF: 
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ERROR: 
                    case PREPROCESSOR_PRAGMA: {
                        this.onOtherPreprocNode((Token<CppTokenId>)this.ts.offsetToken());
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void visitEof() {
        this.addIncludesIfNeeded();
    }

    @Override
    public boolean consumes(CppTokenId id) {
        return "preprocessor".equals(id.primaryCategory());
    }

    @Override
    public List<CppFoldRecord> getFolders() {
        ArrayList<CppFoldRecord> out = new ArrayList<CppFoldRecord>(this.includeFolds.size() + this.ifdefFolds.size());
        out.addAll(this.includeFolds);
        out.addAll(this.ifdefFolds);
        return out;
    }

    private boolean onStartPreprocNode(Token<CppTokenId> apt) {
        this.addIncludesIfNeeded();
        this.ppStartDirectives.push(apt);
        return true;
    }

    private void createEndifFold(Token<CppTokenId> end) {
        this.addIncludesIfNeeded();
        if (!this.ppStartDirectives.empty()) {
            Token<CppTokenId> start = this.ppStartDirectives.pop();
            this.ifdefFolds.add(new CppFoldRecord(5, start.offset(null) + this.effectiveLength(start), end.offset(null) + this.effectiveLength(end)));
        }
    }

    private void include(Token<CppTokenId> top, Token<CppTokenId> embedded) {
        if (this.firstInclude == null) {
            this.firstInclude = top;
            this.firstEmbeddedInclude = embedded;
        }
        this.lastInclude = top;
    }

    private void addIncludesIfNeeded() {
        if (this.lastInclude != this.firstInclude) {
            int end;
            assert (this.lastInclude != null);
            assert (this.firstInclude != null);
            assert (this.firstEmbeddedInclude != null);
            int start = this.firstEmbeddedInclude.offset(null) + this.firstEmbeddedInclude.length();
            if (start < (end = this.lastInclude.offset(null) + this.effectiveLength(this.lastInclude))) {
                this.includeFolds.add(new CppFoldRecord(4, start, end));
            }
        }
        this.lastInclude = null;
        this.firstInclude = null;
        this.firstEmbeddedInclude = null;
    }

    private void onOtherPreprocNode(Token<CppTokenId> apt) {
        this.addIncludesIfNeeded();
    }

    private int effectiveLength(Token<CppTokenId> ppToken) {
        int len;
        assert (ppToken.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) : "" + ppToken;
        CharSequence str = ppToken.text();
        if (str.charAt((len = str.length()) - 1) <= ' ') {
            --len;
        }
        return len;
    }
}

