/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.wizards.importstep;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnFileNode;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.PanelProgressSupport;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.commit.CommitAction;
import org.netbeans.modules.subversion.remote.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.remote.ui.commit.CommitTable;
import org.netbeans.modules.subversion.remote.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.remote.ui.wizards.importstep.PreviewPanel;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportPreviewStep
extends AbstractStep {
    private PreviewPanel previewPanel;
    private final Context context;
    private CommitTable table;
    private PanelProgressSupport support;
    private String importMessage;
    private static final String PANEL_PREFIX = "import";

    public ImportPreviewStep(Context context) {
        this.context = context;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(ImportPreviewStep.class);
    }

    @Override
    protected JComponent createComponent() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel();
            Map<String, Integer> sortingStatus = SvnModuleConfig.getDefault(this.context.getFileSystem()).getSortingStatus(PANEL_PREFIX);
            if (sortingStatus == null) {
                sortingStatus = Collections.singletonMap("path", 1);
            }
            this.table = new CommitTable(this.previewPanel.tableLabel, CommitTable.IMPORT_COLUMNS, sortingStatus);
            JComponent component = this.table.getComponent();
            this.previewPanel.tablePanel.setLayout(new BorderLayout());
            this.previewPanel.tablePanel.add((Component)component, "Center");
        }
        return this.previewPanel;
    }

    @Override
    protected void validateBeforeNext() {
        this.validateUserInput();
    }

    public void validateUserInput() {
        Collection<CommitOptions> commitOptions = this.table.getCommitFiles().values();
        if (this.table != null && commitOptions.size() > 0) {
            for (CommitOptions option : commitOptions) {
                if (option == CommitOptions.EXCLUDE) continue;
                this.valid();
                return;
            }
            this.invalid(null);
        } else {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportPreviewStep.class, (String)"CTL_Import_NothingToImport"), true));
        }
    }

    public void setup(final String repositoryPath, final String rootLocalPath, final SVNUrl repository, String importMessage, final boolean startCommitWhenFinished) {
        this.importMessage = importMessage;
        this.support = new PanelProgressSupport(this.context.getFileSystem(), startCommitWhenFinished ? null : this.previewPanel.progressPanel){

            @Override
            protected void perform() {
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                final VCSFileProxy[] files = cache.listFiles(ImportPreviewStep.this.context, 88532);
                if (files.length == 0 || this.isCanceled()) {
                    return;
                }
                if (repositoryPath != null) {
                    ImportPreviewStep.this.table.setRootFile(repositoryPath, rootLocalPath);
                }
                final ArrayList nodesList = new ArrayList(files.length);
                SvnUtils.runWithInfoCache(new Runnable(){

                    @Override
                    public void run() {
                        for (VCSFileProxy file : files) {
                            SvnFileNode node = new SvnFileNode(file);
                            node.initializeProperties();
                            nodesList.add(node);
                            if (!this.isCanceled()) continue;
                            return;
                        }
                    }
                });
                final SvnFileNode[] nodes = nodesList.toArray(new SvnFileNode[files.length]);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportPreviewStep.this.table.setNodes(nodes);
                        ImportPreviewStep.this.table.getTableModel().addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent e) {
                                ImportPreviewStep.this.validateUserInput();
                            }
                        });
                        ImportPreviewStep.this.validateUserInput();
                        if (startCommitWhenFinished) {
                            ImportPreviewStep.this.startCommitTask(repository);
                        }
                    }
                });
            }
        };
        this.support.start(Subversion.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ImportPreviewStep.class, (String)"BK1009"));
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        return this.table.getCommitFiles();
    }

    public void storeTableSorter() {
        SvnModuleConfig.getDefault(this.context.getFileSystem()).setSortingStatus(PANEL_PREFIX, this.table.getSortingState());
    }

    public void startCommitTask(final SVNUrl repository) {
        SvnProgressSupport commitTask = new SvnProgressSupport(this.context.getFileSystem()){

            @Override
            public void perform() {
                CommitAction.performCommit(ImportPreviewStep.this.importMessage, ImportPreviewStep.this.getCommitFiles(), ImportPreviewStep.this.context, repository, this, true);
            }
        };
        commitTask.start(Subversion.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ImportPreviewStep.class, (String)"LBL_Import_Progress"));
    }
}

