/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.wcadmin;

import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.wcadmin.Bundle;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.NotifyHtmlPanel;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpgradeAction
extends ContextAction {
    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 0;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Upgrade_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        VCSFileProxy[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            }
            return;
        }
        this.upgrade(true, roots);
    }

    public void upgrade(VCSFileProxy root) {
        this.upgrade(false, root);
    }

    private void upgrade(boolean explicitelyInvoked, VCSFileProxy ... roots) {
        final HashSet<VCSFileProxy> toUpgrade = new HashSet<VCSFileProxy>();
        for (VCSFileProxy root : roots) {
            boolean needsUpgrade;
            block4: {
                needsUpgrade = false;
                try {
                    ContextAction.getSvnUrl(new Context(root));
                }
                catch (SVNClientException ex) {
                    String msg = ex.getMessage().toLowerCase(Locale.ENGLISH);
                    if (!SvnClientExceptionHandler.isTooOldWorkingCopy(msg) || !msg.contains("upgrade") && (!msg.contains("working copy format") || !msg.contains("is too old"))) break block4;
                    needsUpgrade = true;
                }
            }
            boolean accept = !explicitelyInvoked ? this.confirmPossibleUpgrade(root.getPath()) : (needsUpgrade ? this.confirmUpgrade(root.getPath()) : this.forceUpgrade(root.getPath()));
            if (!accept) continue;
            toUpgrade.add(root);
        }
        if (toUpgrade.isEmpty()) {
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor();
        SvnProgressSupport support = new SvnProgressSupport(VCSFileProxySupport.getFileSystem((VCSFileProxy)roots[0])){

            @Override
            protected void perform() {
                for (VCSFileProxy root : toUpgrade) {
                    try {
                        SvnClient client = Subversion.getInstance().getClient(true, new Context(root));
                        this.setCancellableDelegate(client);
                        boolean cont = true;
                        VCSFileProxy wcRoot = root;
                        while (cont) {
                            cont = false;
                            try {
                                client.upgrade(wcRoot);
                                Subversion.getInstance().getStatusCache().refreshAsync(Subversion.getInstance().getStatusCache().listFiles(new VCSFileProxy[]{Subversion.getInstance().getTopmostManagedAncestor(wcRoot)}, 88532));
                                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_UpgradeAction_statusBar_upgraded(root.getPath()));
                                Subversion.getInstance().refreshTopmostRepositoryUrl(root);
                            }
                            catch (SVNClientException ex) {
                                String msg = ex.getMessage().toLowerCase(Locale.ENGLISH);
                                if (msg.contains("as it is not a pre-1.7 working copy root")) {
                                    VCSFileProxy rootCandidate;
                                    for (String s : new String[]{".*root is '([^']+)'.*"}) {
                                        Pattern p = Pattern.compile(s, 32);
                                        Matcher m = p.matcher(ex.getMessage());
                                        if (!m.matches()) continue;
                                        VCSFileProxy rootCandidate2 = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)m.group(1));
                                        if (wcRoot.equals((Object)rootCandidate2)) break;
                                        wcRoot = rootCandidate2;
                                        cont = true;
                                        break;
                                    }
                                    if (!cont && (rootCandidate = wcRoot.getParentFile()) != null && SvnUtils.isManaged(rootCandidate)) {
                                        wcRoot = rootCandidate;
                                        cont = true;
                                    }
                                }
                                if (cont) continue;
                                throw ex;
                            }
                        }
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                }
            }
        };
        support.start(rp, null, NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_Progress"));
    }

    private boolean confirmPossibleUpgrade(String path) {
        return this.confirm(NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_possibleUpgrade", (Object)path));
    }

    private boolean confirmUpgrade(String path) {
        return this.confirm(NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_upgrade", (Object)path));
    }

    private boolean forceUpgrade(String path) {
        return JOptionPane.showConfirmDialog(null, NbBundle.getMessage(UpgradeAction.class, (String)"MSG_Upgrade_forceUpgrade", (Object)path), NbBundle.getMessage(UpgradeAction.class, (String)"LBL_Upgrade_title", (Object)path), 0, 3) == 0;
    }

    private boolean confirm(String title, String message) {
        NotifyHtmlPanel p = new NotifyHtmlPanel();
        p.setText(message);
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)p, title, 2, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify(descriptor);
    }
}

