/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.copy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JTextField;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.remote.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.remote.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.remote.ui.copy.SwitchToPanel;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class SwitchTo
extends CopyDialog
implements PropertyChangeListener {
    private final RepositoryPaths repositoryPaths;
    private final VCSFileProxy root;
    private final RepositoryFile repositoryFile;

    public SwitchTo(RepositoryFile repositoryFile, VCSFileProxy root, boolean localChanges) {
        super(root, new SwitchToPanel(), NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_Title", (Object)root.getName()), NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_Action"));
        int browserMode;
        String browserPurposeMessage;
        this.root = root;
        this.repositoryFile = repositoryFile;
        SwitchToPanel panel = this.getSwitchToPanel();
        panel.warningLabel.setVisible(localChanges);
        this.setupUrlComboBox(repositoryFile, panel.urlComboBox);
        this.repositoryPaths = new RepositoryPaths(VCSFileProxySupport.getFileSystem((VCSFileProxy)root), repositoryFile, (JTextField)panel.urlComboBox.getEditor().getEditorComponent(), panel.browseRepositoryButton, panel.revisionTextField, panel.searchRevisionButton);
        this.repositoryPaths.addPropertyChangeListener(this);
        this.getSwitchToPanel().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_RepositoryFile"));
        if (root.isFile()) {
            this.getSwitchToPanel().urlLabel.setText(NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_RepositoryFile"));
            browserPurposeMessage = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageSwitchFile");
            browserMode = 7;
        } else {
            browserPurposeMessage = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageSwitchFolder");
            browserMode = 2;
        }
        this.repositoryPaths.setupBehavior(browserPurposeMessage, browserMode, "org.netbeans.modules.subversion.ui.browser.switchto", "org.netbeans.modules.subversion.ui.search.switch");
    }

    RepositoryFile getRepositoryFile() {
        try {
            RepositoryFile[] repositoryFiles = this.repositoryPaths.getRepositoryFiles();
            if (repositoryFiles.length > 0) {
                return repositoryFiles[0];
            }
            SVNRevision revision = this.repositoryPaths.getRevision();
            if (revision == null) {
                return null;
            }
            SVNUrl url = SvnUtils.getRepositoryUrl(this.root);
            RepositoryFile rf = new RepositoryFile(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.root), this.repositoryFile.getRepositoryUrl(), url, revision);
            return rf;
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(new Context(this.root), ex, true, true);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private SwitchToPanel getSwitchToPanel() {
        return (SwitchToPanel)this.getPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            boolean valid = (Boolean)evt.getNewValue();
            this.getOKButton().setEnabled(valid);
        }
    }
}

