/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.subversion.remote.util.Context;
import org.openide.filesystems.FileSystem;

public class RelocateCommand
extends SvnCommand {
    private final String from;
    private final String to;
    private final String path;
    private final boolean rec;
    private final Context context;

    public RelocateCommand(FileSystem fileSystem, Context context, String from, String to, String path, boolean rec) {
        super(fileSystem);
        this.context = context;
        this.from = from;
        this.to = to;
        this.path = path;
        this.rec = rec;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.RELOCATE;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("switch");
        arguments.add("--relocate");
        if (!this.rec) {
            arguments.add("-N");
        }
        arguments.add(this.from);
        arguments.add(this.to);
        arguments.add(this.path);
        this.setCommandWorkingDirectory(VCSFileProxySupport.getResource((FileSystem)this.context.getFileSystem(), (String)this.path));
    }
}

