/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class ImportCommand
extends SvnCommand {
    private final boolean recursive;
    private final String message;
    private final VCSFileProxy file;
    private final SVNUrl url;

    public ImportCommand(FileSystem fileSystem, VCSFileProxy file, SVNUrl url, boolean recursive, String message) {
        super(fileSystem);
        this.recursive = recursive;
        this.message = message;
        this.file = file;
        this.url = url;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.IMPORT;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("import");
        arguments.add(this.file.getPath());
        arguments.addNonExistent(this.url);
        if (!this.recursive) {
            arguments.add("-N");
        }
        arguments.addMessage(this.message);
        this.setCommandWorkingDirectory(this.file);
    }
}

