/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class MakefileConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration buildCommandWorkingDir;
    private StringConfiguration buildCommand;
    private StringConfiguration cleanCommand;
    private StringConfiguration output;

    public MakefileConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildCommandWorkingDir = new StringConfiguration(null, ".");
        this.buildCommand = new StringConfiguration(null, "${MAKE}");
        this.cleanCommand = new StringConfiguration(null, "${MAKE} clean");
        this.output = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getBuildCommandWorkingDir() {
        return this.buildCommandWorkingDir;
    }

    public String getBuildCommandWorkingDirValue() {
        if (this.buildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.buildCommandWorkingDir.getValue();
    }

    public void setBuildCommandWorkingDir(StringConfiguration buildCommandWorkingDir) {
        this.buildCommandWorkingDir = buildCommandWorkingDir;
    }

    public StringConfiguration getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(StringConfiguration buildCommand) {
        this.buildCommand = buildCommand;
    }

    public StringConfiguration getCleanCommand() {
        return this.cleanCommand;
    }

    public void setCleanCommand(StringConfiguration cleanCommand) {
        this.cleanCommand = cleanCommand;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public boolean canBuild() {
        return this.getBuildCommand().getValue().length() > 0;
    }

    public FileObject getAbsBuildCommandFileObject() {
        String path = this.getAbsBuildCommandWorkingDir();
        return FileSystemProvider.getFileObject((ExecutionEnvironment)this.getSourceExecutionEnvironment(), (String)path);
    }

    public String getAbsBuildCommandWorkingDir() {
        String wd = this.getBuildCommandWorkingDirValue().length() > 0 && CndPathUtilities.isPathAbsolute((CharSequence)this.getBuildCommandWorkingDirValue()) ? this.getBuildCommandWorkingDirValue() : this.getMakeConfiguration().getBaseDir() + "/" + this.getBuildCommandWorkingDirValue();
        wd = FileSystemProvider.normalizeAbsolutePath((String)wd, (ExecutionEnvironment)this.getSourceExecutionEnvironment());
        return wd;
    }

    public boolean canClean() {
        return this.getCleanCommand().getValue().length() > 0;
    }

    public String getAbsOutput() {
        if (this.getOutput().getValue().length() == 0) {
            return "";
        }
        if (CndPathUtilities.isPathAbsolute((CharSequence)this.getOutput().getValue())) {
            return this.getOutput().getValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getOutput().getValue();
    }

    public void assign(MakefileConfiguration conf) {
        this.getBuildCommandWorkingDir().assign(conf.getBuildCommandWorkingDir());
        this.getBuildCommand().assign(conf.getBuildCommand());
        this.getCleanCommand().assign(conf.getCleanCommand());
        this.getOutput().assign(conf.getOutput());
    }

    public MakefileConfiguration clone() {
        MakefileConfiguration clone = new MakefileConfiguration(this.getMakeConfiguration());
        clone.setBuildCommandWorkingDir(this.getBuildCommandWorkingDir().clone());
        clone.setBuildCommand(this.getBuildCommand().clone());
        clone.setCleanCommand(this.getCleanCommand().clone());
        clone.setOutput(this.getOutput().clone());
        return clone;
    }

    private ExecutionEnvironment getSourceExecutionEnvironment() {
        ExecutionEnvironment env = null;
        MakeConfiguration mc = this.getMakeConfiguration();
        if (mc != null) {
            return FileSystemProvider.getExecutionEnvironment((FileSystem)mc.getBaseFSPath().getFileSystem());
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }
}

