/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.ChangeSupport;

public class FileObjectBasedSources
implements Sources,
FileChangeListener {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private boolean haveAttachedListeners;
    private final Set<CharSequence> rootsListenedTo = new HashSet<CharSequence>();
    private final Map<String, List<SourceGroup>> groups = new HashMap<String, List<SourceGroup>>();
    private final Map<String, List<CharSequence>> lastComputedRoots = new ConcurrentHashMap<String, List<CharSequence>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String type) {
        FileObjectBasedSources fileObjectBasedSources = this;
        synchronized (fileObjectBasedSources) {
            List<SourceGroup> l = this.groups.get(type);
            SourceGroup[] result = l == null ? new SourceGroup[]{} : l.toArray(new SourceGroup[l.size()]);
            ArrayList<CharSequence> rootURLs = new ArrayList<CharSequence>(this.groups.size());
            for (SourceGroup g : result) {
                rootURLs.add(CndFileUtils.fileObjectToUrl((FileObject)g.getRootFolder()));
            }
            this.lastComputedRoots.put(type, rootURLs);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup addGroup(Project project, String type, FileObject fo, String displayName) {
        FileObjectBasedSources fileObjectBasedSources = this;
        synchronized (fileObjectBasedSources) {
            List<SourceGroup> l;
            if (this.rootsListenedTo.add(CndFileUtils.fileObjectToUrl((FileObject)fo)) && this.haveAttachedListeners) {
                fo.addFileChangeListener((FileChangeListener)this);
            }
            if ((l = this.groups.get(type)) == null) {
                l = new ArrayList<SourceGroup>();
                this.groups.put(type, l);
            }
            SourceGroup group = GenericSources.group((Project)project, (FileObject)fo, (String)fo.getPath(), (String)displayName, null, null);
            l.add(group);
            return group;
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (!this.haveAttachedListeners) {
            this.haveAttachedListeners = true;
            for (CharSequence url : this.rootsListenedTo) {
                FileObject fo = CndFileUtils.urlToFileObject((CharSequence)url);
                if (fo == null || !fo.isValid()) continue;
                fo.addFileChangeListener((FileChangeListener)this);
            }
        }
        this.cs.addChangeListener(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
        if (!this.cs.hasListeners() && this.haveAttachedListeners) {
            this.haveAttachedListeners = false;
            for (CharSequence url : this.rootsListenedTo) {
                FileObject fo = CndFileUtils.urlToFileObject((CharSequence)url);
                if (fo == null || !fo.isValid()) continue;
                fo.removeFileChangeListener((FileChangeListener)this);
            }
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        this.maybeFireChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.maybeFireChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.maybeFireChange();
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.maybeFireChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void maybeFireChange() {
        boolean change = false;
        for (String type : new HashSet<String>(this.lastComputedRoots.keySet())) {
            ArrayList previous = new ArrayList(this.lastComputedRoots.get(type));
            this.getSourceGroups(type);
            List<CharSequence> nue = this.lastComputedRoots.get(type);
            if (nue.equals(previous)) continue;
            change = true;
            break;
        }
        if (change) {
            this.cs.fireChange();
        }
    }
}

