/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.groovy.gsp.lexer.GspLexerLanguage;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class GroovyEmbeddingProvider
extends EmbeddingProvider {
    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if ("text/x-gsp".equals(snapshot.getMimeType())) {
            return Collections.singletonList(Embedding.create(this.translate(snapshot)));
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    private List<Embedding> translate(Snapshot snapshot) {
        Language<GspTokenId> gspLanguage = GspLexerLanguage.getLanguage();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)snapshot.getText(), gspLanguage);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(gspLanguage);
        if (tokenSequence != null) {
            return this.translate(snapshot, (TokenSequence<GspTokenId>)tokenSequence);
        }
        return Collections.emptyList();
    }

    private List<Embedding> translate(Snapshot snapshot, TokenSequence<GspTokenId> tokenSequence) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        embeddings.add(snapshot.create((CharSequence)"def _buf ='';", "text/x-groovy"));
        boolean skipNewline = false;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            int sourceStart = tokenSequence.offset();
            int sourceEnd = sourceStart + token.length();
            String text = token.text().toString();
            switch ((GspTokenId)token.id()) {
                case HTML: {
                    int i;
                    boolean found = false;
                    for (i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        if (c == '\n') {
                            ++i;
                            found = true;
                            break;
                        }
                        if (!Character.isWhitespace(c)) break;
                    }
                    if (found) {
                        embeddings.add(snapshot.create(sourceStart, i, "text/x-groovy"));
                        text = text.substring(i);
                    }
                    embeddings.add(snapshot.create((CharSequence)"_buf += \"\"\"", "text/x-groovy"));
                    if (skipNewline && text.startsWith("\n")) {
                        text = text.substring(1);
                        --sourceEnd;
                    }
                    embeddings.add(snapshot.create((CharSequence)text.replace("\"", "\\\""), "text/x-groovy"));
                    embeddings.add(snapshot.create((CharSequence)"\"\"\";", "text/x-groovy"));
                    skipNewline = false;
                    break;
                }
                case COMMENT_HTML_STYLE_CONTENT: 
                case COMMENT_GSP_STYLE_CONTENT: 
                case COMMENT_JSP_STYLE_CONTENT: {
                    this.translateComment(snapshot, embeddings, sourceStart, text);
                    break;
                }
                case GSTRING_CONTENT: 
                case SCRIPTLET_CONTENT: {
                    embeddings.add(snapshot.create(sourceStart, text.length(), "text/x-groovy"));
                    embeddings.add(snapshot.create((CharSequence)";", "text/x-groovy"));
                    skipNewline = false;
                    break;
                }
                case SCRIPTLET_OUTPUT_VALUE_CONTENT: {
                    embeddings.add(snapshot.create((CharSequence)"_buf += (", "text/x-groovy"));
                    embeddings.add(snapshot.create(sourceStart, text.length(), "text/x-groovy"));
                    embeddings.add(snapshot.create((CharSequence)";)", "text/x-groovy"));
                    skipNewline = false;
                    break;
                }
            }
        }
        return embeddings;
    }

    private void translateComment(Snapshot snapshot, List<Embedding> embeddings, int sourceStart, String text) {
        embeddings.add(snapshot.create((CharSequence)"/*", "text/x-groovy"));
        embeddings.add(snapshot.create(sourceStart, text.length(), "text/x-groovy"));
        embeddings.add(snapshot.create((CharSequence)"*/", "text/x-groovy"));
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if ("text/x-gsp".equals(snapshot.getMimeType())) {
                return Collections.singleton(new GroovyEmbeddingProvider());
            }
            return Collections.emptyList();
        }
    }
}

