/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ElementOpen {
    private static Logger log = Logger.getLogger(ElementOpen.class.getName());
    private static final int AWT_TIMEOUT = 1000;
    private static final int NON_AWT_TIMEOUT = 2000;

    private ElementOpen() {
    }

    public static boolean open(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> el) {
        final AtomicBoolean cancel = new AtomicBoolean();
        if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
            final Object[] openInfo = new Object[3];
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] info = ElementOpen.getOpenInfo(cpInfo, (ElementHandle<? extends Element>)el, cancel);
                    if (info != null) {
                        openInfo[0] = info[0];
                        openInfo[1] = info[1];
                        openInfo[2] = info[2];
                    }
                }
            }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            if (cancel.get()) {
                return false;
            }
            if (openInfo[0] instanceof FileObject) {
                return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
            }
            return ElementOpen.binaryOpen(cpInfo, el, cancel);
        }
        return ElementOpen.open(cpInfo, el, cancel);
    }

    private static boolean open(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, AtomicBoolean cancel) {
        Object[] openInfo = ElementOpen.getOpenInfo(cpInfo, el, cancel);
        if (cancel.get()) {
            return false;
        }
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
        }
        return ElementOpen.binaryOpen(cpInfo, el, cancel);
    }

    private static boolean binaryOpen(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, AtomicBoolean cancel) {
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            return beo.open(cpInfo, el, cancel);
        }
        return false;
    }

    public static boolean open(ClasspathInfo cpInfo, Element el) {
        return ElementOpen.open(cpInfo, (ElementHandle<? extends Element>)ElementHandle.create((Element)el));
    }

    public static boolean open(final @NonNull FileObject toSearch, final @NonNull ElementHandle<? extends Element> toOpen) {
        final AtomicBoolean cancel = new AtomicBoolean();
        if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
            final Object[] openInfo = new Object[3];
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] info;
                    Object[] objectArray = info = !ElementOpen.isClassFile(toSearch) ? ElementOpen.getOpenInfo(toSearch, (ElementHandle<? extends Element>)toOpen, cancel) : null;
                    if (info != null) {
                        openInfo[0] = info[0];
                        openInfo[1] = info[1];
                        openInfo[2] = info[2];
                    }
                }
            }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            if (cancel.get()) {
                return false;
            }
            if (openInfo[0] instanceof FileObject) {
                return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
            }
            return ElementOpen.binaryOpen(toSearch, toOpen, cancel);
        }
        return ElementOpen.open(toSearch, toOpen, cancel);
    }

    private static boolean open(@NonNull FileObject toSearch, @NonNull ElementHandle<? extends Element> toOpen, @NonNull AtomicBoolean cancel) {
        Object[] openInfo;
        Parameters.notNull((CharSequence)"toSearch", (Object)toSearch);
        Parameters.notNull((CharSequence)"toOpen", toOpen);
        Object[] objectArray = openInfo = !ElementOpen.isClassFile(toSearch) ? ElementOpen.getOpenInfo(toSearch, toOpen, cancel) : null;
        if (cancel.get()) {
            return false;
        }
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1], (Integer)openInfo[2]);
        }
        return ElementOpen.binaryOpen(toSearch, toOpen, cancel);
    }

    private static boolean binaryOpen(@NonNull FileObject toSearch, @NonNull ElementHandle<? extends Element> toOpen, @NonNull AtomicBoolean cancel) {
        boolean res = false;
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            ClassPath cp;
            ClassPath bootCp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/boot");
            if (bootCp == null) {
                bootCp = JavaPlatform.getDefault().getBootstrapLibraries();
            }
            if (((cp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/compile")) == null || cp.findOwnerRoot(toSearch) == null) && (cp = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/execute")) == null) {
                cp = ClassPath.EMPTY;
            }
            ClassPath src = ClassPath.getClassPath((FileObject)toSearch, (String)"classpath/source");
            res = beo.open(ClasspathInfo.create((ClassPath)bootCp, (ClassPath)cp, (ClassPath)src), toOpen, cancel);
        }
        return res;
    }

    private static boolean isClassFile(@NonNull FileObject file) {
        return "class".equals(file.getExt()) || "application/x-class-file".equals(file.getMIMEType(new String[]{"application/x-class-file"}));
    }

    private static Object[] getOpenInfo(ClasspathInfo cpInfo, ElementHandle<? extends Element> el, AtomicBoolean cancel) {
        FileObject fo = SourceUtils.getFile(el, (ClasspathInfo)cpInfo);
        if (fo != null && fo.isFolder()) {
            fo = fo.getFileObject("package-info.java");
        }
        return fo != null ? ElementOpen.getOpenInfo(fo, el, cancel) : null;
    }

    private static Object[] getOpenInfo(FileObject fo, ElementHandle<? extends Element> handle, AtomicBoolean cancel) {
        assert (fo != null);
        try {
            int[] offset = ElementOpen.getOffset(fo, handle, cancel);
            return new Object[]{fo, offset[0], offset[1]};
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static boolean doOpen(FileObject fo, final int offsetA, final int offsetB) {
        DataObject od;
        boolean success;
        if (offsetA == -1) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ElementOpen.class, (String)"WARN_ElementNotFound"), 1000);
        }
        if (!(success = UiUtils.open((FileObject)fo, (int)offsetA))) {
            return false;
        }
        try {
            od = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return success;
        }
        final EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
        if (ec != null && offsetA != -1 && offsetB != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane pane;
                    FoldHierarchy fh;
                    Fold f;
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (offsetB >= 0 && panes != null && panes.length > 0 && (f = FoldUtilities.findNearestFold((FoldHierarchy)(fh = FoldHierarchy.get((JTextComponent)(pane = panes[0]))), (int)offsetA)) != null && f.getStartOffset() >= offsetA && f.getEndOffset() <= offsetB) {
                        fh.expand(f);
                    }
                }
            });
        }
        return success;
    }

    private static int[] getOffset(final FileObject fo, final ElementHandle<? extends Element> handle, final AtomicBoolean cancel) throws IOException {
        final int[] result = new int[]{-1, -1};
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            Task<CompilationController> t = new Task<CompilationController>(){

                public void run(CompilationController info) throws IOException {
                    if (cancel.get()) {
                        return;
                    }
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    Element el = handle.resolve((CompilationInfo)info);
                    if (el == null) {
                        if (!SourceUtils.isScanInProgress()) {
                            log.severe("Cannot resolve " + handle + ". " + info.getClasspathInfo());
                        } else {
                            Level l = Level.FINE;
                            assert ((l = Level.INFO) != null);
                            log.log(l, "Cannot resolve {0} ({1})", new Object[]{handle, info.getClasspathInfo()});
                        }
                        return;
                    }
                    if (el.getKind() == ElementKind.PACKAGE) {
                        Matcher m = Pattern.compile("(?m)^package (.+);$").matcher(fo.asText());
                        if (m.find()) {
                            result[0] = m.start();
                        }
                        return;
                    }
                    FindDeclarationVisitor v = new FindDeclarationVisitor(el, (CompilationInfo)info);
                    CompilationUnitTree cu = info.getCompilationUnit();
                    v.scan(cu, null);
                    Tree elTree = v.declTree;
                    if (elTree != null) {
                        result[0] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, elTree);
                        result[1] = (int)info.getTrees().getSourcePositions().getEndPosition(cu, elTree);
                    }
                }
            };
            js.runUserActionTask((Task)t, true);
        }
        return result;
    }

    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        @Override
        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, d);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, d);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, d);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (this.element.equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

