/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.schematronequiv;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Html4Assertions
extends Checker {
    private static final String[] SPECIAL_ANCESTORS = new String[]{"a", "button", "form", "label", "pre"};
    private static Map<String, Integer> ANCESTOR_MASK_BY_DESCENDANT = new HashMap<String, Integer>();
    private static final int BUTTON_MASK;
    private static final int LABEL_FOR_MASK = 0x10000000;
    private StackNode[] stack;
    private int currentPtr;
    private Map<StackNode, Locator> openSingleSelects = new HashMap<StackNode, Locator>();
    private LinkedHashSet<IdrefLocator> formControlReferences = new LinkedHashSet();
    private Set<String> formControlIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> listReferences = new LinkedHashSet();
    private Set<String> listIds = new HashSet<String>();
    private Set<String> allIds = new HashSet<String>();

    private static boolean lowerCaseLiteralEqualsIgnoreAsciiCaseString(String lowerCaseLiteral, String string) {
        if (string == null) {
            return false;
        }
        if (lowerCaseLiteral.length() != string.length()) {
            return false;
        }
        for (int i = 0; i < lowerCaseLiteral.length(); ++i) {
            char c0 = lowerCaseLiteral.charAt(i);
            char c1 = string.charAt(i);
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnoreAsciiCase(String one, String other) {
        if (other == null) {
            return one == null;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            char c0 = one.charAt(i);
            char c1 = other.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private static int specialAncestorNumber(String name) {
        for (int i = 0; i < SPECIAL_ANCESTORS.length; ++i) {
            if (name != SPECIAL_ANCESTORS[i]) continue;
            return i;
        }
        return -1;
    }

    private static void registerProhibitedAncestor(String ancestor, String descendant) {
        int number = Html4Assertions.specialAncestorNumber(ancestor);
        if (number == -1) {
            throw new IllegalStateException("Ancestor not found in array: " + ancestor);
        }
        Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(descendant);
        int mask = 0;
        if (maskAsObject != null) {
            mask = maskAsObject;
        }
        ANCESTOR_MASK_BY_DESCENDANT.put(descendant, new Integer(mask |= 1 << number));
    }

    private void push(StackNode node) {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
    }

    private StackNode pop() {
        return this.stack[this.currentPtr--];
    }

    private StackNode peek() {
        return this.stack[this.currentPtr];
    }

    @Override
    public void endDocument() throws SAXException {
        for (IdrefLocator idrefLocator : this.formControlReferences) {
            if (this.formControlIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201cfor\u201d attribute of the \u201clabel\u201d element must refer to a form control.", idrefLocator.getLocator());
        }
        this.reset();
        this.stack = null;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        StackNode node = this.pop();
        this.openSingleSelects.remove(node);
        if ("http://www.w3.org/1999/xhtml" == uri && "option" == localName && !this.stack[this.currentPtr].hasOption()) {
            this.stack[this.currentPtr].setOptionFound();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.stack = new StackNode[32];
        this.currentPtr = 0;
        this.stack[0] = null;
    }

    @Override
    public void reset() {
        this.openSingleSelects.clear();
        this.formControlReferences.clear();
        this.formControlIds.clear();
        this.listReferences.clear();
        this.listIds.clear();
        this.allIds.clear();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        HashSet<String> ids = new HashSet<String>();
        String role = null;
        String activeDescendant = null;
        String forAttr = null;
        boolean href = false;
        boolean hreflang = false;
        StackNode parent = this.peek();
        int ancestorMask = 0;
        if (parent != null) {
            ancestorMask = parent.getAncestorMask();
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            String forVal;
            int maskHit;
            boolean hidden = false;
            boolean usemap = false;
            boolean selected = false;
            String xmlLang = null;
            String lang = null;
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attVal;
                String attUri = atts.getURI(i);
                if (attUri.length() == 0) {
                    String attLocal = atts.getLocalName(i);
                    if ("href" == attLocal) {
                        href = true;
                    } else if ("hreflang" == attLocal) {
                        hreflang = true;
                    } else if ("lang" == attLocal) {
                        lang = atts.getValue(i);
                    } else if ("for" == attLocal && "label" == localName) {
                        forAttr = atts.getValue(i);
                        ancestorMask |= 0x10000000;
                    } else if ("selected" == attLocal) {
                        selected = true;
                    } else if ("usemap" == attLocal && "input" != localName) {
                        usemap = true;
                    }
                } else if ("http://www.w3.org/XML/1998/namespace" == attUri && "lang" == atts.getLocalName(i)) {
                    xmlLang = atts.getValue(i);
                }
                if (atts.getType(i) != "ID" || (attVal = atts.getValue(i)).length() == 0) continue;
                ids.add(attVal);
            }
            int mask = 0;
            String descendantUiString = "";
            Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(localName);
            if (maskAsObject != null) {
                mask = maskAsObject;
                descendantUiString = localName;
            } else if ("img" == localName && usemap) {
                mask = BUTTON_MASK;
                descendantUiString = "img\u201d with the attribute \u201cusemap";
            }
            if (mask != 0 && (maskHit = ancestorMask & mask) != 0) {
                for (int j = 0; j < SPECIAL_ANCESTORS.length; ++j) {
                    if ((maskHit & 1) != 0) {
                        this.err("The element \u201c" + descendantUiString + "\u201d must not appear as a descendant " + "of the element \u201c" + SPECIAL_ANCESTORS[j] + "\u201d.");
                    }
                    maskHit >>= 1;
                }
            }
            if (!(lang == null || xmlLang != null && Html4Assertions.equalsIgnoreAsciiCase(lang, xmlLang))) {
                this.err("When attribute \u201clang\u201d in no namespace is specified, attribute \u201clang\u201d in the XML namespace must also be specified, and both attributes must have the same value.");
            }
            if ("label" == localName && (forVal = atts.getValue("", "for")) != null) {
                this.formControlReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), forVal));
            }
            if ("input" == localName && !hidden || "textarea" == localName || "select" == localName || "button" == localName) {
                this.formControlIds.addAll(ids);
            }
            if ("input" == localName && (Html4Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("radio", atts.getValue("", "type")) || Html4Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("checkbox", atts.getValue("", "type"))) && (atts.getValue("", "value") == null || "".equals(atts.getValue("", "value")))) {
                this.err("Element \u201cinput\u201d with attribute \u201ctype\u201d whose value is \u201cradio\u201d or \u201ccheckbox\u201d must have non-empty attribute \u201cvalue\u201d.");
            }
            if ("option" == localName && selected) {
                for (Map.Entry<StackNode, Locator> entry : this.openSingleSelects.entrySet()) {
                    StackNode node = entry.getKey();
                    if (node.isSelectedOptions()) {
                        this.err("The \u201cselect\u201d element must not have more than one selected \u201coption\u201d descendant unless the \u201cmultiple\u201d attribute is specified.");
                        continue;
                    }
                    node.setSelectedOptions();
                }
            }
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            int number = Html4Assertions.specialAncestorNumber(localName);
            if (number > -1) {
                ancestorMask |= 1 << number;
            }
            if ("a" == localName && hreflang && !href) {
                this.err("Element \u201ca\u201d with attribute \u201chreflang\u201d must have \u201chref\u201d attribute.");
            }
            StackNode child = new StackNode(ancestorMask, localName, role, activeDescendant, forAttr);
            if ("select" == localName && atts.getIndex("", "multiple") == -1) {
                this.openSingleSelects.put(child, this.getDocumentLocator());
            }
            this.push(child);
        }
    }

    static {
        Html4Assertions.registerProhibitedAncestor("a", "a");
        Html4Assertions.registerProhibitedAncestor("button", "a");
        Html4Assertions.registerProhibitedAncestor("button", "button");
        Html4Assertions.registerProhibitedAncestor("button", "fieldset");
        Html4Assertions.registerProhibitedAncestor("button", "form");
        Html4Assertions.registerProhibitedAncestor("button", "iframe");
        Html4Assertions.registerProhibitedAncestor("button", "input");
        Html4Assertions.registerProhibitedAncestor("button", "isindex");
        Html4Assertions.registerProhibitedAncestor("button", "select");
        Html4Assertions.registerProhibitedAncestor("button", "textarea");
        Html4Assertions.registerProhibitedAncestor("form", "form");
        Html4Assertions.registerProhibitedAncestor("label", "label");
        Html4Assertions.registerProhibitedAncestor("pre", "pre");
        Html4Assertions.registerProhibitedAncestor("pre", "img");
        Html4Assertions.registerProhibitedAncestor("pre", "object");
        Html4Assertions.registerProhibitedAncestor("pre", "applet");
        Html4Assertions.registerProhibitedAncestor("pre", "big");
        Html4Assertions.registerProhibitedAncestor("pre", "small");
        Html4Assertions.registerProhibitedAncestor("pre", "sub");
        Html4Assertions.registerProhibitedAncestor("pre", "sup");
        Html4Assertions.registerProhibitedAncestor("pre", "font");
        BUTTON_MASK = 1 << Html4Assertions.specialAncestorNumber("button");
    }

    private class StackNode {
        private final int ancestorMask;
        private boolean selectedOptions = false;
        private boolean optionFound = false;

        public StackNode(int ancestorMask, String name, String role, String activeDescendant, String forAttr) {
            this.ancestorMask = ancestorMask;
        }

        public int getAncestorMask() {
            return this.ancestorMask;
        }

        public boolean isSelectedOptions() {
            return this.selectedOptions;
        }

        public void setSelectedOptions() {
            this.selectedOptions = true;
        }

        public boolean hasOption() {
            return this.optionFound;
        }

        public void setOptionFound() {
            this.optionFound = true;
        }
    }

    private class IdrefLocator {
        private final Locator locator;
        private final String idref;

        public IdrefLocator(Locator locator, String idref) {
            this.locator = new LocatorImpl(locator);
            this.idref = idref;
        }

        public Locator getLocator() {
            return this.locator;
        }

        public String getIdref() {
            return this.idref;
        }
    }
}

