/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.netbeans.modules.cnd.repository.disk.FileStorage;
import org.netbeans.modules.cnd.repository.disk.RepositoryImplUtil;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.spi.Key;

public final class SingleFileStorage
implements FileStorage {
    private final File baseDir;

    SingleFileStorage(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public boolean open(boolean forWriting) {
        if (forWriting && !this.baseDir.isDirectory()) {
            this.baseDir.mkdirs();
        }
        return true;
    }

    @Override
    public boolean hasKey(LayerKey key) throws IOException {
        File file = this.getFile(key);
        return file.exists() && file.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(LayerKey key) throws IOException {
        File file = this.getFile(key);
        if (!file.canRead()) {
            return null;
        }
        long fileSize = file.length();
        if (fileSize >= Integer.MAX_VALUE) {
            throw new InternalError();
        }
        ByteBuffer result = null;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, "r");
            result = ByteBuffer.allocate((int)fileSize);
            f.getChannel().read(result);
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LayerKey key, ByteBuffer data) throws IOException {
        File file = this.getFile(key);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.getChannel().write(data);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Override
    public void remove(LayerKey key) throws IOException {
        File removedFile = this.getFile(key);
        if (removedFile == null) {
            return;
        }
        removedFile.delete();
    }

    @Override
    public void close() throws IOException {
    }

    private File getFile(LayerKey key) throws IOException {
        assert (key != null);
        String fileName = RepositoryImplUtil.getKeyFileName((Key)key);
        return new File(this.baseDir, fileName);
    }

    @Override
    public void debugDump(LayerKey key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void dump(PrintStream ps) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void dumpSummary(PrintStream ps) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public int getObjectsCount() throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public boolean maintenance(long timeout) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public String toString() {
        return "SnglFileStorage: " + this.baseDir;
    }
}

