/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.util.Iterator;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.SupportAPIAccessor;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;

public class APTIncludeUtils {
    private APTIncludeUtils() {
    }

    public static ResolvedPath resolveFilePath(FileSystem fs2, String inclString, CharSequence baseFile) {
        String folder;
        String absolutePath;
        if (baseFile != null && APTIncludeUtils.isExistingFile(fs2, absolutePath = (folder = CndPathUtilities.getDirName((String)baseFile.toString())) + CndFileUtils.getFileSeparatorChar((FileSystem)fs2) + inclString)) {
            absolutePath = APTIncludeUtils.normalize(fs2, absolutePath);
            folder = APTIncludeUtils.normalize(fs2, folder);
            return new ResolvedPath(fs2, FilePathCache.getManager().getString((CharSequence)folder), absolutePath, true, 0);
        }
        return null;
    }

    public static ResolvedPath resolveAbsFilePath(FileSystem fs2, String absFile) {
        if (APTTraceFlags.APT_ABSOLUTE_INCLUDES && CndPathUtilities.isPathAbsolute((CharSequence)absFile) && APTIncludeUtils.isExistingFile(fs2, absFile)) {
            absFile = APTIncludeUtils.normalize(fs2, absFile);
            String parent = CndPathUtilities.getDirName((String)absFile);
            return new ResolvedPath(fs2, FilePathCache.getManager().getString((CharSequence)parent), absFile, false, 0);
        }
        return null;
    }

    public static ResolvedPath resolveFilePath(Iterator<IncludeDirEntry> searchPaths, String anIncludedFile, int dirOffset) {
        SupportAPIAccessor accessor = SupportAPIAccessor.get();
        while (searchPaths.hasNext()) {
            IncludeDirEntry dirPrefix = searchPaths.next();
            if (accessor.isExistingDirectory(dirPrefix)) {
                int i;
                FileSystem fs2 = dirPrefix.getFileSystem();
                char fileSeparatorChar = CndFileUtils.getFileSeparatorChar((FileSystem)fs2);
                String includedFile = anIncludedFile.replace('/', fileSeparatorChar);
                CharSequence prefix = dirPrefix.getAsSharedCharSequence();
                int len = prefix.length();
                String absolutePath = len > 0 && prefix.charAt(len - 1) == fileSeparatorChar ? prefix + includedFile : CharSequenceUtils.toString((CharSequence)prefix, (char)fileSeparatorChar, (CharSequence)includedFile);
                if (APTIncludeUtils.isExistingFile(fs2, absolutePath)) {
                    return new ResolvedPath(fs2, prefix, APTIncludeUtils.normalize(fs2, absolutePath), false, dirOffset);
                }
                if (dirPrefix.isFramework() && (i = includedFile.indexOf(47)) > 0 && APTIncludeUtils.isExistingFile(fs2, absolutePath = dirPrefix.getPath() + "/" + includedFile.substring(0, i) + ".framework/Headers" + includedFile.substring(i))) {
                    return new ResolvedPath(fs2, dirPrefix.getAsSharedCharSequence(), APTIncludeUtils.normalize(fs2, absolutePath), false, dirOffset);
                }
            }
            ++dirOffset;
        }
        return null;
    }

    private static String normalize(FileSystem fs2, String path) {
        return CndFileUtils.normalizeAbsolutePath((FileSystem)fs2, (String)path);
    }

    private static boolean isExistingFile(FileSystem fs2, String filePath) {
        return CndFileUtils.isExistingFile((FileSystem)fs2, (String)filePath);
    }
}

