/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.util.Collection;
import java.util.Collections;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.support.DataBaseEntryBuilder;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileSystemProviderImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public final class APTToClankCompilationDB
implements ClankCompilationDataBase {
    private static boolean SKIP_COMPILER_SETTINGS = Boolean.valueOf(System.getProperty("cnd.skip.compiler.builtin", "false"));
    private final Collection<ClankCompilationDataBase.Entry> compilations;
    private final String name;

    private APTToClankCompilationDB(Collection<ClankCompilationDataBase.Entry> compilations) {
        this("APTToClankDB with [" + compilations.size() + "] entries", compilations);
    }

    private APTToClankCompilationDB(CharSequence dbName, Collection<ClankCompilationDataBase.Entry> compilations) {
        this.name = dbName == null ? "" : dbName.toString();
        this.compilations = Collections.unmodifiableCollection(compilations);
    }

    public Collection<ClankCompilationDataBase.Entry> getCompilations() {
        return this.compilations;
    }

    public String getName() {
        return this.name;
    }

    public static ClankCompilationDataBase convertPPHandler(PreprocHandler ppHandler, CharSequence dbName) {
        ClankCompilationDataBase.Entry entry = APTToClankCompilationDB.createEntry(ppHandler);
        assert (entry != null);
        return new APTToClankCompilationDB(dbName, Collections.singletonList(entry));
    }

    public static boolean isFortran(PreprocHandler ppHandler) {
        try {
            Language language = Language.valueOf(ppHandler.getLanguage().toString());
            return language == Language.FORTRAN;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ClankCompilationDataBase.Entry createEntry(PreprocHandler ppHandler) {
        CharSequence incPathUrl;
        FSPath fsPath;
        FileObject fileObject;
        ClankIncludeHandlerImpl includeHandler = (ClankIncludeHandlerImpl)ppHandler.getIncludeHandler();
        StartEntry startEntry = includeHandler.getStartEntry();
        String startEntryFilePath = startEntry.getStartFile().toString();
        CharSequence startUrl = CndFileSystemProvider.toUrl((FileSystem)startEntry.getFileSystem(), (CharSequence)startEntryFilePath);
        DataBaseEntryBuilder builder = new DataBaseEntryBuilder(startUrl, null);
        builder.setLang(APTToClankCompilationDB.getLang(ppHandler.getLanguage(), startEntryFilePath));
        builder.setLangStd(APTToClankCompilationDB.getLangStd(ppHandler.getLanguageFlavor()));
        for (IncludeDirEntry includeDirEntry : includeHandler.getUserIncludePaths()) {
            if (!includeDirEntry.isExistingDirectory() || (fileObject = (fsPath = new FSPath(includeDirEntry.getFileSystem(), includeDirEntry.getPath())).getFileObject()) == null || !fileObject.isFolder()) continue;
            incPathUrl = fsPath.getURL();
            builder.addUserIncludePath(incPathUrl, includeDirEntry.isFramework(), includeDirEntry.ignoreSysRoot());
        }
        if (!SKIP_COMPILER_SETTINGS) {
            for (IncludeDirEntry includeDirEntry : includeHandler.getSystemIncludePaths()) {
                if (!includeDirEntry.isExistingDirectory() || (fileObject = (fsPath = new FSPath(includeDirEntry.getFileSystem(), includeDirEntry.getPath())).getFileObject()) == null || !fileObject.isFolder()) continue;
                incPathUrl = fsPath.getURL();
                builder.addPredefinedSystemIncludePath(incPathUrl, includeDirEntry.isFramework(), includeDirEntry.ignoreSysRoot());
            }
        }
        for (IncludeDirEntry includeDirEntry : includeHandler.getUserIncludeFilePaths()) {
            fsPath = new FSPath(includeDirEntry.getFileSystem(), includeDirEntry.getPath());
            fileObject = fsPath.getFileObject();
            if (fileObject == null || !fileObject.isData()) continue;
            incPathUrl = fsPath.getURL();
            builder.addIncFile(incPathUrl.toString());
        }
        ClankFileMacroMap macroMap = (ClankFileMacroMap)ppHandler.getMacroMap();
        if (!SKIP_COMPILER_SETTINGS) {
            for (String macro : macroMap.getSystemMacroDefinitions()) {
                builder.addPredefinedSystemMacroDef(macro);
            }
        }
        for (String macro : macroMap.getUserMacroDefinitions()) {
            builder.addUserMacroDef(macro);
        }
        builder.setFileSystem(ClankFileSystemProviderImpl.getInstance().getFileSystem());
        if (CndFileSystemProvider.isRemote((FileSystem)startEntry.getFileSystem())) {
            CharSequence charSequence = CndFileSystemProvider.toUrl((FileSystem)startEntry.getFileSystem(), (CharSequence)"/");
            builder.setAbsPathLookupPrefix(charSequence);
        }
        return builder.createDataBaseEntry();
    }

    private static LangStandard.Kind getLangStd(CharSequence langFlavor) throws AssertionError {
        LangStandard.Kind out_lang_std = LangStandard.Kind.lang_unspecified;
        String strFlavor = langFlavor.toString();
        LanguageFlavor flavor = LanguageFlavor.UNKNOWN;
        if (strFlavor != null && !strFlavor.isEmpty()) {
            try {
                flavor = LanguageFlavor.valueOf(strFlavor);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        switch (flavor) {
            case DEFAULT: 
            case UNKNOWN: {
                break;
            }
            case C: {
                break;
            }
            case C89: {
                out_lang_std = LangStandard.Kind.lang_gnu89;
                break;
            }
            case C99: {
                out_lang_std = LangStandard.Kind.lang_gnu99;
                break;
            }
            case CPP: {
                out_lang_std = LangStandard.Kind.lang_cxx03;
                break;
            }
            case CPP11: {
                out_lang_std = LangStandard.Kind.lang_gnucxx11;
                break;
            }
            case C11: {
                out_lang_std = LangStandard.Kind.lang_gnu11;
                break;
            }
            case CPP14: {
                out_lang_std = LangStandard.Kind.lang_gnucxx1y;
                break;
            }
            case F77: 
            case F90: 
            case F95: {
                out_lang_std = LangStandard.Kind.lang_cxx03;
                break;
            }
            default: {
                throw new AssertionError((Object)(flavor.name() + " from " + langFlavor));
            }
        }
        return out_lang_std;
    }

    private static InputKind getLang(CharSequence langStr, String filePath) throws AssertionError {
        InputKind out = InputKind.IK_None;
        Language language = Language.CPP;
        String strLang = langStr.toString();
        if (strLang != null && !strLang.isEmpty()) {
            try {
                language = Language.valueOf(strLang);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        switch (language) {
            case C: {
                out = InputKind.IK_C;
                break;
            }
            case C_HEADER: {
                out = InputKind.IK_CXX;
                break;
            }
            case CPP: {
                out = InputKind.IK_CXX;
                break;
            }
            case FORTRAN: {
                out = InputKind.IK_CXX;
                break;
            }
            case OTHER: {
                out = InputKind.IK_CXX;
                if (!filePath.endsWith(".c")) break;
                out = InputKind.IK_C;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)language) + " from " + langStr));
            }
        }
        return out;
    }

    private static enum Language {
        C,
        CPP,
        FORTRAN,
        C_HEADER,
        OTHER;

    }

    private static enum LanguageFlavor {
        UNKNOWN(0),
        C(1),
        C89(2),
        C99(3),
        CPP(4),
        CPP11(8),
        F77(5),
        F90(6),
        F95(7),
        DEFAULT(9),
        C11(10),
        CPP14(11);

        private final int flavor;

        private LanguageFlavor(int flavor) {
            this.flavor = flavor;
        }

        public int toExternal() {
            return this.flavor;
        }

        public static LanguageFlavor fromExternal(int i) {
            switch (i) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return C;
                }
                case 2: {
                    return C89;
                }
                case 3: {
                    return C99;
                }
                case 4: {
                    return CPP;
                }
                case 5: {
                    return F77;
                }
                case 6: {
                    return F90;
                }
                case 7: {
                    return F95;
                }
                case 8: {
                    return CPP11;
                }
                case 9: {
                    return DEFAULT;
                }
                case 10: {
                    return C11;
                }
                case 11: {
                    return CPP14;
                }
            }
            return UNKNOWN;
        }
    }
}

