/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class ToolsUtils {
    public static void printMetrics(Map<MetricName, ? extends Metric> metrics) {
        if (metrics != null && !metrics.isEmpty()) {
            int maxLengthOfDisplayName = 0;
            TreeMap<String, Object> sortedMetrics = new TreeMap<String, Object>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Metric metric : metrics.values()) {
                MetricName mName = metric.metricName();
                String mergedName = mName.group() + ":" + mName.name() + ":" + mName.tags();
                maxLengthOfDisplayName = maxLengthOfDisplayName < mergedName.length() ? mergedName.length() : maxLengthOfDisplayName;
                sortedMetrics.put(mergedName, metric.metricValue());
            }
            String doubleOutputFormat = "%-" + maxLengthOfDisplayName + "s : %.3f";
            String string = "%-" + maxLengthOfDisplayName + "s : %s";
            System.out.println(String.format("\n%-" + maxLengthOfDisplayName + "s   %s", "Metric Name", "Value"));
            for (Map.Entry entry : sortedMetrics.entrySet()) {
                String outputFormat = entry.getValue() instanceof Double ? doubleOutputFormat : string;
                System.out.println(String.format(outputFormat, entry.getKey(), entry.getValue()));
            }
        }
    }
}

