/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.StaticPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u000f\t\u0001\u0002K]5nSRLg/Z!qSR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001AA\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\u001c!J|G-^2fe\u000e{gn];nKJ$Vm\u001d;ICJtWm]:\t\u000bA\u0001A\u0011A\t\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\u0005\u0001\u0011\u001d!\u0002A1A\u0005\u0002U\tAC]3rk\u0016\u001cH\u000fS1oI2,'\u000fT8hO\u0016\u0014X#\u0001\f\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012!\u00027pORR'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001eL!a\b\r\u0003\r1{wmZ3s\u0011\u0019\t\u0003\u0001)A\u0005-\u0005)\"/Z9vKN$\b*\u00198eY\u0016\u0014Hj\\4hKJ\u0004\u0003\"B\u0012\u0001\t\u0003!\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0015\u00022AJ\u00170\u001b\u00059#B\u0001\u0015*\u0003%IW.\\;uC\ndWM\u0003\u0002+W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00031\nQa]2bY\u0006L!AL\u0014\u0003\t1K7\u000f\u001e\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001b2\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000bY\u0002A\u0011A\u001c\u0002IQ,7\u000f\u001e$fi\u000eD'+Z9vKN$8)\u00198Qe>\u0004XM\u001d7z'\u0016\u0014\u0018.\u00197ju\u0016$\u0012\u0001\u000f\t\u0003sij\u0011aK\u0005\u0003w-\u0012A!\u00168ji\"\u0012Q'\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001r\tQA[;oSRL!AQ \u0003\tQ+7\u000f\u001e\u0005\u0006\t\u0002!\taN\u0001\u0016i\u0016\u001cH/R7qif4U\r^2i%\u0016\fX/Z:uQ\t\u0019U\bC\u0003H\u0001\u0011\u0005q'\u0001\u0012uKN$H)\u001a4bk2$XI\\2pI\u0016\u0014\bK]8ek\u000e,'/\u00118e\r\u0016$8\r\u001b\u0015\u0003\rvBQA\u0013\u0001\u0005\u0002]\n\u0011\u0007^3ti\u0012+g-Y;mi\u0016s7m\u001c3feB\u0013x\u000eZ;dKJ\fe\u000e\u001a$fi\u000eDw+\u001b;i\u0007>l\u0007O]3tg&|g\u000e\u000b\u0002J{!)Q\n\u0001C\u0005\u001d\u0006!\u0002O]8ek\u000e,\u0017I\u001c3Nk2$\u0018NR3uG\"$\"\u0001O(\t\u000bAc\u0005\u0019A)\u0002\u0011A\u0014x\u000eZ;dKJ\u0004BA\u0015+W-6\t1K\u0003\u0002Q\t%\u0011Qk\u0015\u0002\t!J|G-^2feB\u0011qK\u0018\b\u00031r\u0003\"!W\u0016\u000e\u0003iS!a\u0017\u0004\u0002\rq\u0012xn\u001c;?\u0013\ti6&\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/,\u0011\u0015\u0011\u0007\u0001\"\u00018\u0003a!Xm\u001d;Qe>$WoY3B]\u0012lU\u000f\u001c;j\r\u0016$8\r\u001b\u0015\u0003CvBQ!\u001a\u0001\u0005\n\u0019\fA\"\\;mi&\u0004&o\u001c3vG\u0016$\"\u0001O4\t\u000bA#\u0007\u0019A)\t\u000b%\u0004A\u0011A\u001c\u0002!Q,7\u000f^'vYRL\u0007K]8ek\u000e,\u0007F\u00015>\u0011\u0015a\u0007\u0001\"\u00018\u0003Y!Xm\u001d;D_:\u001cX/\\3s\u000b6\u0004H/\u001f+pa&\u001c\u0007FA6>\u0011\u0015y\u0007\u0001\"\u00018\u0003q!Xm\u001d;QSB,G.\u001b8fIB\u0013x\u000eZ;dKJ+\u0017/^3tiND#A\\\u001f)\t\u0001\u0011Xo\u001e\t\u0003sML!\u0001^\u0016\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001w\u0003!#\u0006.[:!i\u0016\u001cH\u000f\t5bg\u0002\u0012W-\u001a8!I\u0016\u0004(/Z2bi\u0016$\u0007%\u00198eA%$\be^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E]3mK\u0006\u001cX-I\u0001y\u0003!\u0001d&\r\u0019/a9\u0002\u0004")
public class PrimitiveApiTest
extends KafkaServerTestHarness
implements ProducerConsumerTestHarness {
    private final Logger requestHandlerLogger;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    @Before
    public void setUp() {
        ProducerConsumerTestHarness.setUp$(this);
    }

    @Override
    @After
    public void tearDown() {
        ProducerConsumerTestHarness.tearDown$(this);
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()))}));
    }

    @Test
    public void testFetchRequestCanProperlySerialize() {
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").maxWait(10001).minBytes(4444).addFetch("topic1", 0, 0L, 10000).addFetch("topic2", 1, 1024L, 9999).addFetch("topic1", 1, 256L, 444).build();
        ByteBuffer serializedBuffer = ByteBuffer.allocate(request.sizeInBytes());
        request.writeTo(serializedBuffer);
        serializedBuffer.rewind();
        FetchRequest deserializedRequest = FetchRequest$.MODULE$.readFrom(serializedBuffer);
        Assert.assertEquals((Object)request, (Object)deserializedRequest);
    }

    @Test
    public void testEmptyFetchRequest() {
        scala.collection.immutable.Map partitionRequests = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Vector x$12 = partitionRequests.toVector();
        short x$13 = FetchRequest$.MODULE$.$lessinit$greater$default$1();
        int x$14 = FetchRequest$.MODULE$.$lessinit$greater$default$2();
        String x$15 = FetchRequest$.MODULE$.$lessinit$greater$default$3();
        int x$16 = FetchRequest$.MODULE$.$lessinit$greater$default$4();
        int x$17 = FetchRequest$.MODULE$.$lessinit$greater$default$5();
        int x$18 = FetchRequest$.MODULE$.$lessinit$greater$default$6();
        int x$19 = FetchRequest$.MODULE$.$lessinit$greater$default$7();
        FetchRequest request = new FetchRequest(x$13, x$14, x$15, x$16, x$17, x$18, x$19, (Seq)x$12);
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertTrue((!fetched.hasError() && fetched.data().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultEncoderProducerAndFetch() {
        String topic = "test-topic";
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        Replica replica = (Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition(topic, 0)).get();
        Assert.assertTrue((String)"HighWatermark should equal logEndOffset with just 1 replica", (replica.logEndOffset().messageOffset() > 0L && replica.logEndOffset().equals((Object)replica.highWatermark()) ? 1 : 0) != 0);
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").addFetch(topic, 0, 0L, 10000).build();
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertEquals((String)"Returned correlationId doesn't match that in request.", (long)0L, (long)fetched.correlationId());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    @Test
    public void testDefaultEncoderProducerAndFetchWithCompression() {
        String topic = "test-topic";
        Properties props = new Properties();
        props.put("compression.codec", "gzip");
        Producer stringProducer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    private void produceAndMultiFetch(Producer<String, String> producer) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})).foreach((Function1 & Serializable & scala.Serializable)topic -> this.createTopic((String)topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4()));
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$produceAndMultiFetch$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            int partition = tuple2._2$mcI$sp();
            List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a_" + topic, "b_" + topic}));
            List producerData = (List)messageList.map((Function1 & Serializable & scala.Serializable)x$1 -> new KeyedMessage(topic, (Object)topic, x$1), List$.MODULE$.canBuildFrom());
            messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
            producer.send((Seq)producerData);
            FetchRequestBuilder fetchRequestBuilder = builder.addFetch(topic, partition, 0L, 10000);
            return fetchRequestBuilder;
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$produceAndMultiFetch$5(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            PrimitiveApiTest.$anonfun$produceAndMultiFetch$6(messages, response, x$3);
            return BoxedUnit.UNIT;
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$produceAndMultiFetch$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            int partition = tuple2._2$mcI$sp();
            FetchRequestBuilder fetchRequestBuilder = builder2.addFetch(topic, partition, -1L, 10000);
            return fetchRequestBuilder;
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().foreach((Function1 & Serializable & scala.Serializable)pdata -> {
                ErrorMapping$.MODULE$.maybeThrowException(((FetchResponsePartitionData)pdata._2()).error().code());
                return BoxedUnit.UNIT;
            });
            throw this.fail("Expected exception when fetching message with invalid offset", new Position("PrimitiveApiTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$produceAndMultiFetch$11(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                FetchRequestBuilder fetchRequestBuilder = builder3.addFetch(topic, -1, 0L, 10000);
                return fetchRequestBuilder;
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().foreach((Function1 & Serializable & scala.Serializable)pdata -> {
                    ErrorMapping$.MODULE$.maybeThrowException(((FetchResponsePartitionData)pdata._2()).error().code());
                    return BoxedUnit.UNIT;
                });
                throw this.fail("Expected exception when fetching message with invalid partition", new Position("PrimitiveApiTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    @Test
    public void testProduceAndMultiFetch() {
        this.produceAndMultiFetch(this.producer());
    }

    private void multiProduce(Producer<String, String> producer) {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1 & Serializable & scala.Serializable)topic -> this.createTopic((String)topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4()), Iterable$.MODULE$.canBuildFrom());
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$multiProduce$2(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            int partition = tuple2._2$mcI$sp();
            List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a_" + topic, "b_" + topic}));
            List producerData = (List)messageList.map((Function1 & Serializable & scala.Serializable)x$6 -> new KeyedMessage(topic, (Object)topic, x$6), List$.MODULE$.canBuildFrom());
            messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
            producer.send((Seq)producerData);
            FetchRequestBuilder fetchRequestBuilder = builder.addFetch(topic, partition, 0L, 10000);
            return fetchRequestBuilder;
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$multiProduce$5(check$ifrefutable$6))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            PrimitiveApiTest.$anonfun$multiProduce$6(messages, response, x$8);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMultiProduce() {
        this.multiProduce(this.producer());
    }

    @Test
    public void testConsumerEmptyTopic() {
        String newTopic = "new-topic";
        this.createTopic(newTopic, 1, 1, this.createTopic$default$4());
        FetchResponse fetchResponse = this.consumer().fetch(new FetchRequestBuilder().addFetch(newTopic, 0, 0L, 10000).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(newTopic, 0).iterator().hasNext());
    }

    @Test
    public void testPipelinedProduceRequests() {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1 & Serializable & scala.Serializable)topic -> this.createTopic((String)topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4()), Iterable$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("request.required.acks", "0");
        Producer pipelinedProducer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        HashMap messages = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$testPipelinedProduceRequests$2(check$ifrefutable$7))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            int partition = tuple2._2$mcI$sp();
            List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a_" + topic, "b_" + topic}));
            List producerData = (List)messageList.map((Function1 & Serializable & scala.Serializable)x$9 -> new KeyedMessage(topic, (Object)topic, x$9), List$.MODULE$.canBuildFrom());
            messages.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
            pipelinedProducer.send((Seq)producerData);
            FetchRequestBuilder fetchRequestBuilder = builder.addFetch(topic, partition, 0L, 10000);
            return fetchRequestBuilder;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean x$21;
            TopicPartition x$20;
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            return ((Log)qual$1.getLog(x$20 = new TopicPartition("test1", 0), x$21 = qual$1.getLog$default$2()).get()).logEndOffset() == 2L;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean x$23;
            TopicPartition x$22;
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            return ((Log)qual$2.getLog(x$22 = new TopicPartition("test2", 0), x$23 = qual$2.getLog$default$2()).get()).logEndOffset() == 2L;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean x$25;
            TopicPartition x$24;
            LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
            return ((Log)qual$3.getLog(x$24 = new TopicPartition("test3", 0), x$25 = qual$3.getLog$default$2()).get()).logEndOffset() == 2L;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean x$27;
            TopicPartition x$26;
            LogManager qual$4 = ((KafkaServer)this.servers().head()).logManager();
            return ((Log)qual$4.getLog(x$26 = new TopicPartition("test4", 0), x$27 = qual$4.getLog$default$2()).get()).logEndOffset() == 2L;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int replicaId = ((KafkaServer)this.servers().head()).config().brokerId();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition("test1", 0), replicaId).get()).highWatermark().messageOffset() == 2L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition("test2", 0), replicaId).get()).highWatermark().messageOffset() == 2L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition("test3", 0), replicaId).get()).highWatermark().messageOffset() == 2L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().head()).replicaManager().getReplica(new TopicPartition("test4", 0), replicaId).get()).highWatermark().messageOffset() == 2L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)PrimitiveApiTest.$anonfun$testPipelinedProduceRequests$21(check$ifrefutable$8))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            PrimitiveApiTest.$anonfun$testPipelinedProduceRequests$22(messages, response, x$11);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$produceAndMultiFetch$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceAndMultiFetch$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$produceAndMultiFetch$6(HashMap messages$1, FetchResponse response$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        int partition = tuple2._2$mcI$sp();
        ByteBufferMessageSet fetched = response$1.messageSet(topic, partition);
        Assert.assertEquals((Object)messages$1.apply((Object)topic), (Object)fetched.map((Function1 & Serializable & scala.Serializable)messageAndOffset -> TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$produceAndMultiFetch$8(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$produceAndMultiFetch$11(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$multiProduce$2(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$multiProduce$5(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$multiProduce$6(HashMap messages$2, FetchResponse response$2, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        int partition = tuple2._2$mcI$sp();
        ByteBufferMessageSet fetched = response$2.messageSet(topic, partition);
        Assert.assertEquals((Object)messages$2.apply((Object)topic), (Object)fetched.map((Function1 & Serializable & scala.Serializable)messageAndOffset -> TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testPipelinedProduceRequests$2(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2 = check$ifrefutable$7;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testPipelinedProduceRequests$21(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2 = check$ifrefutable$8;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testPipelinedProduceRequests$22(HashMap messages$3, FetchResponse response$3, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        int partition = tuple2._2$mcI$sp();
        ByteBufferMessageSet fetched = response$3.messageSet(topic, partition);
        Assert.assertEquals((Object)messages$3.apply((Object)topic), (Object)fetched.map((Function1 & Serializable & scala.Serializable)messageAndOffset -> TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public PrimitiveApiTest() {
        ProducerConsumerTestHarness.$init$(this);
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

