/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.utils;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public class SAMSequenceDictionaryExtractor {
    @Deprecated
    public static SAMSequenceDictionary extractDictionary(File file) {
        return SAMSequenceDictionaryExtractor.extractDictionary(file.toPath());
    }

    public static SAMSequenceDictionary extractDictionary(Path path) {
        return TYPE.forFile(path).extractDictionary(path);
    }

    static enum TYPE {
        FASTA(FileExtensions.FASTA){

            @Override
            SAMSequenceDictionary extractDictionary(Path reference) {
                SAMSequenceDictionary dict = ReferenceSequenceFileFactory.getReferenceSequenceFile(reference).getSequenceDictionary();
                if (dict == null) {
                    throw new SAMException("Could not find dictionary next to reference file " + reference.toUri().toString());
                }
                return dict;
            }
        }
        ,
        DICTIONARY(new String[]{".dict"}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            SAMSequenceDictionary extractDictionary(Path dictionary) {
                try (BufferedLineReader bufferedLineReader = new BufferedLineReader(ParsingUtils.openInputStream(dictionary.toUri().toString()));){
                    SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                    SAMFileHeader header = codec.decode(bufferedLineReader, dictionary.toString());
                    SAMSequenceDictionary sAMSequenceDictionary = header.getSequenceDictionary();
                    return sAMSequenceDictionary;
                }
                catch (IOException e) {
                    throw new SAMException("Could not open sequence dictionary file: " + dictionary, e);
                }
            }
        }
        ,
        CRAM(new String[]{".cram"}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            SAMSequenceDictionary extractDictionary(Path cramPath) {
                IOUtil.assertFileIsReadable(cramPath);
                try (InputStream in = Files.newInputStream(cramPath, new OpenOption[0]);){
                    CramHeader cramHeader = CramIO.readCramHeader(in);
                    Optional<SAMFileHeader> samHeader = Optional.ofNullable(Container.readSAMFileHeaderContainer(cramHeader.getCRAMVersion(), in, cramPath.toString()));
                    if (!samHeader.isPresent()) throw new SAMException(String.format("Can't retrieve sequence dictionary from %s", cramPath));
                    SAMSequenceDictionary sAMSequenceDictionary = samHeader.get().getSequenceDictionary();
                    return sAMSequenceDictionary;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
        ,
        SAM(new String[]{".sam", ".bam"}){

            @Override
            SAMSequenceDictionary extractDictionary(Path sam) {
                return SamReaderFactory.makeDefault().getFileHeader(sam).getSequenceDictionary();
            }
        }
        ,
        VCF(FileExtensions.VCF_LIST.toArray(new String[0])){

            @Override
            SAMSequenceDictionary extractDictionary(Path vcf) {
                try (VCFFileReader vcfPathReader = new VCFFileReader(vcf, false);){
                    SAMSequenceDictionary sAMSequenceDictionary = vcfPathReader.getFileHeader().getSequenceDictionary();
                    return sAMSequenceDictionary;
                }
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list", ".interval_list.gz"}){

            @Override
            SAMSequenceDictionary extractDictionary(Path intervalList) {
                return IntervalList.fromPath(intervalList).getHeader().getSequenceDictionary();
            }
        };

        final Collection<String> applicableExtensions;

        private TYPE(String ... s) {
            this.applicableExtensions = CollectionUtil.makeSet(s);
        }

        private TYPE(Collection<String> extensions) {
            this.applicableExtensions = extensions;
        }

        @Deprecated
        SAMSequenceDictionary extractDictionary(File file) {
            return this.extractDictionary(file.toPath());
        }

        abstract SAMSequenceDictionary extractDictionary(Path var1);

        @Deprecated
        static TYPE forFile(File dictionaryExtractable) {
            return TYPE.forFile(dictionaryExtractable.toPath());
        }

        static TYPE forFile(Path dictionaryExtractable) {
            for (TYPE type : TYPE.values()) {
                for (String s : type.applicableExtensions) {
                    if (!dictionaryExtractable.toUri().toString().endsWith(s)) continue;
                    return type;
                }
            }
            throw new SAMException("Cannot figure out type of file " + dictionaryExtractable.toUri().toString() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])TYPE.values()));
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }
}

