/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class SkinSplitArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    protected Skin skin = SkinLookAndFeel.getSkin();

    public SkinSplitArrowButton(int direction) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.setBackground(UIManager.getColor("control"));
        Dimension size = this.getPreferredSize();
        this.setSize(size.width, size.height);
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public void setBorder(Border b) {
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getPreferredSize() {
        return this.skin.getSplitPane().getArrowPreferredSize(this.direction);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics g) {
        this.skin.getSplitPane().paintArrow(g, this, this.direction);
    }
}

