/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.BinaryDatatype;
import org.relaxng.datatype.ValidationContext;

class HexBinaryDatatype
extends BinaryDatatype {
    private static final int INVALID = -1;
    private static final int WHITESPACE = -2;

    HexBinaryDatatype() {
    }

    boolean lexicallyAllows(String str) {
        int i;
        int len = str.length();
        for (i = 0; i < len && HexBinaryDatatype.weight(str.charAt(i)) == -2; ++i) {
        }
        while (i + 1 < len && HexBinaryDatatype.weight(str.charAt(i)) >= 0 && HexBinaryDatatype.weight(str.charAt(i + 1)) >= 0) {
            i += 2;
        }
        while (i < len && HexBinaryDatatype.weight(str.charAt(i)) == -2) {
            ++i;
        }
        return i == len;
    }

    Object getValue(String str, ValidationContext vc) {
        int end;
        int start;
        int len = str.length();
        for (start = 0; start < len && HexBinaryDatatype.weight(str.charAt(start)) == -2; ++start) {
        }
        for (end = len; end > start && HexBinaryDatatype.weight(str.charAt(end - 1)) == -2; --end) {
        }
        byte[] value = new byte[end - start >> 1];
        int j = 0;
        int i = start;
        while (i < end) {
            value[j] = (byte)(HexBinaryDatatype.weight(str.charAt(i)) << 4 | HexBinaryDatatype.weight(str.charAt(i + 1)));
            i += 2;
            ++j;
        }
        return value;
    }

    private static int weight(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c + -55;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c + -87;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return -2;
            }
        }
        return -1;
    }
}

