/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutResponse;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

public class RestSamlLogoutAction
extends SamlBaseRestHandler {
    static final ObjectParser<SamlLogoutRequest, Void> PARSER = new ObjectParser("saml_logout", SamlLogoutRequest::new);

    public RestSamlLogoutAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/saml/logout", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_security/saml/logout", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_saml_logout_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlLogoutRequest logoutRequest = (SamlLogoutRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((Action)SamlLogoutAction.INSTANCE, (ActionRequest)logoutRequest, (ActionListener)new RestBuilderListener<SamlLogoutResponse>(channel){

                public RestResponse buildResponse(SamlLogoutResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.field("redirect", response.getRedirectUrl());
                    builder.endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlLogoutRequest::setToken, new ParseField("token", new String[0]));
        PARSER.declareString(SamlLogoutRequest::setRefreshToken, new ParseField("refresh_token", new String[0]));
    }
}

