/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteVpnConnection
extends BaseCmd {
    private String vpnConnectionId;

    public DeleteVpnConnection(String[] args) {
        super("ec2delvpn", "ec2-delete-vpn-connection");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "VPN_CONNECTION";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a VPN connection. The VPN_CONNECTION parameter is the ID of the");
        System.out.println("     VPN connection you want to delete.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpnConnectionId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteVpnConnection(this.vpnConnectionId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "VPN_CONNECTION", this.vpnConnectionId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VPN_GATEWAY");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteVpnConnection(args).invoke();
    }
}

