/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.collector;

import io.prometheus.client.Collector;
import io.prometheus.client.Histogram;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.prometheus.collector.MetricCollector;
import org.apache.solr.prometheus.collector.MetricSamples;
import org.apache.solr.prometheus.exporter.SolrExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerMetricsCollector
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<MetricCollector> metricCollectors;
    private final int duration;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new SolrNamedThreadFactory("scheduled-metrics-collector"));
    private final ExecutorService executor;
    private final List<Observer> observers = new CopyOnWriteArrayList<Observer>();
    private static final Histogram metricsCollectionTime = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("solr_exporter_duration_seconds")).help("Duration taken to record all metrics")).register(SolrExporter.defaultRegistry);

    public SchedulerMetricsCollector(ExecutorService executor, int duration, TimeUnit timeUnit, List<MetricCollector> metricCollectors) {
        this.executor = executor;
        this.metricCollectors = metricCollectors;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(this::collectMetrics, 0L, this.duration, this.timeUnit);
    }

    private void collectMetrics() {
        try (Histogram.Timer timer = metricsCollectionTime.startTimer();){
            log.info("Beginning metrics collection");
            List futures = this.executor.invokeAll(this.metricCollectors.stream().map(metricCollector -> metricCollector::collect).collect(Collectors.toList()));
            MetricSamples metricSamples = new MetricSamples();
            for (Future future : futures) {
                try {
                    metricSamples.addAll((MetricSamples)future.get());
                }
                catch (ExecutionException e) {
                    log.error("Error occurred during metrics collection", e.getCause());
                }
            }
            this.notifyObservers(metricSamples.asList());
            log.info("Completed metrics collection");
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for metric collection to complete", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    private void notifyObservers(List<Collector.MetricFamilySamples> samples) {
        this.observers.forEach(observer -> observer.metricsUpdated(samples));
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
    }

    public static interface Observer {
        public void metricsUpdated(List<Collector.MetricFamilySamples> var1);
    }
}

