/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class NotEvaluator
extends RecursiveBooleanEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public NotEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object value) throws IOException {
        return null;
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (1 != values.length) {
            throw new IOException(String.format(Locale.ROOT, "Expecting 1 value but found %d", values.length));
        }
        return this.doWork(values[0]);
    }

    @Override
    public Object doWork(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.doWork(innerValue));
        }
        return (Boolean)value == false;
    }
}

