/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.CountCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.common.SolrException;

public class CountFunction
extends LongValue.AbstractLongValue
implements ReductionFunction {
    private CountCollector collector;
    public static final String name = "count";
    private final String exprStr;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length == 0) {
            return new CountFunction();
        }
        if (params.length == 1) {
            return new CountFunction(params[0]);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The count function a max of 1 paramater, " + params.length + " given.");
    };

    public CountFunction() {
        this.collector = new CountCollector.TotalCountCollector();
        this.exprStr = AnalyticsValueStream.createExpressionString(name, new AnalyticsValueStream[0]);
    }

    public CountFunction(AnalyticsValueStream param) {
        this.collector = new CountCollector.ExpressionCountCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public long getLong() {
        return this.collector.count();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (CountCollector)sync.apply(this.collector);
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

