/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractClusteringPrefix
implements ClusteringPrefix {
    @Override
    public ClusteringPrefix clustering() {
        return this;
    }

    @Override
    public int dataSize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.get(i);
            size += bb == null ? 0 : bb.remaining();
        }
        return size;
    }

    @Override
    public void digest(MessageDigest digest) {
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.get(i);
            if (bb == null) continue;
            digest.update(bb.duplicate());
        }
        FBUtilities.updateWithByte(digest, this.kind().ordinal());
    }

    public final int hashCode() {
        int result = 31;
        for (int i = 0; i < this.size(); ++i) {
            result += 31 * Objects.hashCode(this.get(i));
        }
        return 31 * result + Objects.hashCode((Object)this.kind());
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ClusteringPrefix)) {
            return false;
        }
        ClusteringPrefix that = (ClusteringPrefix)o;
        if (this.kind() != that.kind() || this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Objects.equals(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }
}

