/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_FALLBACK_H
#define VATOMIC_FALLBACK_H
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */

#include <vsync/common/await_while.h>
#include <vsync/vtypes.h>

/* *****************************************************************************
 * vatomic_cpu_pause
 * ****************************************************************************/

#ifndef vatomic_cpu_pause
    #define vatomic_cpu_pause()                                                \
        do {                                                                   \
        } while (0)
#endif

/* *****************************************************************************
 * vatomic_{get_max, max, max_get}
 * ****************************************************************************/

#ifndef VATOMIC8_GET_MAX
    #define VATOMIC8_GET_MAX

static inline vuint8_t
vatomic8_get_max(vatomic8_t *a, vuint8_t v)
{
    vuint8_t old = 0;
    vuint8_t cur = vatomic8_read(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic8_cmpxchg(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC8_GET_MAX */

#ifndef VATOMIC8_GET_MAX_ACQ
    #define VATOMIC8_GET_MAX_ACQ

static inline vuint8_t
vatomic8_get_max_acq(vatomic8_t *a, vuint8_t v)
{
    vuint8_t old = 0;
    vuint8_t cur = vatomic8_read_acq(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic8_cmpxchg_acq(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC8_GET_MAX_ACQ */

#ifndef VATOMIC8_GET_MAX_REL
    #define VATOMIC8_GET_MAX_REL

static inline vuint8_t
vatomic8_get_max_rel(vatomic8_t *a, vuint8_t v)
{
    vuint8_t old = 0;
    vuint8_t cur = vatomic8_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic8_cmpxchg_rel(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC8_GET_MAX_REL */

#ifndef VATOMIC8_GET_MAX_RLX
    #define VATOMIC8_GET_MAX_RLX

static inline vuint8_t
vatomic8_get_max_rlx(vatomic8_t *a, vuint8_t v)
{
    vuint8_t old = 0;
    vuint8_t cur = vatomic8_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic8_cmpxchg_rlx(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC8_GET_MAX_RLX */

#ifndef VATOMIC16_GET_MAX
    #define VATOMIC16_GET_MAX

static inline vuint16_t
vatomic16_get_max(vatomic16_t *a, vuint16_t v)
{
    vuint16_t old = 0;
    vuint16_t cur = vatomic16_read(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic16_cmpxchg(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC16_GET_MAX */

#ifndef VATOMIC16_GET_MAX_ACQ
    #define VATOMIC16_GET_MAX_ACQ

static inline vuint16_t
vatomic16_get_max_acq(vatomic16_t *a, vuint16_t v)
{
    vuint16_t old = 0;
    vuint16_t cur = vatomic16_read_acq(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic16_cmpxchg_acq(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC16_GET_MAX_ACQ */

#ifndef VATOMIC16_GET_MAX_REL
    #define VATOMIC16_GET_MAX_REL

static inline vuint16_t
vatomic16_get_max_rel(vatomic16_t *a, vuint16_t v)
{
    vuint16_t old = 0;
    vuint16_t cur = vatomic16_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic16_cmpxchg_rel(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC16_GET_MAX_REL */

#ifndef VATOMIC16_GET_MAX_RLX
    #define VATOMIC16_GET_MAX_RLX

static inline vuint16_t
vatomic16_get_max_rlx(vatomic16_t *a, vuint16_t v)
{
    vuint16_t old = 0;
    vuint16_t cur = vatomic16_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic16_cmpxchg_rlx(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC16_GET_MAX_RLX */

#ifndef VATOMIC32_GET_MAX
    #define VATOMIC32_GET_MAX

static inline vuint32_t
vatomic32_get_max(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old = 0;
    vuint32_t cur = vatomic32_read(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic32_cmpxchg(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC32_GET_MAX */

#ifndef VATOMIC32_GET_MAX_ACQ
    #define VATOMIC32_GET_MAX_ACQ

static inline vuint32_t
vatomic32_get_max_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old = 0;
    vuint32_t cur = vatomic32_read_acq(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic32_cmpxchg_acq(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC32_GET_MAX_ACQ */

#ifndef VATOMIC32_GET_MAX_REL
    #define VATOMIC32_GET_MAX_REL

static inline vuint32_t
vatomic32_get_max_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old = 0;
    vuint32_t cur = vatomic32_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic32_cmpxchg_rel(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC32_GET_MAX_REL */

#ifndef VATOMIC32_GET_MAX_RLX
    #define VATOMIC32_GET_MAX_RLX

static inline vuint32_t
vatomic32_get_max_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old = 0;
    vuint32_t cur = vatomic32_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic32_cmpxchg_rlx(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC32_GET_MAX_RLX */

#ifndef VATOMIC64_GET_MAX
    #define VATOMIC64_GET_MAX

static inline vuint64_t
vatomic64_get_max(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old = 0;
    vuint64_t cur = vatomic64_read(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic64_cmpxchg(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC64_GET_MAX */

#ifndef VATOMIC64_GET_MAX_ACQ
    #define VATOMIC64_GET_MAX_ACQ

static inline vuint64_t
vatomic64_get_max_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old = 0;
    vuint64_t cur = vatomic64_read_acq(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic64_cmpxchg_acq(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC64_GET_MAX_ACQ */

#ifndef VATOMIC64_GET_MAX_REL
    #define VATOMIC64_GET_MAX_REL

static inline vuint64_t
vatomic64_get_max_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old = 0;
    vuint64_t cur = vatomic64_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic64_cmpxchg_rel(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC64_GET_MAX_REL */

#ifndef VATOMIC64_GET_MAX_RLX
    #define VATOMIC64_GET_MAX_RLX

static inline vuint64_t
vatomic64_get_max_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old = 0;
    vuint64_t cur = vatomic64_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomic64_cmpxchg_rlx(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMIC64_GET_MAX_RLX */

#ifndef VATOMICSZ_GET_MAX
    #define VATOMICSZ_GET_MAX

static inline vsize_t
vatomicsz_get_max(vatomicsz_t *a, vsize_t v)
{
    vsize_t old = 0;
    vsize_t cur = vatomicsz_read(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomicsz_cmpxchg(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMICSZ_GET_MAX */

#ifndef VATOMICSZ_GET_MAX_ACQ
    #define VATOMICSZ_GET_MAX_ACQ

static inline vsize_t
vatomicsz_get_max_acq(vatomicsz_t *a, vsize_t v)
{
    vsize_t old = 0;
    vsize_t cur = vatomicsz_read_acq(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomicsz_cmpxchg_acq(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMICSZ_GET_MAX_ACQ */

#ifndef VATOMICSZ_GET_MAX_REL
    #define VATOMICSZ_GET_MAX_REL

static inline vsize_t
vatomicsz_get_max_rel(vatomicsz_t *a, vsize_t v)
{
    vsize_t old = 0;
    vsize_t cur = vatomicsz_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomicsz_cmpxchg_rel(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMICSZ_GET_MAX_REL */

#ifndef VATOMICSZ_GET_MAX_RLX
    #define VATOMICSZ_GET_MAX_RLX

static inline vsize_t
vatomicsz_get_max_rlx(vatomicsz_t *a, vsize_t v)
{
    vsize_t old = 0;
    vsize_t cur = vatomicsz_read_rlx(a);
    do {
        old = cur;
        if (old >= v) {
            break;
        }
        cur = vatomicsz_cmpxchg_rlx(a, old, v);
    } while (cur != old);
    return old;
}

#endif /* VATOMICSZ_GET_MAX_RLX */

#ifndef VATOMIC8_MAX_GET
    #define VATOMIC8_MAX_GET

static inline vuint8_t
vatomic8_max_get(vatomic8_t *a, vuint8_t v)
{
    vuint8_t o = vatomic8_get_max(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC8_MAX_GET */

#ifndef VATOMIC8_MAX_GET_ACQ
    #define VATOMIC8_MAX_GET_ACQ

static inline vuint8_t
vatomic8_max_get_acq(vatomic8_t *a, vuint8_t v)
{
    vuint8_t o = vatomic8_get_max_acq(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC8_MAX_GET_ACQ */

#ifndef VATOMIC8_MAX_GET_REL
    #define VATOMIC8_MAX_GET_REL

static inline vuint8_t
vatomic8_max_get_rel(vatomic8_t *a, vuint8_t v)
{
    vuint8_t o = vatomic8_get_max_rel(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC8_MAX_GET_REL */

#ifndef VATOMIC8_MAX_GET_RLX
    #define VATOMIC8_MAX_GET_RLX

static inline vuint8_t
vatomic8_max_get_rlx(vatomic8_t *a, vuint8_t v)
{
    vuint8_t o = vatomic8_get_max_rlx(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC8_MAX_GET_RLX */

#ifndef VATOMIC16_MAX_GET
    #define VATOMIC16_MAX_GET

static inline vuint16_t
vatomic16_max_get(vatomic16_t *a, vuint16_t v)
{
    vuint16_t o = vatomic16_get_max(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC16_MAX_GET */

#ifndef VATOMIC16_MAX_GET_ACQ
    #define VATOMIC16_MAX_GET_ACQ

static inline vuint16_t
vatomic16_max_get_acq(vatomic16_t *a, vuint16_t v)
{
    vuint16_t o = vatomic16_get_max_acq(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC16_MAX_GET_ACQ */

#ifndef VATOMIC16_MAX_GET_REL
    #define VATOMIC16_MAX_GET_REL

static inline vuint16_t
vatomic16_max_get_rel(vatomic16_t *a, vuint16_t v)
{
    vuint16_t o = vatomic16_get_max_rel(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC16_MAX_GET_REL */

#ifndef VATOMIC16_MAX_GET_RLX
    #define VATOMIC16_MAX_GET_RLX

static inline vuint16_t
vatomic16_max_get_rlx(vatomic16_t *a, vuint16_t v)
{
    vuint16_t o = vatomic16_get_max_rlx(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC16_MAX_GET_RLX */

#ifndef VATOMIC32_MAX_GET
    #define VATOMIC32_MAX_GET

static inline vuint32_t
vatomic32_max_get(vatomic32_t *a, vuint32_t v)
{
    vuint32_t o = vatomic32_get_max(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC32_MAX_GET */

#ifndef VATOMIC32_MAX_GET_ACQ
    #define VATOMIC32_MAX_GET_ACQ

static inline vuint32_t
vatomic32_max_get_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t o = vatomic32_get_max_acq(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC32_MAX_GET_ACQ */

#ifndef VATOMIC32_MAX_GET_REL
    #define VATOMIC32_MAX_GET_REL

static inline vuint32_t
vatomic32_max_get_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t o = vatomic32_get_max_rel(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC32_MAX_GET_REL */

#ifndef VATOMIC32_MAX_GET_RLX
    #define VATOMIC32_MAX_GET_RLX

static inline vuint32_t
vatomic32_max_get_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t o = vatomic32_get_max_rlx(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC32_MAX_GET_RLX */

#ifndef VATOMIC64_MAX_GET
    #define VATOMIC64_MAX_GET

static inline vuint64_t
vatomic64_max_get(vatomic64_t *a, vuint64_t v)
{
    vuint64_t o = vatomic64_get_max(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC64_MAX_GET */

#ifndef VATOMIC64_MAX_GET_ACQ
    #define VATOMIC64_MAX_GET_ACQ

static inline vuint64_t
vatomic64_max_get_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t o = vatomic64_get_max_acq(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC64_MAX_GET_ACQ */

#ifndef VATOMIC64_MAX_GET_REL
    #define VATOMIC64_MAX_GET_REL

static inline vuint64_t
vatomic64_max_get_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t o = vatomic64_get_max_rel(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC64_MAX_GET_REL */

#ifndef VATOMIC64_MAX_GET_RLX
    #define VATOMIC64_MAX_GET_RLX

static inline vuint64_t
vatomic64_max_get_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t o = vatomic64_get_max_rlx(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMIC64_MAX_GET_RLX */

#ifndef VATOMICSZ_MAX_GET
    #define VATOMICSZ_MAX_GET

static inline vsize_t
vatomicsz_max_get(vatomicsz_t *a, vsize_t v)
{
    vsize_t o = vatomicsz_get_max(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMICSZ_MAX_GET */

#ifndef VATOMICSZ_MAX_GET_ACQ
    #define VATOMICSZ_MAX_GET_ACQ

static inline vsize_t
vatomicsz_max_get_acq(vatomicsz_t *a, vsize_t v)
{
    vsize_t o = vatomicsz_get_max_acq(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMICSZ_MAX_GET_ACQ */

#ifndef VATOMICSZ_MAX_GET_REL
    #define VATOMICSZ_MAX_GET_REL

static inline vsize_t
vatomicsz_max_get_rel(vatomicsz_t *a, vsize_t v)
{
    vsize_t o = vatomicsz_get_max_rel(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMICSZ_MAX_GET_REL */

#ifndef VATOMICSZ_MAX_GET_RLX
    #define VATOMICSZ_MAX_GET_RLX

static inline vsize_t
vatomicsz_max_get_rlx(vatomicsz_t *a, vsize_t v)
{
    vsize_t o = vatomicsz_get_max_rlx(a, v);
    return o >= v ? o : v;
}

#endif /* VATOMICSZ_MAX_GET_RLX */

#ifndef VATOMIC8_MAX
    #define VATOMIC8_MAX

static inline void
vatomic8_max(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_max(a, v);
}

#endif /* VATOMIC8_MAX */

#ifndef VATOMIC8_MAX_REL
    #define VATOMIC8_MAX_REL

static inline void
vatomic8_max_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_max_rel(a, v);
}

#endif /* VATOMIC8_MAX_REL */

#ifndef VATOMIC8_MAX_RLX
    #define VATOMIC8_MAX_RLX

static inline void
vatomic8_max_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_max_rlx(a, v);
}

#endif /* VATOMIC8_MAX_RLX */

#ifndef VATOMIC16_MAX
    #define VATOMIC16_MAX

static inline void
vatomic16_max(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_max(a, v);
}

#endif /* VATOMIC16_MAX */

#ifndef VATOMIC16_MAX_REL
    #define VATOMIC16_MAX_REL

static inline void
vatomic16_max_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_max_rel(a, v);
}

#endif /* VATOMIC16_MAX_REL */

#ifndef VATOMIC16_MAX_RLX
    #define VATOMIC16_MAX_RLX

static inline void
vatomic16_max_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_max_rlx(a, v);
}

#endif /* VATOMIC16_MAX_RLX */

#ifndef VATOMIC32_MAX
    #define VATOMIC32_MAX

static inline void
vatomic32_max(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_max(a, v);
}

#endif /* VATOMIC32_MAX */

#ifndef VATOMIC32_MAX_REL
    #define VATOMIC32_MAX_REL

static inline void
vatomic32_max_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_max_rel(a, v);
}

#endif /* VATOMIC32_MAX_REL */

#ifndef VATOMIC32_MAX_RLX
    #define VATOMIC32_MAX_RLX

static inline void
vatomic32_max_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_max_rlx(a, v);
}

#endif /* VATOMIC32_MAX_RLX */

#ifndef VATOMIC64_MAX
    #define VATOMIC64_MAX

static inline void
vatomic64_max(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_max(a, v);
}

#endif /* VATOMIC64_MAX */

#ifndef VATOMIC64_MAX_REL
    #define VATOMIC64_MAX_REL

static inline void
vatomic64_max_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_max_rel(a, v);
}

#endif /* VATOMIC64_MAX_REL */

#ifndef VATOMIC64_MAX_RLX
    #define VATOMIC64_MAX_RLX

static inline void
vatomic64_max_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_max_rlx(a, v);
}

#endif /* VATOMIC64_MAX_RLX */

#ifndef VATOMICSZ_MAX
    #define VATOMICSZ_MAX

static inline void
vatomicsz_max(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_max(a, v);
}

#endif /* VATOMICSZ_MAX */

#ifndef VATOMICSZ_MAX_REL
    #define VATOMICSZ_MAX_REL

static inline void
vatomicsz_max_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_max_rel(a, v);
}

#endif /* VATOMICSZ_MAX_REL */

#ifndef VATOMICSZ_MAX_RLX
    #define VATOMICSZ_MAX_RLX

static inline void
vatomicsz_max_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_max_rlx(a, v);
}

#endif /* VATOMICSZ_MAX_RLX */

/* *****************************************************************************
 * vatomic_{get_and, and, and_get}
 * ****************************************************************************/

#ifndef VATOMIC8_AND_GET
    #define VATOMIC8_AND_GET

static inline vuint8_t
vatomic8_and_get(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_and(a, v) & v;
}

#endif /* VATOMIC8_AND_GET */

#ifndef VATOMIC8_AND_GET_ACQ
    #define VATOMIC8_AND_GET_ACQ

static inline vuint8_t
vatomic8_and_get_acq(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_and_acq(a, v) & v;
}

#endif /* VATOMIC8_AND_GET_ACQ */

#ifndef VATOMIC8_AND_GET_REL
    #define VATOMIC8_AND_GET_REL

static inline vuint8_t
vatomic8_and_get_rel(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_and_rel(a, v) & v;
}

#endif /* VATOMIC8_AND_GET_REL */

#ifndef VATOMIC8_AND_GET_RLX
    #define VATOMIC8_AND_GET_RLX

static inline vuint8_t
vatomic8_and_get_rlx(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_and_rlx(a, v) & v;
}

#endif /* VATOMIC8_AND_GET_RLX */

#ifndef VATOMIC16_AND_GET
    #define VATOMIC16_AND_GET

static inline vuint16_t
vatomic16_and_get(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_and(a, v) & v;
}

#endif /* VATOMIC16_AND_GET */

#ifndef VATOMIC16_AND_GET_ACQ
    #define VATOMIC16_AND_GET_ACQ

static inline vuint16_t
vatomic16_and_get_acq(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_and_acq(a, v) & v;
}

#endif /* VATOMIC16_AND_GET_ACQ */

#ifndef VATOMIC16_AND_GET_REL
    #define VATOMIC16_AND_GET_REL

static inline vuint16_t
vatomic16_and_get_rel(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_and_rel(a, v) & v;
}

#endif /* VATOMIC16_AND_GET_REL */

#ifndef VATOMIC16_AND_GET_RLX
    #define VATOMIC16_AND_GET_RLX

static inline vuint16_t
vatomic16_and_get_rlx(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_and_rlx(a, v) & v;
}

#endif /* VATOMIC16_AND_GET_RLX */

#ifndef VATOMIC32_AND_GET
    #define VATOMIC32_AND_GET

static inline vuint32_t
vatomic32_and_get(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_and(a, v) & v;
}

#endif /* VATOMIC32_AND_GET */

#ifndef VATOMIC32_AND_GET_ACQ
    #define VATOMIC32_AND_GET_ACQ

static inline vuint32_t
vatomic32_and_get_acq(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_and_acq(a, v) & v;
}

#endif /* VATOMIC32_AND_GET_ACQ */

#ifndef VATOMIC32_AND_GET_REL
    #define VATOMIC32_AND_GET_REL

static inline vuint32_t
vatomic32_and_get_rel(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_and_rel(a, v) & v;
}

#endif /* VATOMIC32_AND_GET_REL */

#ifndef VATOMIC32_AND_GET_RLX
    #define VATOMIC32_AND_GET_RLX

static inline vuint32_t
vatomic32_and_get_rlx(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_and_rlx(a, v) & v;
}

#endif /* VATOMIC32_AND_GET_RLX */

#ifndef VATOMIC64_AND_GET
    #define VATOMIC64_AND_GET

static inline vuint64_t
vatomic64_and_get(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_and(a, v) & v;
}

#endif /* VATOMIC64_AND_GET */

#ifndef VATOMIC64_AND_GET_ACQ
    #define VATOMIC64_AND_GET_ACQ

static inline vuint64_t
vatomic64_and_get_acq(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_and_acq(a, v) & v;
}

#endif /* VATOMIC64_AND_GET_ACQ */

#ifndef VATOMIC64_AND_GET_REL
    #define VATOMIC64_AND_GET_REL

static inline vuint64_t
vatomic64_and_get_rel(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_and_rel(a, v) & v;
}

#endif /* VATOMIC64_AND_GET_REL */

#ifndef VATOMIC64_AND_GET_RLX
    #define VATOMIC64_AND_GET_RLX

static inline vuint64_t
vatomic64_and_get_rlx(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_and_rlx(a, v) & v;
}

#endif /* VATOMIC64_AND_GET_RLX */

#ifndef VATOMICSZ_AND_GET
    #define VATOMICSZ_AND_GET

static inline vsize_t
vatomicsz_and_get(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_and(a, v) & v;
}

#endif /* VATOMICSZ_AND_GET */

#ifndef VATOMICSZ_AND_GET_ACQ
    #define VATOMICSZ_AND_GET_ACQ

static inline vsize_t
vatomicsz_and_get_acq(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_and_acq(a, v) & v;
}

#endif /* VATOMICSZ_AND_GET_ACQ */

#ifndef VATOMICSZ_AND_GET_REL
    #define VATOMICSZ_AND_GET_REL

static inline vsize_t
vatomicsz_and_get_rel(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_and_rel(a, v) & v;
}

#endif /* VATOMICSZ_AND_GET_REL */

#ifndef VATOMICSZ_AND_GET_RLX
    #define VATOMICSZ_AND_GET_RLX

static inline vsize_t
vatomicsz_and_get_rlx(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_and_rlx(a, v) & v;
}

#endif /* VATOMICSZ_AND_GET_RLX */

#ifndef VATOMIC8_AND
    #define VATOMIC8_AND

static inline void
vatomic8_and(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_and(a, v);
}

#endif /* VATOMIC8_AND */

#ifndef VATOMIC8_AND_REL
    #define VATOMIC8_AND_REL

static inline void
vatomic8_and_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_and_rel(a, v);
}

#endif /* VATOMIC8_AND_REL */

#ifndef VATOMIC8_AND_RLX
    #define VATOMIC8_AND_RLX

static inline void
vatomic8_and_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_and_rlx(a, v);
}

#endif /* VATOMIC8_AND_RLX */

#ifndef VATOMIC16_AND
    #define VATOMIC16_AND

static inline void
vatomic16_and(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_and(a, v);
}

#endif /* VATOMIC16_AND */

#ifndef VATOMIC16_AND_REL
    #define VATOMIC16_AND_REL

static inline void
vatomic16_and_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_and_rel(a, v);
}

#endif /* VATOMIC16_AND_REL */

#ifndef VATOMIC16_AND_RLX
    #define VATOMIC16_AND_RLX

static inline void
vatomic16_and_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_and_rlx(a, v);
}

#endif /* VATOMIC16_AND_RLX */

#ifndef VATOMIC32_AND
    #define VATOMIC32_AND

static inline void
vatomic32_and(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_and(a, v);
}

#endif /* VATOMIC32_AND */

#ifndef VATOMIC32_AND_REL
    #define VATOMIC32_AND_REL

static inline void
vatomic32_and_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_and_rel(a, v);
}

#endif /* VATOMIC32_AND_REL */

#ifndef VATOMIC32_AND_RLX
    #define VATOMIC32_AND_RLX

static inline void
vatomic32_and_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_and_rlx(a, v);
}

#endif /* VATOMIC32_AND_RLX */

#ifndef VATOMIC64_AND
    #define VATOMIC64_AND

static inline void
vatomic64_and(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_and(a, v);
}

#endif /* VATOMIC64_AND */

#ifndef VATOMIC64_AND_REL
    #define VATOMIC64_AND_REL

static inline void
vatomic64_and_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_and_rel(a, v);
}

#endif /* VATOMIC64_AND_REL */

#ifndef VATOMIC64_AND_RLX
    #define VATOMIC64_AND_RLX

static inline void
vatomic64_and_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_and_rlx(a, v);
}

#endif /* VATOMIC64_AND_RLX */

#ifndef VATOMICSZ_AND
    #define VATOMICSZ_AND

static inline void
vatomicsz_and(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_and(a, v);
}

#endif /* VATOMICSZ_AND */

#ifndef VATOMICSZ_AND_REL
    #define VATOMICSZ_AND_REL

static inline void
vatomicsz_and_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_and_rel(a, v);
}

#endif /* VATOMICSZ_AND_REL */

#ifndef VATOMICSZ_AND_RLX
    #define VATOMICSZ_AND_RLX

static inline void
vatomicsz_and_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_and_rlx(a, v);
}

#endif /* VATOMICSZ_AND_RLX */

/* *****************************************************************************
 * vatomic_{get_or, or, or_get}
 * ****************************************************************************/

#ifndef VATOMIC8_OR_GET
    #define VATOMIC8_OR_GET

static inline vuint8_t
vatomic8_or_get(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_or(a, v) | v;
}

#endif /* VATOMIC8_OR_GET */

#ifndef VATOMIC8_OR_GET_ACQ
    #define VATOMIC8_OR_GET_ACQ

static inline vuint8_t
vatomic8_or_get_acq(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_or_acq(a, v) | v;
}

#endif /* VATOMIC8_OR_GET_ACQ */

#ifndef VATOMIC8_OR_GET_REL
    #define VATOMIC8_OR_GET_REL

static inline vuint8_t
vatomic8_or_get_rel(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_or_rel(a, v) | v;
}

#endif /* VATOMIC8_OR_GET_REL */

#ifndef VATOMIC8_OR_GET_RLX
    #define VATOMIC8_OR_GET_RLX

static inline vuint8_t
vatomic8_or_get_rlx(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_or_rlx(a, v) | v;
}

#endif /* VATOMIC8_OR_GET_RLX */

#ifndef VATOMIC16_OR_GET
    #define VATOMIC16_OR_GET

static inline vuint16_t
vatomic16_or_get(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_or(a, v) | v;
}

#endif /* VATOMIC16_OR_GET */

#ifndef VATOMIC16_OR_GET_ACQ
    #define VATOMIC16_OR_GET_ACQ

static inline vuint16_t
vatomic16_or_get_acq(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_or_acq(a, v) | v;
}

#endif /* VATOMIC16_OR_GET_ACQ */

#ifndef VATOMIC16_OR_GET_REL
    #define VATOMIC16_OR_GET_REL

static inline vuint16_t
vatomic16_or_get_rel(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_or_rel(a, v) | v;
}

#endif /* VATOMIC16_OR_GET_REL */

#ifndef VATOMIC16_OR_GET_RLX
    #define VATOMIC16_OR_GET_RLX

static inline vuint16_t
vatomic16_or_get_rlx(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_or_rlx(a, v) | v;
}

#endif /* VATOMIC16_OR_GET_RLX */

#ifndef VATOMIC32_OR_GET
    #define VATOMIC32_OR_GET

static inline vuint32_t
vatomic32_or_get(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_or(a, v) | v;
}

#endif /* VATOMIC32_OR_GET */

#ifndef VATOMIC32_OR_GET_ACQ
    #define VATOMIC32_OR_GET_ACQ

static inline vuint32_t
vatomic32_or_get_acq(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_or_acq(a, v) | v;
}

#endif /* VATOMIC32_OR_GET_ACQ */

#ifndef VATOMIC32_OR_GET_REL
    #define VATOMIC32_OR_GET_REL

static inline vuint32_t
vatomic32_or_get_rel(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_or_rel(a, v) | v;
}

#endif /* VATOMIC32_OR_GET_REL */

#ifndef VATOMIC32_OR_GET_RLX
    #define VATOMIC32_OR_GET_RLX

static inline vuint32_t
vatomic32_or_get_rlx(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_or_rlx(a, v) | v;
}

#endif /* VATOMIC32_OR_GET_RLX */

#ifndef VATOMIC64_OR_GET
    #define VATOMIC64_OR_GET

static inline vuint64_t
vatomic64_or_get(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_or(a, v) | v;
}

#endif /* VATOMIC64_OR_GET */

#ifndef VATOMIC64_OR_GET_ACQ
    #define VATOMIC64_OR_GET_ACQ

static inline vuint64_t
vatomic64_or_get_acq(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_or_acq(a, v) | v;
}

#endif /* VATOMIC64_OR_GET_ACQ */

#ifndef VATOMIC64_OR_GET_REL
    #define VATOMIC64_OR_GET_REL

static inline vuint64_t
vatomic64_or_get_rel(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_or_rel(a, v) | v;
}

#endif /* VATOMIC64_OR_GET_REL */

#ifndef VATOMIC64_OR_GET_RLX
    #define VATOMIC64_OR_GET_RLX

static inline vuint64_t
vatomic64_or_get_rlx(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_or_rlx(a, v) | v;
}

#endif /* VATOMIC64_OR_GET_RLX */

#ifndef VATOMICSZ_OR_GET
    #define VATOMICSZ_OR_GET

static inline vsize_t
vatomicsz_or_get(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_or(a, v) | v;
}

#endif /* VATOMICSZ_OR_GET */

#ifndef VATOMICSZ_OR_GET_ACQ
    #define VATOMICSZ_OR_GET_ACQ

static inline vsize_t
vatomicsz_or_get_acq(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_or_acq(a, v) | v;
}

#endif /* VATOMICSZ_OR_GET_ACQ */

#ifndef VATOMICSZ_OR_GET_REL
    #define VATOMICSZ_OR_GET_REL

static inline vsize_t
vatomicsz_or_get_rel(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_or_rel(a, v) | v;
}

#endif /* VATOMICSZ_OR_GET_REL */

#ifndef VATOMICSZ_OR_GET_RLX
    #define VATOMICSZ_OR_GET_RLX

static inline vsize_t
vatomicsz_or_get_rlx(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_or_rlx(a, v) | v;
}

#endif /* VATOMICSZ_OR_GET_RLX */

#ifndef VATOMIC8_OR
    #define VATOMIC8_OR

static inline void
vatomic8_or(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_or(a, v);
}

#endif /* VATOMIC8_OR */

#ifndef VATOMIC8_OR_REL
    #define VATOMIC8_OR_REL

static inline void
vatomic8_or_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_or_rel(a, v);
}

#endif /* VATOMIC8_OR_REL */

#ifndef VATOMIC8_OR_RLX
    #define VATOMIC8_OR_RLX

static inline void
vatomic8_or_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_or_rlx(a, v);
}

#endif /* VATOMIC8_OR_RLX */

#ifndef VATOMIC16_OR
    #define VATOMIC16_OR

static inline void
vatomic16_or(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_or(a, v);
}

#endif /* VATOMIC16_OR */

#ifndef VATOMIC16_OR_REL
    #define VATOMIC16_OR_REL

static inline void
vatomic16_or_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_or_rel(a, v);
}

#endif /* VATOMIC16_OR_REL */

#ifndef VATOMIC16_OR_RLX
    #define VATOMIC16_OR_RLX

static inline void
vatomic16_or_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_or_rlx(a, v);
}

#endif /* VATOMIC16_OR_RLX */

#ifndef VATOMIC32_OR
    #define VATOMIC32_OR

static inline void
vatomic32_or(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_or(a, v);
}

#endif /* VATOMIC32_OR */

#ifndef VATOMIC32_OR_REL
    #define VATOMIC32_OR_REL

static inline void
vatomic32_or_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_or_rel(a, v);
}

#endif /* VATOMIC32_OR_REL */

#ifndef VATOMIC32_OR_RLX
    #define VATOMIC32_OR_RLX

static inline void
vatomic32_or_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_or_rlx(a, v);
}

#endif /* VATOMIC32_OR_RLX */

#ifndef VATOMIC64_OR
    #define VATOMIC64_OR

static inline void
vatomic64_or(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_or(a, v);
}

#endif /* VATOMIC64_OR */

#ifndef VATOMIC64_OR_REL
    #define VATOMIC64_OR_REL

static inline void
vatomic64_or_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_or_rel(a, v);
}

#endif /* VATOMIC64_OR_REL */

#ifndef VATOMIC64_OR_RLX
    #define VATOMIC64_OR_RLX

static inline void
vatomic64_or_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_or_rlx(a, v);
}

#endif /* VATOMIC64_OR_RLX */

#ifndef VATOMICSZ_OR
    #define VATOMICSZ_OR

static inline void
vatomicsz_or(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_or(a, v);
}

#endif /* VATOMICSZ_OR */

#ifndef VATOMICSZ_OR_REL
    #define VATOMICSZ_OR_REL

static inline void
vatomicsz_or_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_or_rel(a, v);
}

#endif /* VATOMICSZ_OR_REL */

#ifndef VATOMICSZ_OR_RLX
    #define VATOMICSZ_OR_RLX

static inline void
vatomicsz_or_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_or_rlx(a, v);
}

#endif /* VATOMICSZ_OR_RLX */

/* *****************************************************************************
 * vatomic_{get_xor, xor, xor_get}
 * ****************************************************************************/

#ifndef VATOMIC8_XOR_GET
    #define VATOMIC8_XOR_GET

static inline vuint8_t
vatomic8_xor_get(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_xor(a, v) ^ v;
}

#endif /* VATOMIC8_XOR_GET */

#ifndef VATOMIC8_XOR_GET_ACQ
    #define VATOMIC8_XOR_GET_ACQ

static inline vuint8_t
vatomic8_xor_get_acq(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_xor_acq(a, v) ^ v;
}

#endif /* VATOMIC8_XOR_GET_ACQ */

#ifndef VATOMIC8_XOR_GET_REL
    #define VATOMIC8_XOR_GET_REL

static inline vuint8_t
vatomic8_xor_get_rel(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_xor_rel(a, v) ^ v;
}

#endif /* VATOMIC8_XOR_GET_REL */

#ifndef VATOMIC8_XOR_GET_RLX
    #define VATOMIC8_XOR_GET_RLX

static inline vuint8_t
vatomic8_xor_get_rlx(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_xor_rlx(a, v) ^ v;
}

#endif /* VATOMIC8_XOR_GET_RLX */

#ifndef VATOMIC16_XOR_GET
    #define VATOMIC16_XOR_GET

static inline vuint16_t
vatomic16_xor_get(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_xor(a, v) ^ v;
}

#endif /* VATOMIC16_XOR_GET */

#ifndef VATOMIC16_XOR_GET_ACQ
    #define VATOMIC16_XOR_GET_ACQ

static inline vuint16_t
vatomic16_xor_get_acq(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_xor_acq(a, v) ^ v;
}

#endif /* VATOMIC16_XOR_GET_ACQ */

#ifndef VATOMIC16_XOR_GET_REL
    #define VATOMIC16_XOR_GET_REL

static inline vuint16_t
vatomic16_xor_get_rel(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_xor_rel(a, v) ^ v;
}

#endif /* VATOMIC16_XOR_GET_REL */

#ifndef VATOMIC16_XOR_GET_RLX
    #define VATOMIC16_XOR_GET_RLX

static inline vuint16_t
vatomic16_xor_get_rlx(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_xor_rlx(a, v) ^ v;
}

#endif /* VATOMIC16_XOR_GET_RLX */

#ifndef VATOMIC32_XOR_GET
    #define VATOMIC32_XOR_GET

static inline vuint32_t
vatomic32_xor_get(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_xor(a, v) ^ v;
}

#endif /* VATOMIC32_XOR_GET */

#ifndef VATOMIC32_XOR_GET_ACQ
    #define VATOMIC32_XOR_GET_ACQ

static inline vuint32_t
vatomic32_xor_get_acq(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_xor_acq(a, v) ^ v;
}

#endif /* VATOMIC32_XOR_GET_ACQ */

#ifndef VATOMIC32_XOR_GET_REL
    #define VATOMIC32_XOR_GET_REL

static inline vuint32_t
vatomic32_xor_get_rel(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_xor_rel(a, v) ^ v;
}

#endif /* VATOMIC32_XOR_GET_REL */

#ifndef VATOMIC32_XOR_GET_RLX
    #define VATOMIC32_XOR_GET_RLX

static inline vuint32_t
vatomic32_xor_get_rlx(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_xor_rlx(a, v) ^ v;
}

#endif /* VATOMIC32_XOR_GET_RLX */

#ifndef VATOMIC64_XOR_GET
    #define VATOMIC64_XOR_GET

static inline vuint64_t
vatomic64_xor_get(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_xor(a, v) ^ v;
}

#endif /* VATOMIC64_XOR_GET */

#ifndef VATOMIC64_XOR_GET_ACQ
    #define VATOMIC64_XOR_GET_ACQ

static inline vuint64_t
vatomic64_xor_get_acq(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_xor_acq(a, v) ^ v;
}

#endif /* VATOMIC64_XOR_GET_ACQ */

#ifndef VATOMIC64_XOR_GET_REL
    #define VATOMIC64_XOR_GET_REL

static inline vuint64_t
vatomic64_xor_get_rel(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_xor_rel(a, v) ^ v;
}

#endif /* VATOMIC64_XOR_GET_REL */

#ifndef VATOMIC64_XOR_GET_RLX
    #define VATOMIC64_XOR_GET_RLX

static inline vuint64_t
vatomic64_xor_get_rlx(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_xor_rlx(a, v) ^ v;
}

#endif /* VATOMIC64_XOR_GET_RLX */

#ifndef VATOMICSZ_XOR_GET
    #define VATOMICSZ_XOR_GET

static inline vsize_t
vatomicsz_xor_get(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_xor(a, v) ^ v;
}

#endif /* VATOMICSZ_XOR_GET */

#ifndef VATOMICSZ_XOR_GET_ACQ
    #define VATOMICSZ_XOR_GET_ACQ

static inline vsize_t
vatomicsz_xor_get_acq(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_xor_acq(a, v) ^ v;
}

#endif /* VATOMICSZ_XOR_GET_ACQ */

#ifndef VATOMICSZ_XOR_GET_REL
    #define VATOMICSZ_XOR_GET_REL

static inline vsize_t
vatomicsz_xor_get_rel(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_xor_rel(a, v) ^ v;
}

#endif /* VATOMICSZ_XOR_GET_REL */

#ifndef VATOMICSZ_XOR_GET_RLX
    #define VATOMICSZ_XOR_GET_RLX

static inline vsize_t
vatomicsz_xor_get_rlx(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_xor_rlx(a, v) ^ v;
}

#endif /* VATOMICSZ_XOR_GET_RLX */

#ifndef VATOMIC8_XOR
    #define VATOMIC8_XOR

static inline void
vatomic8_xor(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_xor(a, v);
}

#endif /* VATOMIC8_XOR */

#ifndef VATOMIC8_XOR_REL
    #define VATOMIC8_XOR_REL

static inline void
vatomic8_xor_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_xor_rel(a, v);
}

#endif /* VATOMIC8_XOR_REL */

#ifndef VATOMIC8_XOR_RLX
    #define VATOMIC8_XOR_RLX

static inline void
vatomic8_xor_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_xor_rlx(a, v);
}

#endif /* VATOMIC8_XOR_RLX */

#ifndef VATOMIC16_XOR
    #define VATOMIC16_XOR

static inline void
vatomic16_xor(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_xor(a, v);
}

#endif /* VATOMIC16_XOR */

#ifndef VATOMIC16_XOR_REL
    #define VATOMIC16_XOR_REL

static inline void
vatomic16_xor_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_xor_rel(a, v);
}

#endif /* VATOMIC16_XOR_REL */

#ifndef VATOMIC16_XOR_RLX
    #define VATOMIC16_XOR_RLX

static inline void
vatomic16_xor_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_xor_rlx(a, v);
}

#endif /* VATOMIC16_XOR_RLX */

#ifndef VATOMIC32_XOR
    #define VATOMIC32_XOR

static inline void
vatomic32_xor(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_xor(a, v);
}

#endif /* VATOMIC32_XOR */

#ifndef VATOMIC32_XOR_REL
    #define VATOMIC32_XOR_REL

static inline void
vatomic32_xor_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_xor_rel(a, v);
}

#endif /* VATOMIC32_XOR_REL */

#ifndef VATOMIC32_XOR_RLX
    #define VATOMIC32_XOR_RLX

static inline void
vatomic32_xor_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_xor_rlx(a, v);
}

#endif /* VATOMIC32_XOR_RLX */

#ifndef VATOMIC64_XOR
    #define VATOMIC64_XOR

static inline void
vatomic64_xor(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_xor(a, v);
}

#endif /* VATOMIC64_XOR */

#ifndef VATOMIC64_XOR_REL
    #define VATOMIC64_XOR_REL

static inline void
vatomic64_xor_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_xor_rel(a, v);
}

#endif /* VATOMIC64_XOR_REL */

#ifndef VATOMIC64_XOR_RLX
    #define VATOMIC64_XOR_RLX

static inline void
vatomic64_xor_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_xor_rlx(a, v);
}

#endif /* VATOMIC64_XOR_RLX */

#ifndef VATOMICSZ_XOR
    #define VATOMICSZ_XOR

static inline void
vatomicsz_xor(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_xor(a, v);
}

#endif /* VATOMICSZ_XOR */

#ifndef VATOMICSZ_XOR_REL
    #define VATOMICSZ_XOR_REL

static inline void
vatomicsz_xor_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_xor_rel(a, v);
}

#endif /* VATOMICSZ_XOR_REL */

#ifndef VATOMICSZ_XOR_RLX
    #define VATOMICSZ_XOR_RLX

static inline void
vatomicsz_xor_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_xor_rlx(a, v);
}

#endif /* VATOMICSZ_XOR_RLX */

/* *****************************************************************************
 * vatomic_{get_add, add, get_add}
 * ****************************************************************************/

#ifndef VATOMIC8_ADD_GET
    #define VATOMIC8_ADD_GET

static inline vuint8_t
vatomic8_add_get(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_add(a, v) + v;
}

#endif /* VATOMIC8_ADD_GET */

#ifndef VATOMIC8_ADD_GET_ACQ
    #define VATOMIC8_ADD_GET_ACQ

static inline vuint8_t
vatomic8_add_get_acq(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_add_acq(a, v) + v;
}

#endif /* VATOMIC8_ADD_GET_ACQ */

#ifndef VATOMIC8_ADD_GET_REL
    #define VATOMIC8_ADD_GET_REL

static inline vuint8_t
vatomic8_add_get_rel(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_add_rel(a, v) + v;
}

#endif /* VATOMIC8_ADD_GET_REL */

#ifndef VATOMIC8_ADD_GET_RLX
    #define VATOMIC8_ADD_GET_RLX

static inline vuint8_t
vatomic8_add_get_rlx(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_add_rlx(a, v) + v;
}

#endif /* VATOMIC8_ADD_GET_RLX */

#ifndef VATOMIC16_ADD_GET
    #define VATOMIC16_ADD_GET

static inline vuint16_t
vatomic16_add_get(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_add(a, v) + v;
}

#endif /* VATOMIC16_ADD_GET */

#ifndef VATOMIC16_ADD_GET_ACQ
    #define VATOMIC16_ADD_GET_ACQ

static inline vuint16_t
vatomic16_add_get_acq(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_add_acq(a, v) + v;
}

#endif /* VATOMIC16_ADD_GET_ACQ */

#ifndef VATOMIC16_ADD_GET_REL
    #define VATOMIC16_ADD_GET_REL

static inline vuint16_t
vatomic16_add_get_rel(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_add_rel(a, v) + v;
}

#endif /* VATOMIC16_ADD_GET_REL */

#ifndef VATOMIC16_ADD_GET_RLX
    #define VATOMIC16_ADD_GET_RLX

static inline vuint16_t
vatomic16_add_get_rlx(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_add_rlx(a, v) + v;
}

#endif /* VATOMIC16_ADD_GET_RLX */

#ifndef VATOMIC32_ADD_GET
    #define VATOMIC32_ADD_GET

static inline vuint32_t
vatomic32_add_get(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_add(a, v) + v;
}

#endif /* VATOMIC32_ADD_GET */

#ifndef VATOMIC32_ADD_GET_ACQ
    #define VATOMIC32_ADD_GET_ACQ

static inline vuint32_t
vatomic32_add_get_acq(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_add_acq(a, v) + v;
}

#endif /* VATOMIC32_ADD_GET_ACQ */

#ifndef VATOMIC32_ADD_GET_REL
    #define VATOMIC32_ADD_GET_REL

static inline vuint32_t
vatomic32_add_get_rel(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_add_rel(a, v) + v;
}

#endif /* VATOMIC32_ADD_GET_REL */

#ifndef VATOMIC32_ADD_GET_RLX
    #define VATOMIC32_ADD_GET_RLX

static inline vuint32_t
vatomic32_add_get_rlx(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_add_rlx(a, v) + v;
}

#endif /* VATOMIC32_ADD_GET_RLX */

#ifndef VATOMIC64_ADD_GET
    #define VATOMIC64_ADD_GET

static inline vuint64_t
vatomic64_add_get(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_add(a, v) + v;
}

#endif /* VATOMIC64_ADD_GET */

#ifndef VATOMIC64_ADD_GET_ACQ
    #define VATOMIC64_ADD_GET_ACQ

static inline vuint64_t
vatomic64_add_get_acq(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_add_acq(a, v) + v;
}

#endif /* VATOMIC64_ADD_GET_ACQ */

#ifndef VATOMIC64_ADD_GET_REL
    #define VATOMIC64_ADD_GET_REL

static inline vuint64_t
vatomic64_add_get_rel(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_add_rel(a, v) + v;
}

#endif /* VATOMIC64_ADD_GET_REL */

#ifndef VATOMIC64_ADD_GET_RLX
    #define VATOMIC64_ADD_GET_RLX

static inline vuint64_t
vatomic64_add_get_rlx(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_add_rlx(a, v) + v;
}

#endif /* VATOMIC64_ADD_GET_RLX */

#ifndef VATOMICSZ_ADD_GET
    #define VATOMICSZ_ADD_GET

static inline vsize_t
vatomicsz_add_get(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_add(a, v) + v;
}

#endif /* VATOMICSZ_ADD_GET */

#ifndef VATOMICSZ_ADD_GET_ACQ
    #define VATOMICSZ_ADD_GET_ACQ

static inline vsize_t
vatomicsz_add_get_acq(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_add_acq(a, v) + v;
}

#endif /* VATOMICSZ_ADD_GET_ACQ */

#ifndef VATOMICSZ_ADD_GET_REL
    #define VATOMICSZ_ADD_GET_REL

static inline vsize_t
vatomicsz_add_get_rel(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_add_rel(a, v) + v;
}

#endif /* VATOMICSZ_ADD_GET_REL */

#ifndef VATOMICSZ_ADD_GET_RLX
    #define VATOMICSZ_ADD_GET_RLX

static inline vsize_t
vatomicsz_add_get_rlx(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_add_rlx(a, v) + v;
}

#endif /* VATOMICSZ_ADD_GET_RLX */

#ifndef VATOMIC8_ADD
    #define VATOMIC8_ADD

static inline void
vatomic8_add(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_add(a, v);
}

#endif /* VATOMIC8_ADD */

#ifndef VATOMIC8_ADD_REL
    #define VATOMIC8_ADD_REL

static inline void
vatomic8_add_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_add_rel(a, v);
}

#endif /* VATOMIC8_ADD_REL */

#ifndef VATOMIC8_ADD_RLX
    #define VATOMIC8_ADD_RLX

static inline void
vatomic8_add_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_add_rlx(a, v);
}

#endif /* VATOMIC8_ADD_RLX */

#ifndef VATOMIC16_ADD
    #define VATOMIC16_ADD

static inline void
vatomic16_add(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_add(a, v);
}

#endif /* VATOMIC16_ADD */

#ifndef VATOMIC16_ADD_REL
    #define VATOMIC16_ADD_REL

static inline void
vatomic16_add_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_add_rel(a, v);
}

#endif /* VATOMIC16_ADD_REL */

#ifndef VATOMIC16_ADD_RLX
    #define VATOMIC16_ADD_RLX

static inline void
vatomic16_add_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_add_rlx(a, v);
}

#endif /* VATOMIC16_ADD_RLX */

#ifndef VATOMIC32_ADD
    #define VATOMIC32_ADD

static inline void
vatomic32_add(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_add(a, v);
}

#endif /* VATOMIC32_ADD */

#ifndef VATOMIC32_ADD_REL
    #define VATOMIC32_ADD_REL

static inline void
vatomic32_add_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_add_rel(a, v);
}

#endif /* VATOMIC32_ADD_REL */

#ifndef VATOMIC32_ADD_RLX
    #define VATOMIC32_ADD_RLX

static inline void
vatomic32_add_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_add_rlx(a, v);
}

#endif /* VATOMIC32_ADD_RLX */

#ifndef VATOMIC64_ADD
    #define VATOMIC64_ADD

static inline void
vatomic64_add(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_add(a, v);
}

#endif /* VATOMIC64_ADD */

#ifndef VATOMIC64_ADD_REL
    #define VATOMIC64_ADD_REL

static inline void
vatomic64_add_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_add_rel(a, v);
}

#endif /* VATOMIC64_ADD_REL */

#ifndef VATOMIC64_ADD_RLX
    #define VATOMIC64_ADD_RLX

static inline void
vatomic64_add_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_add_rlx(a, v);
}

#endif /* VATOMIC64_ADD_RLX */

#ifndef VATOMICSZ_ADD
    #define VATOMICSZ_ADD

static inline void
vatomicsz_add(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_add(a, v);
}

#endif /* VATOMICSZ_ADD */

#ifndef VATOMICSZ_ADD_REL
    #define VATOMICSZ_ADD_REL

static inline void
vatomicsz_add_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_add_rel(a, v);
}

#endif /* VATOMICSZ_ADD_REL */

#ifndef VATOMICSZ_ADD_RLX
    #define VATOMICSZ_ADD_RLX

static inline void
vatomicsz_add_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_add_rlx(a, v);
}

#endif /* VATOMICSZ_ADD_RLX */

/* *****************************************************************************
 * vatomic_{get_inc, inc, inc_get}
 * ****************************************************************************/

#ifndef VATOMIC8_GET_INC
    #define VATOMIC8_GET_INC

static inline vuint8_t
vatomic8_get_inc(vatomic8_t *a)
{
    return vatomic8_get_add(a, 1U);
}

#endif /* VATOMIC8_GET_INC */

#ifndef VATOMIC8_GET_INC_ACQ
    #define VATOMIC8_GET_INC_ACQ

static inline vuint8_t
vatomic8_get_inc_acq(vatomic8_t *a)
{
    return vatomic8_get_add_acq(a, 1U);
}

#endif /* VATOMIC8_GET_INC_ACQ */

#ifndef VATOMIC8_GET_INC_REL
    #define VATOMIC8_GET_INC_REL

static inline vuint8_t
vatomic8_get_inc_rel(vatomic8_t *a)
{
    return vatomic8_get_add_rel(a, 1U);
}

#endif /* VATOMIC8_GET_INC_REL */

#ifndef VATOMIC8_GET_INC_RLX
    #define VATOMIC8_GET_INC_RLX

static inline vuint8_t
vatomic8_get_inc_rlx(vatomic8_t *a)
{
    return vatomic8_get_add_rlx(a, 1U);
}

#endif /* VATOMIC8_GET_INC_RLX */

#ifndef VATOMIC16_GET_INC
    #define VATOMIC16_GET_INC

static inline vuint16_t
vatomic16_get_inc(vatomic16_t *a)
{
    return vatomic16_get_add(a, 1U);
}

#endif /* VATOMIC16_GET_INC */

#ifndef VATOMIC16_GET_INC_ACQ
    #define VATOMIC16_GET_INC_ACQ

static inline vuint16_t
vatomic16_get_inc_acq(vatomic16_t *a)
{
    return vatomic16_get_add_acq(a, 1U);
}

#endif /* VATOMIC16_GET_INC_ACQ */

#ifndef VATOMIC16_GET_INC_REL
    #define VATOMIC16_GET_INC_REL

static inline vuint16_t
vatomic16_get_inc_rel(vatomic16_t *a)
{
    return vatomic16_get_add_rel(a, 1U);
}

#endif /* VATOMIC16_GET_INC_REL */

#ifndef VATOMIC16_GET_INC_RLX
    #define VATOMIC16_GET_INC_RLX

static inline vuint16_t
vatomic16_get_inc_rlx(vatomic16_t *a)
{
    return vatomic16_get_add_rlx(a, 1U);
}

#endif /* VATOMIC16_GET_INC_RLX */

#ifndef VATOMIC32_GET_INC
    #define VATOMIC32_GET_INC

static inline vuint32_t
vatomic32_get_inc(vatomic32_t *a)
{
    return vatomic32_get_add(a, 1U);
}

#endif /* VATOMIC32_GET_INC */

#ifndef VATOMIC32_GET_INC_ACQ
    #define VATOMIC32_GET_INC_ACQ

static inline vuint32_t
vatomic32_get_inc_acq(vatomic32_t *a)
{
    return vatomic32_get_add_acq(a, 1U);
}

#endif /* VATOMIC32_GET_INC_ACQ */

#ifndef VATOMIC32_GET_INC_REL
    #define VATOMIC32_GET_INC_REL

static inline vuint32_t
vatomic32_get_inc_rel(vatomic32_t *a)
{
    return vatomic32_get_add_rel(a, 1U);
}

#endif /* VATOMIC32_GET_INC_REL */

#ifndef VATOMIC32_GET_INC_RLX
    #define VATOMIC32_GET_INC_RLX

static inline vuint32_t
vatomic32_get_inc_rlx(vatomic32_t *a)
{
    return vatomic32_get_add_rlx(a, 1U);
}

#endif /* VATOMIC32_GET_INC_RLX */

#ifndef VATOMIC64_GET_INC
    #define VATOMIC64_GET_INC

static inline vuint64_t
vatomic64_get_inc(vatomic64_t *a)
{
    return vatomic64_get_add(a, 1U);
}

#endif /* VATOMIC64_GET_INC */

#ifndef VATOMIC64_GET_INC_ACQ
    #define VATOMIC64_GET_INC_ACQ

static inline vuint64_t
vatomic64_get_inc_acq(vatomic64_t *a)
{
    return vatomic64_get_add_acq(a, 1U);
}

#endif /* VATOMIC64_GET_INC_ACQ */

#ifndef VATOMIC64_GET_INC_REL
    #define VATOMIC64_GET_INC_REL

static inline vuint64_t
vatomic64_get_inc_rel(vatomic64_t *a)
{
    return vatomic64_get_add_rel(a, 1U);
}

#endif /* VATOMIC64_GET_INC_REL */

#ifndef VATOMIC64_GET_INC_RLX
    #define VATOMIC64_GET_INC_RLX

static inline vuint64_t
vatomic64_get_inc_rlx(vatomic64_t *a)
{
    return vatomic64_get_add_rlx(a, 1U);
}

#endif /* VATOMIC64_GET_INC_RLX */

#ifndef VATOMICSZ_GET_INC
    #define VATOMICSZ_GET_INC

static inline vsize_t
vatomicsz_get_inc(vatomicsz_t *a)
{
    return vatomicsz_get_add(a, 1U);
}

#endif /* VATOMICSZ_GET_INC */

#ifndef VATOMICSZ_GET_INC_ACQ
    #define VATOMICSZ_GET_INC_ACQ

static inline vsize_t
vatomicsz_get_inc_acq(vatomicsz_t *a)
{
    return vatomicsz_get_add_acq(a, 1U);
}

#endif /* VATOMICSZ_GET_INC_ACQ */

#ifndef VATOMICSZ_GET_INC_REL
    #define VATOMICSZ_GET_INC_REL

static inline vsize_t
vatomicsz_get_inc_rel(vatomicsz_t *a)
{
    return vatomicsz_get_add_rel(a, 1U);
}

#endif /* VATOMICSZ_GET_INC_REL */

#ifndef VATOMICSZ_GET_INC_RLX
    #define VATOMICSZ_GET_INC_RLX

static inline vsize_t
vatomicsz_get_inc_rlx(vatomicsz_t *a)
{
    return vatomicsz_get_add_rlx(a, 1U);
}

#endif /* VATOMICSZ_GET_INC_RLX */

#ifndef VATOMIC8_INC_GET
    #define VATOMIC8_INC_GET

static inline vuint8_t
vatomic8_inc_get(vatomic8_t *a)
{
    return vatomic8_add_get(a, 1U);
}

#endif /* VATOMIC8_INC_GET */

#ifndef VATOMIC8_INC_GET_ACQ
    #define VATOMIC8_INC_GET_ACQ

static inline vuint8_t
vatomic8_inc_get_acq(vatomic8_t *a)
{
    return vatomic8_add_get_acq(a, 1U);
}

#endif /* VATOMIC8_INC_GET_ACQ */

#ifndef VATOMIC8_INC_GET_REL
    #define VATOMIC8_INC_GET_REL

static inline vuint8_t
vatomic8_inc_get_rel(vatomic8_t *a)
{
    return vatomic8_add_get_rel(a, 1U);
}

#endif /* VATOMIC8_INC_GET_REL */

#ifndef VATOMIC8_INC_GET_RLX
    #define VATOMIC8_INC_GET_RLX

static inline vuint8_t
vatomic8_inc_get_rlx(vatomic8_t *a)
{
    return vatomic8_add_get_rlx(a, 1U);
}

#endif /* VATOMIC8_INC_GET_RLX */

#ifndef VATOMIC16_INC_GET
    #define VATOMIC16_INC_GET

static inline vuint16_t
vatomic16_inc_get(vatomic16_t *a)
{
    return vatomic16_add_get(a, 1U);
}

#endif /* VATOMIC16_INC_GET */

#ifndef VATOMIC16_INC_GET_ACQ
    #define VATOMIC16_INC_GET_ACQ

static inline vuint16_t
vatomic16_inc_get_acq(vatomic16_t *a)
{
    return vatomic16_add_get_acq(a, 1U);
}

#endif /* VATOMIC16_INC_GET_ACQ */

#ifndef VATOMIC16_INC_GET_REL
    #define VATOMIC16_INC_GET_REL

static inline vuint16_t
vatomic16_inc_get_rel(vatomic16_t *a)
{
    return vatomic16_add_get_rel(a, 1U);
}

#endif /* VATOMIC16_INC_GET_REL */

#ifndef VATOMIC16_INC_GET_RLX
    #define VATOMIC16_INC_GET_RLX

static inline vuint16_t
vatomic16_inc_get_rlx(vatomic16_t *a)
{
    return vatomic16_add_get_rlx(a, 1U);
}

#endif /* VATOMIC16_INC_GET_RLX */

#ifndef VATOMIC32_INC_GET
    #define VATOMIC32_INC_GET

static inline vuint32_t
vatomic32_inc_get(vatomic32_t *a)
{
    return vatomic32_add_get(a, 1U);
}

#endif /* VATOMIC32_INC_GET */

#ifndef VATOMIC32_INC_GET_ACQ
    #define VATOMIC32_INC_GET_ACQ

static inline vuint32_t
vatomic32_inc_get_acq(vatomic32_t *a)
{
    return vatomic32_add_get_acq(a, 1U);
}

#endif /* VATOMIC32_INC_GET_ACQ */

#ifndef VATOMIC32_INC_GET_REL
    #define VATOMIC32_INC_GET_REL

static inline vuint32_t
vatomic32_inc_get_rel(vatomic32_t *a)
{
    return vatomic32_add_get_rel(a, 1U);
}

#endif /* VATOMIC32_INC_GET_REL */

#ifndef VATOMIC32_INC_GET_RLX
    #define VATOMIC32_INC_GET_RLX

static inline vuint32_t
vatomic32_inc_get_rlx(vatomic32_t *a)
{
    return vatomic32_add_get_rlx(a, 1U);
}

#endif /* VATOMIC32_INC_GET_RLX */

#ifndef VATOMIC64_INC_GET
    #define VATOMIC64_INC_GET

static inline vuint64_t
vatomic64_inc_get(vatomic64_t *a)
{
    return vatomic64_add_get(a, 1U);
}

#endif /* VATOMIC64_INC_GET */

#ifndef VATOMIC64_INC_GET_ACQ
    #define VATOMIC64_INC_GET_ACQ

static inline vuint64_t
vatomic64_inc_get_acq(vatomic64_t *a)
{
    return vatomic64_add_get_acq(a, 1U);
}

#endif /* VATOMIC64_INC_GET_ACQ */

#ifndef VATOMIC64_INC_GET_REL
    #define VATOMIC64_INC_GET_REL

static inline vuint64_t
vatomic64_inc_get_rel(vatomic64_t *a)
{
    return vatomic64_add_get_rel(a, 1U);
}

#endif /* VATOMIC64_INC_GET_REL */

#ifndef VATOMIC64_INC_GET_RLX
    #define VATOMIC64_INC_GET_RLX

static inline vuint64_t
vatomic64_inc_get_rlx(vatomic64_t *a)
{
    return vatomic64_add_get_rlx(a, 1U);
}

#endif /* VATOMIC64_INC_GET_RLX */

#ifndef VATOMICSZ_INC_GET
    #define VATOMICSZ_INC_GET

static inline vsize_t
vatomicsz_inc_get(vatomicsz_t *a)
{
    return vatomicsz_add_get(a, 1U);
}

#endif /* VATOMICSZ_INC_GET */

#ifndef VATOMICSZ_INC_GET_ACQ
    #define VATOMICSZ_INC_GET_ACQ

static inline vsize_t
vatomicsz_inc_get_acq(vatomicsz_t *a)
{
    return vatomicsz_add_get_acq(a, 1U);
}

#endif /* VATOMICSZ_INC_GET_ACQ */

#ifndef VATOMICSZ_INC_GET_REL
    #define VATOMICSZ_INC_GET_REL

static inline vsize_t
vatomicsz_inc_get_rel(vatomicsz_t *a)
{
    return vatomicsz_add_get_rel(a, 1U);
}

#endif /* VATOMICSZ_INC_GET_REL */

#ifndef VATOMICSZ_INC_GET_RLX
    #define VATOMICSZ_INC_GET_RLX

static inline vsize_t
vatomicsz_inc_get_rlx(vatomicsz_t *a)
{
    return vatomicsz_add_get_rlx(a, 1U);
}

#endif /* VATOMICSZ_INC_GET_RLX */

#ifndef VATOMIC8_INC
    #define VATOMIC8_INC

static inline void
vatomic8_inc(vatomic8_t *a)
{
    (void)vatomic8_get_inc(a);
}

#endif /* VATOMIC8_INC */

#ifndef VATOMIC8_INC_ACQ
    #define VATOMIC8_INC_ACQ

static inline void
vatomic8_inc_acq(vatomic8_t *a)
{
    (void)vatomic8_get_inc_acq(a);
}

#endif /* VATOMIC8_INC_ACQ */

#ifndef VATOMIC8_INC_REL
    #define VATOMIC8_INC_REL

static inline void
vatomic8_inc_rel(vatomic8_t *a)
{
    (void)vatomic8_get_inc_rel(a);
}

#endif /* VATOMIC8_INC_REL */

#ifndef VATOMIC8_INC_RLX
    #define VATOMIC8_INC_RLX

static inline void
vatomic8_inc_rlx(vatomic8_t *a)
{
    (void)vatomic8_get_inc_rlx(a);
}

#endif /* VATOMIC8_INC_RLX */

#ifndef VATOMIC16_INC
    #define VATOMIC16_INC

static inline void
vatomic16_inc(vatomic16_t *a)
{
    (void)vatomic16_get_inc(a);
}

#endif /* VATOMIC16_INC */

#ifndef VATOMIC16_INC_ACQ
    #define VATOMIC16_INC_ACQ

static inline void
vatomic16_inc_acq(vatomic16_t *a)
{
    (void)vatomic16_get_inc_acq(a);
}

#endif /* VATOMIC16_INC_ACQ */

#ifndef VATOMIC16_INC_REL
    #define VATOMIC16_INC_REL

static inline void
vatomic16_inc_rel(vatomic16_t *a)
{
    (void)vatomic16_get_inc_rel(a);
}

#endif /* VATOMIC16_INC_REL */

#ifndef VATOMIC16_INC_RLX
    #define VATOMIC16_INC_RLX

static inline void
vatomic16_inc_rlx(vatomic16_t *a)
{
    (void)vatomic16_get_inc_rlx(a);
}

#endif /* VATOMIC16_INC_RLX */

#ifndef VATOMIC32_INC
    #define VATOMIC32_INC

static inline void
vatomic32_inc(vatomic32_t *a)
{
    (void)vatomic32_get_inc(a);
}

#endif /* VATOMIC32_INC */

#ifndef VATOMIC32_INC_ACQ
    #define VATOMIC32_INC_ACQ

static inline void
vatomic32_inc_acq(vatomic32_t *a)
{
    (void)vatomic32_get_inc_acq(a);
}

#endif /* VATOMIC32_INC_ACQ */

#ifndef VATOMIC32_INC_REL
    #define VATOMIC32_INC_REL

static inline void
vatomic32_inc_rel(vatomic32_t *a)
{
    (void)vatomic32_get_inc_rel(a);
}

#endif /* VATOMIC32_INC_REL */

#ifndef VATOMIC32_INC_RLX
    #define VATOMIC32_INC_RLX

static inline void
vatomic32_inc_rlx(vatomic32_t *a)
{
    (void)vatomic32_get_inc_rlx(a);
}

#endif /* VATOMIC32_INC_RLX */

#ifndef VATOMIC64_INC
    #define VATOMIC64_INC

static inline void
vatomic64_inc(vatomic64_t *a)
{
    (void)vatomic64_get_inc(a);
}

#endif /* VATOMIC64_INC */

#ifndef VATOMIC64_INC_ACQ
    #define VATOMIC64_INC_ACQ

static inline void
vatomic64_inc_acq(vatomic64_t *a)
{
    (void)vatomic64_get_inc_acq(a);
}

#endif /* VATOMIC64_INC_ACQ */

#ifndef VATOMIC64_INC_REL
    #define VATOMIC64_INC_REL

static inline void
vatomic64_inc_rel(vatomic64_t *a)
{
    (void)vatomic64_get_inc_rel(a);
}

#endif /* VATOMIC64_INC_REL */

#ifndef VATOMIC64_INC_RLX
    #define VATOMIC64_INC_RLX

static inline void
vatomic64_inc_rlx(vatomic64_t *a)
{
    (void)vatomic64_get_inc_rlx(a);
}

#endif /* VATOMIC64_INC_RLX */

#ifndef VATOMICSZ_INC
    #define VATOMICSZ_INC

static inline void
vatomicsz_inc(vatomicsz_t *a)
{
    (void)vatomicsz_get_inc(a);
}

#endif /* VATOMICSZ_INC */

#ifndef VATOMICSZ_INC_ACQ
    #define VATOMICSZ_INC_ACQ

static inline void
vatomicsz_inc_acq(vatomicsz_t *a)
{
    (void)vatomicsz_get_inc_acq(a);
}

#endif /* VATOMICSZ_INC_ACQ */

#ifndef VATOMICSZ_INC_REL
    #define VATOMICSZ_INC_REL

static inline void
vatomicsz_inc_rel(vatomicsz_t *a)
{
    (void)vatomicsz_get_inc_rel(a);
}

#endif /* VATOMICSZ_INC_REL */

#ifndef VATOMICSZ_INC_RLX
    #define VATOMICSZ_INC_RLX

static inline void
vatomicsz_inc_rlx(vatomicsz_t *a)
{
    (void)vatomicsz_get_inc_rlx(a);
}

#endif /* VATOMICSZ_INC_RLX */

/* *****************************************************************************
 * vatomic_{get_sub, sub, sub_get}
 * ****************************************************************************/

#ifndef VATOMIC8_SUB_GET
    #define VATOMIC8_SUB_GET

static inline vuint8_t
vatomic8_sub_get(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_sub(a, v) - v;
}

#endif /* VATOMIC8_SUB_GET */

#ifndef VATOMIC8_SUB_GET_ACQ
    #define VATOMIC8_SUB_GET_ACQ

static inline vuint8_t
vatomic8_sub_get_acq(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_sub_acq(a, v) - v;
}

#endif /* VATOMIC8_SUB_GET_ACQ */

#ifndef VATOMIC8_SUB_GET_REL
    #define VATOMIC8_SUB_GET_REL

static inline vuint8_t
vatomic8_sub_get_rel(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_sub_rel(a, v) - v;
}

#endif /* VATOMIC8_SUB_GET_REL */

#ifndef VATOMIC8_SUB_GET_RLX
    #define VATOMIC8_SUB_GET_RLX

static inline vuint8_t
vatomic8_sub_get_rlx(vatomic8_t *a, vuint8_t v)
{
    return vatomic8_get_sub_rlx(a, v) - v;
}

#endif /* VATOMIC8_SUB_GET_RLX */

#ifndef VATOMIC16_SUB_GET
    #define VATOMIC16_SUB_GET

static inline vuint16_t
vatomic16_sub_get(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_sub(a, v) - v;
}

#endif /* VATOMIC16_SUB_GET */

#ifndef VATOMIC16_SUB_GET_ACQ
    #define VATOMIC16_SUB_GET_ACQ

static inline vuint16_t
vatomic16_sub_get_acq(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_sub_acq(a, v) - v;
}

#endif /* VATOMIC16_SUB_GET_ACQ */

#ifndef VATOMIC16_SUB_GET_REL
    #define VATOMIC16_SUB_GET_REL

static inline vuint16_t
vatomic16_sub_get_rel(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_sub_rel(a, v) - v;
}

#endif /* VATOMIC16_SUB_GET_REL */

#ifndef VATOMIC16_SUB_GET_RLX
    #define VATOMIC16_SUB_GET_RLX

static inline vuint16_t
vatomic16_sub_get_rlx(vatomic16_t *a, vuint16_t v)
{
    return vatomic16_get_sub_rlx(a, v) - v;
}

#endif /* VATOMIC16_SUB_GET_RLX */

#ifndef VATOMIC32_SUB_GET
    #define VATOMIC32_SUB_GET

static inline vuint32_t
vatomic32_sub_get(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_sub(a, v) - v;
}

#endif /* VATOMIC32_SUB_GET */

#ifndef VATOMIC32_SUB_GET_ACQ
    #define VATOMIC32_SUB_GET_ACQ

static inline vuint32_t
vatomic32_sub_get_acq(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_sub_acq(a, v) - v;
}

#endif /* VATOMIC32_SUB_GET_ACQ */

#ifndef VATOMIC32_SUB_GET_REL
    #define VATOMIC32_SUB_GET_REL

static inline vuint32_t
vatomic32_sub_get_rel(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_sub_rel(a, v) - v;
}

#endif /* VATOMIC32_SUB_GET_REL */

#ifndef VATOMIC32_SUB_GET_RLX
    #define VATOMIC32_SUB_GET_RLX

static inline vuint32_t
vatomic32_sub_get_rlx(vatomic32_t *a, vuint32_t v)
{
    return vatomic32_get_sub_rlx(a, v) - v;
}

#endif /* VATOMIC32_SUB_GET_RLX */

#ifndef VATOMIC64_SUB_GET
    #define VATOMIC64_SUB_GET

static inline vuint64_t
vatomic64_sub_get(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_sub(a, v) - v;
}

#endif /* VATOMIC64_SUB_GET */

#ifndef VATOMIC64_SUB_GET_ACQ
    #define VATOMIC64_SUB_GET_ACQ

static inline vuint64_t
vatomic64_sub_get_acq(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_sub_acq(a, v) - v;
}

#endif /* VATOMIC64_SUB_GET_ACQ */

#ifndef VATOMIC64_SUB_GET_REL
    #define VATOMIC64_SUB_GET_REL

static inline vuint64_t
vatomic64_sub_get_rel(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_sub_rel(a, v) - v;
}

#endif /* VATOMIC64_SUB_GET_REL */

#ifndef VATOMIC64_SUB_GET_RLX
    #define VATOMIC64_SUB_GET_RLX

static inline vuint64_t
vatomic64_sub_get_rlx(vatomic64_t *a, vuint64_t v)
{
    return vatomic64_get_sub_rlx(a, v) - v;
}

#endif /* VATOMIC64_SUB_GET_RLX */

#ifndef VATOMICSZ_SUB_GET
    #define VATOMICSZ_SUB_GET

static inline vsize_t
vatomicsz_sub_get(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_sub(a, v) - v;
}

#endif /* VATOMICSZ_SUB_GET */

#ifndef VATOMICSZ_SUB_GET_ACQ
    #define VATOMICSZ_SUB_GET_ACQ

static inline vsize_t
vatomicsz_sub_get_acq(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_sub_acq(a, v) - v;
}

#endif /* VATOMICSZ_SUB_GET_ACQ */

#ifndef VATOMICSZ_SUB_GET_REL
    #define VATOMICSZ_SUB_GET_REL

static inline vsize_t
vatomicsz_sub_get_rel(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_sub_rel(a, v) - v;
}

#endif /* VATOMICSZ_SUB_GET_REL */

#ifndef VATOMICSZ_SUB_GET_RLX
    #define VATOMICSZ_SUB_GET_RLX

static inline vsize_t
vatomicsz_sub_get_rlx(vatomicsz_t *a, vsize_t v)
{
    return vatomicsz_get_sub_rlx(a, v) - v;
}

#endif /* VATOMICSZ_SUB_GET_RLX */

#ifndef VATOMIC8_SUB
    #define VATOMIC8_SUB

static inline void
vatomic8_sub(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_sub(a, v);
}

#endif /* VATOMIC8_SUB */

#ifndef VATOMIC8_SUB_ACQ
    #define VATOMIC8_SUB_ACQ

static inline void
vatomic8_sub_acq(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_sub_acq(a, v);
}

#endif /* VATOMIC8_SUB_ACQ */

#ifndef VATOMIC8_SUB_REL
    #define VATOMIC8_SUB_REL

static inline void
vatomic8_sub_rel(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_sub_rel(a, v);
}

#endif /* VATOMIC8_SUB_REL */

#ifndef VATOMIC8_SUB_RLX
    #define VATOMIC8_SUB_RLX

static inline void
vatomic8_sub_rlx(vatomic8_t *a, vuint8_t v)
{
    (void)vatomic8_get_sub_rlx(a, v);
}

#endif /* VATOMIC8_SUB_RLX */

#ifndef VATOMIC16_SUB
    #define VATOMIC16_SUB

static inline void
vatomic16_sub(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_sub(a, v);
}

#endif /* VATOMIC16_SUB */

#ifndef VATOMIC16_SUB_ACQ
    #define VATOMIC16_SUB_ACQ

static inline void
vatomic16_sub_acq(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_sub_acq(a, v);
}

#endif /* VATOMIC16_SUB_ACQ */

#ifndef VATOMIC16_SUB_REL
    #define VATOMIC16_SUB_REL

static inline void
vatomic16_sub_rel(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_sub_rel(a, v);
}

#endif /* VATOMIC16_SUB_REL */

#ifndef VATOMIC16_SUB_RLX
    #define VATOMIC16_SUB_RLX

static inline void
vatomic16_sub_rlx(vatomic16_t *a, vuint16_t v)
{
    (void)vatomic16_get_sub_rlx(a, v);
}

#endif /* VATOMIC16_SUB_RLX */

#ifndef VATOMIC32_SUB
    #define VATOMIC32_SUB

static inline void
vatomic32_sub(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_sub(a, v);
}

#endif /* VATOMIC32_SUB */

#ifndef VATOMIC32_SUB_ACQ
    #define VATOMIC32_SUB_ACQ

static inline void
vatomic32_sub_acq(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_sub_acq(a, v);
}

#endif /* VATOMIC32_SUB_ACQ */

#ifndef VATOMIC32_SUB_REL
    #define VATOMIC32_SUB_REL

static inline void
vatomic32_sub_rel(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_sub_rel(a, v);
}

#endif /* VATOMIC32_SUB_REL */

#ifndef VATOMIC32_SUB_RLX
    #define VATOMIC32_SUB_RLX

static inline void
vatomic32_sub_rlx(vatomic32_t *a, vuint32_t v)
{
    (void)vatomic32_get_sub_rlx(a, v);
}

#endif /* VATOMIC32_SUB_RLX */

#ifndef VATOMIC64_SUB
    #define VATOMIC64_SUB

static inline void
vatomic64_sub(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_sub(a, v);
}

#endif /* VATOMIC64_SUB */

#ifndef VATOMIC64_SUB_ACQ
    #define VATOMIC64_SUB_ACQ

static inline void
vatomic64_sub_acq(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_sub_acq(a, v);
}

#endif /* VATOMIC64_SUB_ACQ */

#ifndef VATOMIC64_SUB_REL
    #define VATOMIC64_SUB_REL

static inline void
vatomic64_sub_rel(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_sub_rel(a, v);
}

#endif /* VATOMIC64_SUB_REL */

#ifndef VATOMIC64_SUB_RLX
    #define VATOMIC64_SUB_RLX

static inline void
vatomic64_sub_rlx(vatomic64_t *a, vuint64_t v)
{
    (void)vatomic64_get_sub_rlx(a, v);
}

#endif /* VATOMIC64_SUB_RLX */

#ifndef VATOMICSZ_SUB
    #define VATOMICSZ_SUB

static inline void
vatomicsz_sub(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_sub(a, v);
}

#endif /* VATOMICSZ_SUB */

#ifndef VATOMICSZ_SUB_ACQ
    #define VATOMICSZ_SUB_ACQ

static inline void
vatomicsz_sub_acq(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_sub_acq(a, v);
}

#endif /* VATOMICSZ_SUB_ACQ */

#ifndef VATOMICSZ_SUB_REL
    #define VATOMICSZ_SUB_REL

static inline void
vatomicsz_sub_rel(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_sub_rel(a, v);
}

#endif /* VATOMICSZ_SUB_REL */

#ifndef VATOMICSZ_SUB_RLX
    #define VATOMICSZ_SUB_RLX

static inline void
vatomicsz_sub_rlx(vatomicsz_t *a, vsize_t v)
{
    (void)vatomicsz_get_sub_rlx(a, v);
}

#endif /* VATOMICSZ_SUB_RLX */

/* *****************************************************************************
 * vatomic_{get_dec, dec, dec_get}
 * ****************************************************************************/

#ifndef VATOMIC8_GET_DEC
    #define VATOMIC8_GET_DEC

static inline vuint8_t
vatomic8_get_dec(vatomic8_t *a)
{
    return vatomic8_get_sub(a, 1U);
}

#endif /* VATOMIC8_GET_DEC */

#ifndef VATOMIC8_GET_DEC_ACQ
    #define VATOMIC8_GET_DEC_ACQ

static inline vuint8_t
vatomic8_get_dec_acq(vatomic8_t *a)
{
    return vatomic8_get_sub_acq(a, 1U);
}

#endif /* VATOMIC8_GET_DEC_ACQ */

#ifndef VATOMIC8_GET_DEC_REL
    #define VATOMIC8_GET_DEC_REL

static inline vuint8_t
vatomic8_get_dec_rel(vatomic8_t *a)
{
    return vatomic8_get_sub_rel(a, 1U);
}

#endif /* VATOMIC8_GET_DEC_REL */

#ifndef VATOMIC8_GET_DEC_RLX
    #define VATOMIC8_GET_DEC_RLX

static inline vuint8_t
vatomic8_get_dec_rlx(vatomic8_t *a)
{
    return vatomic8_get_sub_rlx(a, 1U);
}

#endif /* VATOMIC8_GET_DEC_RLX */

#ifndef VATOMIC16_GET_DEC
    #define VATOMIC16_GET_DEC

static inline vuint16_t
vatomic16_get_dec(vatomic16_t *a)
{
    return vatomic16_get_sub(a, 1U);
}

#endif /* VATOMIC16_GET_DEC */

#ifndef VATOMIC16_GET_DEC_ACQ
    #define VATOMIC16_GET_DEC_ACQ

static inline vuint16_t
vatomic16_get_dec_acq(vatomic16_t *a)
{
    return vatomic16_get_sub_acq(a, 1U);
}

#endif /* VATOMIC16_GET_DEC_ACQ */

#ifndef VATOMIC16_GET_DEC_REL
    #define VATOMIC16_GET_DEC_REL

static inline vuint16_t
vatomic16_get_dec_rel(vatomic16_t *a)
{
    return vatomic16_get_sub_rel(a, 1U);
}

#endif /* VATOMIC16_GET_DEC_REL */

#ifndef VATOMIC16_GET_DEC_RLX
    #define VATOMIC16_GET_DEC_RLX

static inline vuint16_t
vatomic16_get_dec_rlx(vatomic16_t *a)
{
    return vatomic16_get_sub_rlx(a, 1U);
}

#endif /* VATOMIC16_GET_DEC_RLX */

#ifndef VATOMIC32_GET_DEC
    #define VATOMIC32_GET_DEC

static inline vuint32_t
vatomic32_get_dec(vatomic32_t *a)
{
    return vatomic32_get_sub(a, 1U);
}

#endif /* VATOMIC32_GET_DEC */

#ifndef VATOMIC32_GET_DEC_ACQ
    #define VATOMIC32_GET_DEC_ACQ

static inline vuint32_t
vatomic32_get_dec_acq(vatomic32_t *a)
{
    return vatomic32_get_sub_acq(a, 1U);
}

#endif /* VATOMIC32_GET_DEC_ACQ */

#ifndef VATOMIC32_GET_DEC_REL
    #define VATOMIC32_GET_DEC_REL

static inline vuint32_t
vatomic32_get_dec_rel(vatomic32_t *a)
{
    return vatomic32_get_sub_rel(a, 1U);
}

#endif /* VATOMIC32_GET_DEC_REL */

#ifndef VATOMIC32_GET_DEC_RLX
    #define VATOMIC32_GET_DEC_RLX

static inline vuint32_t
vatomic32_get_dec_rlx(vatomic32_t *a)
{
    return vatomic32_get_sub_rlx(a, 1U);
}

#endif /* VATOMIC32_GET_DEC_RLX */

#ifndef VATOMIC64_GET_DEC
    #define VATOMIC64_GET_DEC

static inline vuint64_t
vatomic64_get_dec(vatomic64_t *a)
{
    return vatomic64_get_sub(a, 1U);
}

#endif /* VATOMIC64_GET_DEC */

#ifndef VATOMIC64_GET_DEC_ACQ
    #define VATOMIC64_GET_DEC_ACQ

static inline vuint64_t
vatomic64_get_dec_acq(vatomic64_t *a)
{
    return vatomic64_get_sub_acq(a, 1U);
}

#endif /* VATOMIC64_GET_DEC_ACQ */

#ifndef VATOMIC64_GET_DEC_REL
    #define VATOMIC64_GET_DEC_REL

static inline vuint64_t
vatomic64_get_dec_rel(vatomic64_t *a)
{
    return vatomic64_get_sub_rel(a, 1U);
}

#endif /* VATOMIC64_GET_DEC_REL */

#ifndef VATOMIC64_GET_DEC_RLX
    #define VATOMIC64_GET_DEC_RLX

static inline vuint64_t
vatomic64_get_dec_rlx(vatomic64_t *a)
{
    return vatomic64_get_sub_rlx(a, 1U);
}

#endif /* VATOMIC64_GET_DEC_RLX */

#ifndef VATOMICSZ_GET_DEC
    #define VATOMICSZ_GET_DEC

static inline vsize_t
vatomicsz_get_dec(vatomicsz_t *a)
{
    return vatomicsz_get_sub(a, 1U);
}

#endif /* VATOMICSZ_GET_DEC */

#ifndef VATOMICSZ_GET_DEC_ACQ
    #define VATOMICSZ_GET_DEC_ACQ

static inline vsize_t
vatomicsz_get_dec_acq(vatomicsz_t *a)
{
    return vatomicsz_get_sub_acq(a, 1U);
}

#endif /* VATOMICSZ_GET_DEC_ACQ */

#ifndef VATOMICSZ_GET_DEC_REL
    #define VATOMICSZ_GET_DEC_REL

static inline vsize_t
vatomicsz_get_dec_rel(vatomicsz_t *a)
{
    return vatomicsz_get_sub_rel(a, 1U);
}

#endif /* VATOMICSZ_GET_DEC_REL */

#ifndef VATOMICSZ_GET_DEC_RLX
    #define VATOMICSZ_GET_DEC_RLX

static inline vsize_t
vatomicsz_get_dec_rlx(vatomicsz_t *a)
{
    return vatomicsz_get_sub_rlx(a, 1U);
}

#endif /* VATOMICSZ_GET_DEC_RLX */

#ifndef VATOMIC8_DEC_GET
    #define VATOMIC8_DEC_GET

static inline vuint8_t
vatomic8_dec_get(vatomic8_t *a)
{
    return vatomic8_sub_get(a, 1U);
}

#endif /* VATOMIC8_DEC_GET */

#ifndef VATOMIC8_DEC_GET_ACQ
    #define VATOMIC8_DEC_GET_ACQ

static inline vuint8_t
vatomic8_dec_get_acq(vatomic8_t *a)
{
    return vatomic8_sub_get_acq(a, 1U);
}

#endif /* VATOMIC8_DEC_GET_ACQ */

#ifndef VATOMIC8_DEC_GET_REL
    #define VATOMIC8_DEC_GET_REL

static inline vuint8_t
vatomic8_dec_get_rel(vatomic8_t *a)
{
    return vatomic8_sub_get_rel(a, 1U);
}

#endif /* VATOMIC8_DEC_GET_REL */

#ifndef VATOMIC8_DEC_GET_RLX
    #define VATOMIC8_DEC_GET_RLX

static inline vuint8_t
vatomic8_dec_get_rlx(vatomic8_t *a)
{
    return vatomic8_sub_get_rlx(a, 1U);
}

#endif /* VATOMIC8_DEC_GET_RLX */

#ifndef VATOMIC16_DEC_GET
    #define VATOMIC16_DEC_GET

static inline vuint16_t
vatomic16_dec_get(vatomic16_t *a)
{
    return vatomic16_sub_get(a, 1U);
}

#endif /* VATOMIC16_DEC_GET */

#ifndef VATOMIC16_DEC_GET_ACQ
    #define VATOMIC16_DEC_GET_ACQ

static inline vuint16_t
vatomic16_dec_get_acq(vatomic16_t *a)
{
    return vatomic16_sub_get_acq(a, 1U);
}

#endif /* VATOMIC16_DEC_GET_ACQ */

#ifndef VATOMIC16_DEC_GET_REL
    #define VATOMIC16_DEC_GET_REL

static inline vuint16_t
vatomic16_dec_get_rel(vatomic16_t *a)
{
    return vatomic16_sub_get_rel(a, 1U);
}

#endif /* VATOMIC16_DEC_GET_REL */

#ifndef VATOMIC16_DEC_GET_RLX
    #define VATOMIC16_DEC_GET_RLX

static inline vuint16_t
vatomic16_dec_get_rlx(vatomic16_t *a)
{
    return vatomic16_sub_get_rlx(a, 1U);
}

#endif /* VATOMIC16_DEC_GET_RLX */

#ifndef VATOMIC32_DEC_GET
    #define VATOMIC32_DEC_GET

static inline vuint32_t
vatomic32_dec_get(vatomic32_t *a)
{
    return vatomic32_sub_get(a, 1U);
}

#endif /* VATOMIC32_DEC_GET */

#ifndef VATOMIC32_DEC_GET_ACQ
    #define VATOMIC32_DEC_GET_ACQ

static inline vuint32_t
vatomic32_dec_get_acq(vatomic32_t *a)
{
    return vatomic32_sub_get_acq(a, 1U);
}

#endif /* VATOMIC32_DEC_GET_ACQ */

#ifndef VATOMIC32_DEC_GET_REL
    #define VATOMIC32_DEC_GET_REL

static inline vuint32_t
vatomic32_dec_get_rel(vatomic32_t *a)
{
    return vatomic32_sub_get_rel(a, 1U);
}

#endif /* VATOMIC32_DEC_GET_REL */

#ifndef VATOMIC32_DEC_GET_RLX
    #define VATOMIC32_DEC_GET_RLX

static inline vuint32_t
vatomic32_dec_get_rlx(vatomic32_t *a)
{
    return vatomic32_sub_get_rlx(a, 1U);
}

#endif /* VATOMIC32_DEC_GET_RLX */

#ifndef VATOMIC64_DEC_GET
    #define VATOMIC64_DEC_GET

static inline vuint64_t
vatomic64_dec_get(vatomic64_t *a)
{
    return vatomic64_sub_get(a, 1U);
}

#endif /* VATOMIC64_DEC_GET */

#ifndef VATOMIC64_DEC_GET_ACQ
    #define VATOMIC64_DEC_GET_ACQ

static inline vuint64_t
vatomic64_dec_get_acq(vatomic64_t *a)
{
    return vatomic64_sub_get_acq(a, 1U);
}

#endif /* VATOMIC64_DEC_GET_ACQ */

#ifndef VATOMIC64_DEC_GET_REL
    #define VATOMIC64_DEC_GET_REL

static inline vuint64_t
vatomic64_dec_get_rel(vatomic64_t *a)
{
    return vatomic64_sub_get_rel(a, 1U);
}

#endif /* VATOMIC64_DEC_GET_REL */

#ifndef VATOMIC64_DEC_GET_RLX
    #define VATOMIC64_DEC_GET_RLX

static inline vuint64_t
vatomic64_dec_get_rlx(vatomic64_t *a)
{
    return vatomic64_sub_get_rlx(a, 1U);
}

#endif /* VATOMIC64_DEC_GET_RLX */

#ifndef VATOMICSZ_DEC_GET
    #define VATOMICSZ_DEC_GET

static inline vsize_t
vatomicsz_dec_get(vatomicsz_t *a)
{
    return vatomicsz_sub_get(a, 1U);
}

#endif /* VATOMICSZ_DEC_GET */

#ifndef VATOMICSZ_DEC_GET_ACQ
    #define VATOMICSZ_DEC_GET_ACQ

static inline vsize_t
vatomicsz_dec_get_acq(vatomicsz_t *a)
{
    return vatomicsz_sub_get_acq(a, 1U);
}

#endif /* VATOMICSZ_DEC_GET_ACQ */

#ifndef VATOMICSZ_DEC_GET_REL
    #define VATOMICSZ_DEC_GET_REL

static inline vsize_t
vatomicsz_dec_get_rel(vatomicsz_t *a)
{
    return vatomicsz_sub_get_rel(a, 1U);
}

#endif /* VATOMICSZ_DEC_GET_REL */

#ifndef VATOMICSZ_DEC_GET_RLX
    #define VATOMICSZ_DEC_GET_RLX

static inline vsize_t
vatomicsz_dec_get_rlx(vatomicsz_t *a)
{
    return vatomicsz_sub_get_rlx(a, 1U);
}

#endif /* VATOMICSZ_DEC_GET_RLX */

#ifndef VATOMIC8_DEC
    #define VATOMIC8_DEC

static inline void
vatomic8_dec(vatomic8_t *a)
{
    (void)vatomic8_get_dec(a);
}

#endif /* VATOMIC8_DEC */

#ifndef VATOMIC8_DEC_ACQ
    #define VATOMIC8_DEC_ACQ

static inline void
vatomic8_dec_acq(vatomic8_t *a)
{
    (void)vatomic8_get_dec_acq(a);
}

#endif /* VATOMIC8_DEC_ACQ */

#ifndef VATOMIC8_DEC_REL
    #define VATOMIC8_DEC_REL

static inline void
vatomic8_dec_rel(vatomic8_t *a)
{
    (void)vatomic8_get_dec_rel(a);
}

#endif /* VATOMIC8_DEC_REL */

#ifndef VATOMIC8_DEC_RLX
    #define VATOMIC8_DEC_RLX

static inline void
vatomic8_dec_rlx(vatomic8_t *a)
{
    (void)vatomic8_get_dec_rlx(a);
}

#endif /* VATOMIC8_DEC_RLX */

#ifndef VATOMIC16_DEC
    #define VATOMIC16_DEC

static inline void
vatomic16_dec(vatomic16_t *a)
{
    (void)vatomic16_get_dec(a);
}

#endif /* VATOMIC16_DEC */

#ifndef VATOMIC16_DEC_ACQ
    #define VATOMIC16_DEC_ACQ

static inline void
vatomic16_dec_acq(vatomic16_t *a)
{
    (void)vatomic16_get_dec_acq(a);
}

#endif /* VATOMIC16_DEC_ACQ */

#ifndef VATOMIC16_DEC_REL
    #define VATOMIC16_DEC_REL

static inline void
vatomic16_dec_rel(vatomic16_t *a)
{
    (void)vatomic16_get_dec_rel(a);
}

#endif /* VATOMIC16_DEC_REL */

#ifndef VATOMIC16_DEC_RLX
    #define VATOMIC16_DEC_RLX

static inline void
vatomic16_dec_rlx(vatomic16_t *a)
{
    (void)vatomic16_get_dec_rlx(a);
}

#endif /* VATOMIC16_DEC_RLX */

#ifndef VATOMIC32_DEC
    #define VATOMIC32_DEC

static inline void
vatomic32_dec(vatomic32_t *a)
{
    (void)vatomic32_get_dec(a);
}

#endif /* VATOMIC32_DEC */

#ifndef VATOMIC32_DEC_ACQ
    #define VATOMIC32_DEC_ACQ

static inline void
vatomic32_dec_acq(vatomic32_t *a)
{
    (void)vatomic32_get_dec_acq(a);
}

#endif /* VATOMIC32_DEC_ACQ */

#ifndef VATOMIC32_DEC_REL
    #define VATOMIC32_DEC_REL

static inline void
vatomic32_dec_rel(vatomic32_t *a)
{
    (void)vatomic32_get_dec_rel(a);
}

#endif /* VATOMIC32_DEC_REL */

#ifndef VATOMIC32_DEC_RLX
    #define VATOMIC32_DEC_RLX

static inline void
vatomic32_dec_rlx(vatomic32_t *a)
{
    (void)vatomic32_get_dec_rlx(a);
}

#endif /* VATOMIC32_DEC_RLX */

#ifndef VATOMIC64_DEC
    #define VATOMIC64_DEC

static inline void
vatomic64_dec(vatomic64_t *a)
{
    (void)vatomic64_get_dec(a);
}

#endif /* VATOMIC64_DEC */

#ifndef VATOMIC64_DEC_ACQ
    #define VATOMIC64_DEC_ACQ

static inline void
vatomic64_dec_acq(vatomic64_t *a)
{
    (void)vatomic64_get_dec_acq(a);
}

#endif /* VATOMIC64_DEC_ACQ */

#ifndef VATOMIC64_DEC_REL
    #define VATOMIC64_DEC_REL

static inline void
vatomic64_dec_rel(vatomic64_t *a)
{
    (void)vatomic64_get_dec_rel(a);
}

#endif /* VATOMIC64_DEC_REL */

#ifndef VATOMIC64_DEC_RLX
    #define VATOMIC64_DEC_RLX

static inline void
vatomic64_dec_rlx(vatomic64_t *a)
{
    (void)vatomic64_get_dec_rlx(a);
}

#endif /* VATOMIC64_DEC_RLX */

#ifndef VATOMICSZ_DEC
    #define VATOMICSZ_DEC

static inline void
vatomicsz_dec(vatomicsz_t *a)
{
    (void)vatomicsz_get_dec(a);
}

#endif /* VATOMICSZ_DEC */

#ifndef VATOMICSZ_DEC_ACQ
    #define VATOMICSZ_DEC_ACQ

static inline void
vatomicsz_dec_acq(vatomicsz_t *a)
{
    (void)vatomicsz_get_dec_acq(a);
}

#endif /* VATOMICSZ_DEC_ACQ */

#ifndef VATOMICSZ_DEC_REL
    #define VATOMICSZ_DEC_REL

static inline void
vatomicsz_dec_rel(vatomicsz_t *a)
{
    (void)vatomicsz_get_dec_rel(a);
}

#endif /* VATOMICSZ_DEC_REL */

#ifndef VATOMICSZ_DEC_RLX
    #define VATOMICSZ_DEC_RLX

static inline void
vatomicsz_dec_rlx(vatomicsz_t *a)
{
    (void)vatomicsz_get_dec_rlx(a);
}

#endif /* VATOMICSZ_DEC_RLX */

/* *****************************************************************************
 * vatomic_init
 * ****************************************************************************/

#ifndef VATOMIC8_INIT
    #define VATOMIC8_INIT

static inline void
vatomic8_init(vatomic8_t *a, vuint8_t v)
{
    vatomic8_write(a, v);
}

#endif /* VATOMIC8_INIT */

#ifndef VATOMIC16_INIT
    #define VATOMIC16_INIT

static inline void
vatomic16_init(vatomic16_t *a, vuint16_t v)
{
    vatomic16_write(a, v);
}

#endif /* VATOMIC16_INIT */

#ifndef VATOMIC32_INIT
    #define VATOMIC32_INIT

static inline void
vatomic32_init(vatomic32_t *a, vuint32_t v)
{
    vatomic32_write(a, v);
}

#endif /* VATOMIC32_INIT */

#ifndef VATOMIC64_INIT
    #define VATOMIC64_INIT

static inline void
vatomic64_init(vatomic64_t *a, vuint64_t v)
{
    vatomic64_write(a, v);
}

#endif /* VATOMIC64_INIT */

#ifndef VATOMICSZ_INIT
    #define VATOMICSZ_INIT

static inline void
vatomicsz_init(vatomicsz_t *a, vsize_t v)
{
    vatomicsz_write(a, v);
}

#endif /* VATOMICSZ_INIT */

#ifndef VATOMICPTR_INIT
    #define VATOMICPTR_INIT

static inline void
vatomicptr_init(vatomicptr_t *a, void *v)
{
    vatomicptr_write(a, v);
}

#endif /* VATOMICPTR_INIT */

/* *****************************************************************************
 * vatomic_await_cond functions
 * ****************************************************************************/

#ifndef VATOMIC32_AWAIT_NEQ
    #define VATOMIC32_AWAIT_NEQ

static inline vuint32_t
vatomic32_await_neq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t cur = 0;
    await_while ((cur = vatomic32_read(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC32_AWAIT_NEQ */

#ifndef VATOMIC32_AWAIT_NEQ_ACQ
    #define VATOMIC32_AWAIT_NEQ_ACQ

static inline vuint32_t
vatomic32_await_neq_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t cur = 0;
    await_while ((cur = vatomic32_read_acq(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC32_AWAIT_NEQ_ACQ */

#ifndef VATOMIC32_AWAIT_NEQ_RLX
    #define VATOMIC32_AWAIT_NEQ_RLX

static inline vuint32_t
vatomic32_await_neq_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t cur = 0;
    await_while ((cur = vatomic32_read_rlx(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC32_AWAIT_NEQ_RLX */

#ifndef VATOMIC64_AWAIT_NEQ
    #define VATOMIC64_AWAIT_NEQ

static inline vuint64_t
vatomic64_await_neq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t cur = 0;
    await_while ((cur = vatomic64_read(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC64_AWAIT_NEQ */

#ifndef VATOMIC64_AWAIT_NEQ_ACQ
    #define VATOMIC64_AWAIT_NEQ_ACQ

static inline vuint64_t
vatomic64_await_neq_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t cur = 0;
    await_while ((cur = vatomic64_read_acq(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC64_AWAIT_NEQ_ACQ */

#ifndef VATOMIC64_AWAIT_NEQ_RLX
    #define VATOMIC64_AWAIT_NEQ_RLX

static inline vuint64_t
vatomic64_await_neq_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t cur = 0;
    await_while ((cur = vatomic64_read_rlx(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMIC64_AWAIT_NEQ_RLX */

#ifndef VATOMICPTR_AWAIT_NEQ
    #define VATOMICPTR_AWAIT_NEQ

static inline void *
vatomicptr_await_neq(const vatomicptr_t *a, void *c)
{
    void *cur = NULL;
    await_while ((cur = vatomicptr_read(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMICPTR_AWAIT_NEQ */

#ifndef VATOMICPTR_AWAIT_NEQ_ACQ
    #define VATOMICPTR_AWAIT_NEQ_ACQ

static inline void *
vatomicptr_await_neq_acq(const vatomicptr_t *a, void *c)
{
    void *cur = NULL;
    await_while ((cur = vatomicptr_read_acq(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMICPTR_AWAIT_NEQ_ACQ */

#ifndef VATOMICPTR_AWAIT_NEQ_RLX
    #define VATOMICPTR_AWAIT_NEQ_RLX

static inline void *
vatomicptr_await_neq_rlx(const vatomicptr_t *a, void *c)
{
    void *cur = NULL;
    await_while ((cur = vatomicptr_read_rlx(a), cur == c)) {
        vatomic_cpu_pause();
    }
    return cur;
}

#endif /* VATOMICPTR_AWAIT_NEQ_RLX */

#ifndef VATOMIC32_AWAIT_EQ
    #define VATOMIC32_AWAIT_EQ

static inline vuint32_t
vatomic32_await_eq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t ret = c;
    vuint32_t o   = 0;
    await_while ((o = vatomic32_read(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC32_AWAIT_EQ */

#ifndef VATOMIC32_AWAIT_EQ_ACQ
    #define VATOMIC32_AWAIT_EQ_ACQ

static inline vuint32_t
vatomic32_await_eq_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t ret = c;
    vuint32_t o   = 0;
    await_while ((o = vatomic32_read_acq(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC32_AWAIT_EQ_ACQ */

#ifndef VATOMIC32_AWAIT_EQ_RLX
    #define VATOMIC32_AWAIT_EQ_RLX

static inline vuint32_t
vatomic32_await_eq_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t ret = c;
    vuint32_t o   = 0;
    await_while ((o = vatomic32_read_rlx(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC32_AWAIT_EQ_RLX */

#ifndef VATOMIC64_AWAIT_EQ
    #define VATOMIC64_AWAIT_EQ

static inline vuint64_t
vatomic64_await_eq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t ret = c;
    vuint64_t o   = 0;
    await_while ((o = vatomic64_read(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC64_AWAIT_EQ */

#ifndef VATOMIC64_AWAIT_EQ_ACQ
    #define VATOMIC64_AWAIT_EQ_ACQ

static inline vuint64_t
vatomic64_await_eq_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t ret = c;
    vuint64_t o   = 0;
    await_while ((o = vatomic64_read_acq(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC64_AWAIT_EQ_ACQ */

#ifndef VATOMIC64_AWAIT_EQ_RLX
    #define VATOMIC64_AWAIT_EQ_RLX

static inline vuint64_t
vatomic64_await_eq_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t ret = c;
    vuint64_t o   = 0;
    await_while ((o = vatomic64_read_rlx(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMIC64_AWAIT_EQ_RLX */

#ifndef VATOMICPTR_AWAIT_EQ
    #define VATOMICPTR_AWAIT_EQ

static inline void *
vatomicptr_await_eq(const vatomicptr_t *a, void *c)
{
    void *ret = c;
    void *o   = NULL;
    await_while ((o = vatomicptr_read(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMICPTR_AWAIT_EQ */

#ifndef VATOMICPTR_AWAIT_EQ_ACQ
    #define VATOMICPTR_AWAIT_EQ_ACQ

static inline void *
vatomicptr_await_eq_acq(const vatomicptr_t *a, void *c)
{
    void *ret = c;
    void *o   = NULL;
    await_while ((o = vatomicptr_read_acq(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMICPTR_AWAIT_EQ_ACQ */

#ifndef VATOMICPTR_AWAIT_EQ_RLX
    #define VATOMICPTR_AWAIT_EQ_RLX

static inline void *
vatomicptr_await_eq_rlx(const vatomicptr_t *a, void *c)
{
    void *ret = c;
    void *o   = NULL;
    await_while ((o = vatomicptr_read_rlx(a)) != c) {
        vatomic_cpu_pause();
        ret = o;
    }
    return ret;
}

#endif /* VATOMICPTR_AWAIT_EQ_RLX */

/* *****************************************************************************
 * vatomic_await_COND functions
 * ****************************************************************************/

#ifndef VATOMIC32_AWAIT_LE
    #define VATOMIC32_AWAIT_LE

static inline vuint32_t
vatomic32_await_le(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read(a);
    while (!(old <= c)) {
        old = vatomic32_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LE */

#ifndef VATOMIC32_AWAIT_LE_ACQ
    #define VATOMIC32_AWAIT_LE_ACQ

static inline vuint32_t
vatomic32_await_le_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_acq(a);
    while (!(old <= c)) {
        old = vatomic32_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_ACQ */

#ifndef VATOMIC32_AWAIT_LE_RLX
    #define VATOMIC32_AWAIT_LE_RLX

static inline vuint32_t
vatomic32_await_le_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_rlx(a);
    while (!(old <= c)) {
        old = vatomic32_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_RLX */

#ifndef VATOMIC32_AWAIT_LT
    #define VATOMIC32_AWAIT_LT

static inline vuint32_t
vatomic32_await_lt(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read(a);
    while (!(old < c)) {
        old = vatomic32_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LT */

#ifndef VATOMIC32_AWAIT_LT_ACQ
    #define VATOMIC32_AWAIT_LT_ACQ

static inline vuint32_t
vatomic32_await_lt_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_acq(a);
    while (!(old < c)) {
        old = vatomic32_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_ACQ */

#ifndef VATOMIC32_AWAIT_LT_RLX
    #define VATOMIC32_AWAIT_LT_RLX

static inline vuint32_t
vatomic32_await_lt_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_rlx(a);
    while (!(old < c)) {
        old = vatomic32_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_RLX */

#ifndef VATOMIC32_AWAIT_GE
    #define VATOMIC32_AWAIT_GE

static inline vuint32_t
vatomic32_await_ge(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read(a);
    while (!(old >= c)) {
        old = vatomic32_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GE */

#ifndef VATOMIC32_AWAIT_GE_ACQ
    #define VATOMIC32_AWAIT_GE_ACQ

static inline vuint32_t
vatomic32_await_ge_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_acq(a);
    while (!(old >= c)) {
        old = vatomic32_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_ACQ */

#ifndef VATOMIC32_AWAIT_GE_RLX
    #define VATOMIC32_AWAIT_GE_RLX

static inline vuint32_t
vatomic32_await_ge_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_rlx(a);
    while (!(old >= c)) {
        old = vatomic32_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_RLX */

#ifndef VATOMIC32_AWAIT_GT
    #define VATOMIC32_AWAIT_GT

static inline vuint32_t
vatomic32_await_gt(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read(a);
    while (!(old > c)) {
        old = vatomic32_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GT */

#ifndef VATOMIC32_AWAIT_GT_ACQ
    #define VATOMIC32_AWAIT_GT_ACQ

static inline vuint32_t
vatomic32_await_gt_acq(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_acq(a);
    while (!(old > c)) {
        old = vatomic32_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_ACQ */

#ifndef VATOMIC32_AWAIT_GT_RLX
    #define VATOMIC32_AWAIT_GT_RLX

static inline vuint32_t
vatomic32_await_gt_rlx(const vatomic32_t *a, vuint32_t c)
{
    vuint32_t old = vatomic32_read_rlx(a);
    while (!(old > c)) {
        old = vatomic32_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_RLX */

#ifndef VATOMIC64_AWAIT_LE
    #define VATOMIC64_AWAIT_LE

static inline vuint64_t
vatomic64_await_le(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read(a);
    while (!(old <= c)) {
        old = vatomic64_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LE */

#ifndef VATOMIC64_AWAIT_LE_ACQ
    #define VATOMIC64_AWAIT_LE_ACQ

static inline vuint64_t
vatomic64_await_le_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_acq(a);
    while (!(old <= c)) {
        old = vatomic64_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_ACQ */

#ifndef VATOMIC64_AWAIT_LE_RLX
    #define VATOMIC64_AWAIT_LE_RLX

static inline vuint64_t
vatomic64_await_le_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_rlx(a);
    while (!(old <= c)) {
        old = vatomic64_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_RLX */

#ifndef VATOMIC64_AWAIT_LT
    #define VATOMIC64_AWAIT_LT

static inline vuint64_t
vatomic64_await_lt(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read(a);
    while (!(old < c)) {
        old = vatomic64_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LT */

#ifndef VATOMIC64_AWAIT_LT_ACQ
    #define VATOMIC64_AWAIT_LT_ACQ

static inline vuint64_t
vatomic64_await_lt_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_acq(a);
    while (!(old < c)) {
        old = vatomic64_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_ACQ */

#ifndef VATOMIC64_AWAIT_LT_RLX
    #define VATOMIC64_AWAIT_LT_RLX

static inline vuint64_t
vatomic64_await_lt_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_rlx(a);
    while (!(old < c)) {
        old = vatomic64_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_RLX */

#ifndef VATOMIC64_AWAIT_GE
    #define VATOMIC64_AWAIT_GE

static inline vuint64_t
vatomic64_await_ge(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read(a);
    while (!(old >= c)) {
        old = vatomic64_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GE */

#ifndef VATOMIC64_AWAIT_GE_ACQ
    #define VATOMIC64_AWAIT_GE_ACQ

static inline vuint64_t
vatomic64_await_ge_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_acq(a);
    while (!(old >= c)) {
        old = vatomic64_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_ACQ */

#ifndef VATOMIC64_AWAIT_GE_RLX
    #define VATOMIC64_AWAIT_GE_RLX

static inline vuint64_t
vatomic64_await_ge_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_rlx(a);
    while (!(old >= c)) {
        old = vatomic64_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_RLX */

#ifndef VATOMIC64_AWAIT_GT
    #define VATOMIC64_AWAIT_GT

static inline vuint64_t
vatomic64_await_gt(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read(a);
    while (!(old > c)) {
        old = vatomic64_await_neq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GT */

#ifndef VATOMIC64_AWAIT_GT_ACQ
    #define VATOMIC64_AWAIT_GT_ACQ

static inline vuint64_t
vatomic64_await_gt_acq(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_acq(a);
    while (!(old > c)) {
        old = vatomic64_await_neq_acq(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_ACQ */

#ifndef VATOMIC64_AWAIT_GT_RLX
    #define VATOMIC64_AWAIT_GT_RLX

static inline vuint64_t
vatomic64_await_gt_rlx(const vatomic64_t *a, vuint64_t c)
{
    vuint64_t old = vatomic64_read_rlx(a);
    while (!(old > c)) {
        old = vatomic64_await_neq_rlx(a, old);
    }
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_RLX */

/* *****************************************************************************
 * vatomic_await_COND_OP functions
 * ****************************************************************************/

#ifndef VATOMIC32_AWAIT_LE_ADD
    #define VATOMIC32_AWAIT_LE_ADD

static inline vuint32_t
vatomic32_await_le_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_ADD */

#ifndef VATOMIC32_AWAIT_LE_ADD_ACQ
    #define VATOMIC32_AWAIT_LE_ADD_ACQ

static inline vuint32_t
vatomic32_await_le_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_LE_ADD_REL
    #define VATOMIC32_AWAIT_LE_ADD_REL

static inline vuint32_t
vatomic32_await_le_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_ADD_REL */

#ifndef VATOMIC32_AWAIT_LE_ADD_RLX
    #define VATOMIC32_AWAIT_LE_ADD_RLX

static inline vuint32_t
vatomic32_await_le_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_ADD_RLX */

#ifndef VATOMIC32_AWAIT_LE_SUB
    #define VATOMIC32_AWAIT_LE_SUB

static inline vuint32_t
vatomic32_await_le_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SUB */

#ifndef VATOMIC32_AWAIT_LE_SUB_ACQ
    #define VATOMIC32_AWAIT_LE_SUB_ACQ

static inline vuint32_t
vatomic32_await_le_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_LE_SUB_REL
    #define VATOMIC32_AWAIT_LE_SUB_REL

static inline vuint32_t
vatomic32_await_le_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SUB_REL */

#ifndef VATOMIC32_AWAIT_LE_SUB_RLX
    #define VATOMIC32_AWAIT_LE_SUB_RLX

static inline vuint32_t
vatomic32_await_le_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SUB_RLX */

#ifndef VATOMIC32_AWAIT_LE_SET
    #define VATOMIC32_AWAIT_LE_SET

static inline vuint32_t
vatomic32_await_le_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SET */

#ifndef VATOMIC32_AWAIT_LE_SET_ACQ
    #define VATOMIC32_AWAIT_LE_SET_ACQ

static inline vuint32_t
vatomic32_await_le_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SET_ACQ */

#ifndef VATOMIC32_AWAIT_LE_SET_REL
    #define VATOMIC32_AWAIT_LE_SET_REL

static inline vuint32_t
vatomic32_await_le_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SET_REL */

#ifndef VATOMIC32_AWAIT_LE_SET_RLX
    #define VATOMIC32_AWAIT_LE_SET_RLX

static inline vuint32_t
vatomic32_await_le_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LE_SET_RLX */

#ifndef VATOMIC32_AWAIT_LT_ADD
    #define VATOMIC32_AWAIT_LT_ADD

static inline vuint32_t
vatomic32_await_lt_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_ADD */

#ifndef VATOMIC32_AWAIT_LT_ADD_ACQ
    #define VATOMIC32_AWAIT_LT_ADD_ACQ

static inline vuint32_t
vatomic32_await_lt_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_LT_ADD_REL
    #define VATOMIC32_AWAIT_LT_ADD_REL

static inline vuint32_t
vatomic32_await_lt_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_ADD_REL */

#ifndef VATOMIC32_AWAIT_LT_ADD_RLX
    #define VATOMIC32_AWAIT_LT_ADD_RLX

static inline vuint32_t
vatomic32_await_lt_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_ADD_RLX */

#ifndef VATOMIC32_AWAIT_LT_SUB
    #define VATOMIC32_AWAIT_LT_SUB

static inline vuint32_t
vatomic32_await_lt_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SUB */

#ifndef VATOMIC32_AWAIT_LT_SUB_ACQ
    #define VATOMIC32_AWAIT_LT_SUB_ACQ

static inline vuint32_t
vatomic32_await_lt_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_LT_SUB_REL
    #define VATOMIC32_AWAIT_LT_SUB_REL

static inline vuint32_t
vatomic32_await_lt_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SUB_REL */

#ifndef VATOMIC32_AWAIT_LT_SUB_RLX
    #define VATOMIC32_AWAIT_LT_SUB_RLX

static inline vuint32_t
vatomic32_await_lt_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SUB_RLX */

#ifndef VATOMIC32_AWAIT_LT_SET
    #define VATOMIC32_AWAIT_LT_SET

static inline vuint32_t
vatomic32_await_lt_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SET */

#ifndef VATOMIC32_AWAIT_LT_SET_ACQ
    #define VATOMIC32_AWAIT_LT_SET_ACQ

static inline vuint32_t
vatomic32_await_lt_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SET_ACQ */

#ifndef VATOMIC32_AWAIT_LT_SET_REL
    #define VATOMIC32_AWAIT_LT_SET_REL

static inline vuint32_t
vatomic32_await_lt_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SET_REL */

#ifndef VATOMIC32_AWAIT_LT_SET_RLX
    #define VATOMIC32_AWAIT_LT_SET_RLX

static inline vuint32_t
vatomic32_await_lt_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_LT_SET_RLX */

#ifndef VATOMIC32_AWAIT_GE_ADD
    #define VATOMIC32_AWAIT_GE_ADD

static inline vuint32_t
vatomic32_await_ge_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_ADD */

#ifndef VATOMIC32_AWAIT_GE_ADD_ACQ
    #define VATOMIC32_AWAIT_GE_ADD_ACQ

static inline vuint32_t
vatomic32_await_ge_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_GE_ADD_REL
    #define VATOMIC32_AWAIT_GE_ADD_REL

static inline vuint32_t
vatomic32_await_ge_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_ADD_REL */

#ifndef VATOMIC32_AWAIT_GE_ADD_RLX
    #define VATOMIC32_AWAIT_GE_ADD_RLX

static inline vuint32_t
vatomic32_await_ge_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_ADD_RLX */

#ifndef VATOMIC32_AWAIT_GE_SUB
    #define VATOMIC32_AWAIT_GE_SUB

static inline vuint32_t
vatomic32_await_ge_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SUB */

#ifndef VATOMIC32_AWAIT_GE_SUB_ACQ
    #define VATOMIC32_AWAIT_GE_SUB_ACQ

static inline vuint32_t
vatomic32_await_ge_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_GE_SUB_REL
    #define VATOMIC32_AWAIT_GE_SUB_REL

static inline vuint32_t
vatomic32_await_ge_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SUB_REL */

#ifndef VATOMIC32_AWAIT_GE_SUB_RLX
    #define VATOMIC32_AWAIT_GE_SUB_RLX

static inline vuint32_t
vatomic32_await_ge_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SUB_RLX */

#ifndef VATOMIC32_AWAIT_GE_SET
    #define VATOMIC32_AWAIT_GE_SET

static inline vuint32_t
vatomic32_await_ge_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SET */

#ifndef VATOMIC32_AWAIT_GE_SET_ACQ
    #define VATOMIC32_AWAIT_GE_SET_ACQ

static inline vuint32_t
vatomic32_await_ge_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SET_ACQ */

#ifndef VATOMIC32_AWAIT_GE_SET_REL
    #define VATOMIC32_AWAIT_GE_SET_REL

static inline vuint32_t
vatomic32_await_ge_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SET_REL */

#ifndef VATOMIC32_AWAIT_GE_SET_RLX
    #define VATOMIC32_AWAIT_GE_SET_RLX

static inline vuint32_t
vatomic32_await_ge_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GE_SET_RLX */

#ifndef VATOMIC32_AWAIT_GT_ADD
    #define VATOMIC32_AWAIT_GT_ADD

static inline vuint32_t
vatomic32_await_gt_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_ADD */

#ifndef VATOMIC32_AWAIT_GT_ADD_ACQ
    #define VATOMIC32_AWAIT_GT_ADD_ACQ

static inline vuint32_t
vatomic32_await_gt_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_GT_ADD_REL
    #define VATOMIC32_AWAIT_GT_ADD_REL

static inline vuint32_t
vatomic32_await_gt_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_ADD_REL */

#ifndef VATOMIC32_AWAIT_GT_ADD_RLX
    #define VATOMIC32_AWAIT_GT_ADD_RLX

static inline vuint32_t
vatomic32_await_gt_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_ADD_RLX */

#ifndef VATOMIC32_AWAIT_GT_SUB
    #define VATOMIC32_AWAIT_GT_SUB

static inline vuint32_t
vatomic32_await_gt_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SUB */

#ifndef VATOMIC32_AWAIT_GT_SUB_ACQ
    #define VATOMIC32_AWAIT_GT_SUB_ACQ

static inline vuint32_t
vatomic32_await_gt_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_GT_SUB_REL
    #define VATOMIC32_AWAIT_GT_SUB_REL

static inline vuint32_t
vatomic32_await_gt_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SUB_REL */

#ifndef VATOMIC32_AWAIT_GT_SUB_RLX
    #define VATOMIC32_AWAIT_GT_SUB_RLX

static inline vuint32_t
vatomic32_await_gt_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SUB_RLX */

#ifndef VATOMIC32_AWAIT_GT_SET
    #define VATOMIC32_AWAIT_GT_SET

static inline vuint32_t
vatomic32_await_gt_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq(a, cur);
        }
    } while ((old = vatomic32_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SET */

#ifndef VATOMIC32_AWAIT_GT_SET_ACQ
    #define VATOMIC32_AWAIT_GT_SET_ACQ

static inline vuint32_t
vatomic32_await_gt_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SET_ACQ */

#ifndef VATOMIC32_AWAIT_GT_SET_REL
    #define VATOMIC32_AWAIT_GT_SET_REL

static inline vuint32_t
vatomic32_await_gt_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SET_REL */

#ifndef VATOMIC32_AWAIT_GT_SET_RLX
    #define VATOMIC32_AWAIT_GT_SET_RLX

static inline vuint32_t
vatomic32_await_gt_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t cur = 0;
    vuint32_t old = vatomic32_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic32_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic32_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC32_AWAIT_GT_SET_RLX */

#ifndef VATOMIC64_AWAIT_LE_ADD
    #define VATOMIC64_AWAIT_LE_ADD

static inline vuint64_t
vatomic64_await_le_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_ADD */

#ifndef VATOMIC64_AWAIT_LE_ADD_ACQ
    #define VATOMIC64_AWAIT_LE_ADD_ACQ

static inline vuint64_t
vatomic64_await_le_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_LE_ADD_REL
    #define VATOMIC64_AWAIT_LE_ADD_REL

static inline vuint64_t
vatomic64_await_le_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_ADD_REL */

#ifndef VATOMIC64_AWAIT_LE_ADD_RLX
    #define VATOMIC64_AWAIT_LE_ADD_RLX

static inline vuint64_t
vatomic64_await_le_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_ADD_RLX */

#ifndef VATOMIC64_AWAIT_LE_SUB
    #define VATOMIC64_AWAIT_LE_SUB

static inline vuint64_t
vatomic64_await_le_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SUB */

#ifndef VATOMIC64_AWAIT_LE_SUB_ACQ
    #define VATOMIC64_AWAIT_LE_SUB_ACQ

static inline vuint64_t
vatomic64_await_le_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_LE_SUB_REL
    #define VATOMIC64_AWAIT_LE_SUB_REL

static inline vuint64_t
vatomic64_await_le_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SUB_REL */

#ifndef VATOMIC64_AWAIT_LE_SUB_RLX
    #define VATOMIC64_AWAIT_LE_SUB_RLX

static inline vuint64_t
vatomic64_await_le_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SUB_RLX */

#ifndef VATOMIC64_AWAIT_LE_SET
    #define VATOMIC64_AWAIT_LE_SET

static inline vuint64_t
vatomic64_await_le_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SET */

#ifndef VATOMIC64_AWAIT_LE_SET_ACQ
    #define VATOMIC64_AWAIT_LE_SET_ACQ

static inline vuint64_t
vatomic64_await_le_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SET_ACQ */

#ifndef VATOMIC64_AWAIT_LE_SET_REL
    #define VATOMIC64_AWAIT_LE_SET_REL

static inline vuint64_t
vatomic64_await_le_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SET_REL */

#ifndef VATOMIC64_AWAIT_LE_SET_RLX
    #define VATOMIC64_AWAIT_LE_SET_RLX

static inline vuint64_t
vatomic64_await_le_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur <= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LE_SET_RLX */

#ifndef VATOMIC64_AWAIT_LT_ADD
    #define VATOMIC64_AWAIT_LT_ADD

static inline vuint64_t
vatomic64_await_lt_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_ADD */

#ifndef VATOMIC64_AWAIT_LT_ADD_ACQ
    #define VATOMIC64_AWAIT_LT_ADD_ACQ

static inline vuint64_t
vatomic64_await_lt_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_LT_ADD_REL
    #define VATOMIC64_AWAIT_LT_ADD_REL

static inline vuint64_t
vatomic64_await_lt_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_ADD_REL */

#ifndef VATOMIC64_AWAIT_LT_ADD_RLX
    #define VATOMIC64_AWAIT_LT_ADD_RLX

static inline vuint64_t
vatomic64_await_lt_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_ADD_RLX */

#ifndef VATOMIC64_AWAIT_LT_SUB
    #define VATOMIC64_AWAIT_LT_SUB

static inline vuint64_t
vatomic64_await_lt_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SUB */

#ifndef VATOMIC64_AWAIT_LT_SUB_ACQ
    #define VATOMIC64_AWAIT_LT_SUB_ACQ

static inline vuint64_t
vatomic64_await_lt_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_LT_SUB_REL
    #define VATOMIC64_AWAIT_LT_SUB_REL

static inline vuint64_t
vatomic64_await_lt_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SUB_REL */

#ifndef VATOMIC64_AWAIT_LT_SUB_RLX
    #define VATOMIC64_AWAIT_LT_SUB_RLX

static inline vuint64_t
vatomic64_await_lt_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SUB_RLX */

#ifndef VATOMIC64_AWAIT_LT_SET
    #define VATOMIC64_AWAIT_LT_SET

static inline vuint64_t
vatomic64_await_lt_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SET */

#ifndef VATOMIC64_AWAIT_LT_SET_ACQ
    #define VATOMIC64_AWAIT_LT_SET_ACQ

static inline vuint64_t
vatomic64_await_lt_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SET_ACQ */

#ifndef VATOMIC64_AWAIT_LT_SET_REL
    #define VATOMIC64_AWAIT_LT_SET_REL

static inline vuint64_t
vatomic64_await_lt_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SET_REL */

#ifndef VATOMIC64_AWAIT_LT_SET_RLX
    #define VATOMIC64_AWAIT_LT_SET_RLX

static inline vuint64_t
vatomic64_await_lt_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur < c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_LT_SET_RLX */

#ifndef VATOMIC64_AWAIT_GE_ADD
    #define VATOMIC64_AWAIT_GE_ADD

static inline vuint64_t
vatomic64_await_ge_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_ADD */

#ifndef VATOMIC64_AWAIT_GE_ADD_ACQ
    #define VATOMIC64_AWAIT_GE_ADD_ACQ

static inline vuint64_t
vatomic64_await_ge_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_GE_ADD_REL
    #define VATOMIC64_AWAIT_GE_ADD_REL

static inline vuint64_t
vatomic64_await_ge_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_ADD_REL */

#ifndef VATOMIC64_AWAIT_GE_ADD_RLX
    #define VATOMIC64_AWAIT_GE_ADD_RLX

static inline vuint64_t
vatomic64_await_ge_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_ADD_RLX */

#ifndef VATOMIC64_AWAIT_GE_SUB
    #define VATOMIC64_AWAIT_GE_SUB

static inline vuint64_t
vatomic64_await_ge_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SUB */

#ifndef VATOMIC64_AWAIT_GE_SUB_ACQ
    #define VATOMIC64_AWAIT_GE_SUB_ACQ

static inline vuint64_t
vatomic64_await_ge_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_GE_SUB_REL
    #define VATOMIC64_AWAIT_GE_SUB_REL

static inline vuint64_t
vatomic64_await_ge_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SUB_REL */

#ifndef VATOMIC64_AWAIT_GE_SUB_RLX
    #define VATOMIC64_AWAIT_GE_SUB_RLX

static inline vuint64_t
vatomic64_await_ge_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SUB_RLX */

#ifndef VATOMIC64_AWAIT_GE_SET
    #define VATOMIC64_AWAIT_GE_SET

static inline vuint64_t
vatomic64_await_ge_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SET */

#ifndef VATOMIC64_AWAIT_GE_SET_ACQ
    #define VATOMIC64_AWAIT_GE_SET_ACQ

static inline vuint64_t
vatomic64_await_ge_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SET_ACQ */

#ifndef VATOMIC64_AWAIT_GE_SET_REL
    #define VATOMIC64_AWAIT_GE_SET_REL

static inline vuint64_t
vatomic64_await_ge_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SET_REL */

#ifndef VATOMIC64_AWAIT_GE_SET_RLX
    #define VATOMIC64_AWAIT_GE_SET_RLX

static inline vuint64_t
vatomic64_await_ge_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur >= c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GE_SET_RLX */

#ifndef VATOMIC64_AWAIT_GT_ADD
    #define VATOMIC64_AWAIT_GT_ADD

static inline vuint64_t
vatomic64_await_gt_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_ADD */

#ifndef VATOMIC64_AWAIT_GT_ADD_ACQ
    #define VATOMIC64_AWAIT_GT_ADD_ACQ

static inline vuint64_t
vatomic64_await_gt_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_GT_ADD_REL
    #define VATOMIC64_AWAIT_GT_ADD_REL

static inline vuint64_t
vatomic64_await_gt_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_ADD_REL */

#ifndef VATOMIC64_AWAIT_GT_ADD_RLX
    #define VATOMIC64_AWAIT_GT_ADD_RLX

static inline vuint64_t
vatomic64_await_gt_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur + v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_ADD_RLX */

#ifndef VATOMIC64_AWAIT_GT_SUB
    #define VATOMIC64_AWAIT_GT_SUB

static inline vuint64_t
vatomic64_await_gt_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SUB */

#ifndef VATOMIC64_AWAIT_GT_SUB_ACQ
    #define VATOMIC64_AWAIT_GT_SUB_ACQ

static inline vuint64_t
vatomic64_await_gt_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_GT_SUB_REL
    #define VATOMIC64_AWAIT_GT_SUB_REL

static inline vuint64_t
vatomic64_await_gt_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SUB_REL */

#ifndef VATOMIC64_AWAIT_GT_SUB_RLX
    #define VATOMIC64_AWAIT_GT_SUB_RLX

static inline vuint64_t
vatomic64_await_gt_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, cur - v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SUB_RLX */

#ifndef VATOMIC64_AWAIT_GT_SET
    #define VATOMIC64_AWAIT_GT_SET

static inline vuint64_t
vatomic64_await_gt_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq(a, cur);
        }
    } while ((old = vatomic64_cmpxchg(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SET */

#ifndef VATOMIC64_AWAIT_GT_SET_ACQ
    #define VATOMIC64_AWAIT_GT_SET_ACQ

static inline vuint64_t
vatomic64_await_gt_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_acq(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SET_ACQ */

#ifndef VATOMIC64_AWAIT_GT_SET_REL
    #define VATOMIC64_AWAIT_GT_SET_REL

static inline vuint64_t
vatomic64_await_gt_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rel(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SET_REL */

#ifndef VATOMIC64_AWAIT_GT_SET_RLX
    #define VATOMIC64_AWAIT_GT_SET_RLX

static inline vuint64_t
vatomic64_await_gt_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t cur = 0;
    vuint64_t old = vatomic64_read_rlx(a);
    do {
        cur = old;
        while (!(cur > c)) {
            cur = vatomic64_await_neq_rlx(a, cur);
        }
    } while ((old = vatomic64_cmpxchg_rlx(a, cur, v)) != cur);
    return old;
}

#endif /* VATOMIC64_AWAIT_GT_SET_RLX */

#ifndef VATOMIC32_AWAIT_NEQ_ADD
    #define VATOMIC32_AWAIT_NEQ_ADD

static inline vuint32_t
vatomic32_await_neq_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq(a, c);
    } while (vatomic32_cmpxchg(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_ADD */

#ifndef VATOMIC32_AWAIT_NEQ_ADD_ACQ
    #define VATOMIC32_AWAIT_NEQ_ADD_ACQ

static inline vuint32_t
vatomic32_await_neq_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_NEQ_ADD_REL
    #define VATOMIC32_AWAIT_NEQ_ADD_REL

static inline vuint32_t
vatomic32_await_neq_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_ADD_REL */

#ifndef VATOMIC32_AWAIT_NEQ_ADD_RLX
    #define VATOMIC32_AWAIT_NEQ_ADD_RLX

static inline vuint32_t
vatomic32_await_neq_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_ADD_RLX */

#ifndef VATOMIC32_AWAIT_NEQ_SUB
    #define VATOMIC32_AWAIT_NEQ_SUB

static inline vuint32_t
vatomic32_await_neq_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq(a, c);
    } while (vatomic32_cmpxchg(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SUB */

#ifndef VATOMIC32_AWAIT_NEQ_SUB_ACQ
    #define VATOMIC32_AWAIT_NEQ_SUB_ACQ

static inline vuint32_t
vatomic32_await_neq_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_NEQ_SUB_REL
    #define VATOMIC32_AWAIT_NEQ_SUB_REL

static inline vuint32_t
vatomic32_await_neq_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SUB_REL */

#ifndef VATOMIC32_AWAIT_NEQ_SUB_RLX
    #define VATOMIC32_AWAIT_NEQ_SUB_RLX

static inline vuint32_t
vatomic32_await_neq_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SUB_RLX */

#ifndef VATOMIC32_AWAIT_NEQ_SET
    #define VATOMIC32_AWAIT_NEQ_SET

static inline vuint32_t
vatomic32_await_neq_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq(a, c);
    } while (vatomic32_cmpxchg(a, old, v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SET */

#ifndef VATOMIC32_AWAIT_NEQ_SET_ACQ
    #define VATOMIC32_AWAIT_NEQ_SET_ACQ

static inline vuint32_t
vatomic32_await_neq_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, old, v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SET_ACQ */

#ifndef VATOMIC32_AWAIT_NEQ_SET_REL
    #define VATOMIC32_AWAIT_NEQ_SET_REL

static inline vuint32_t
vatomic32_await_neq_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, old, v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SET_REL */

#ifndef VATOMIC32_AWAIT_NEQ_SET_RLX
    #define VATOMIC32_AWAIT_NEQ_SET_RLX

static inline vuint32_t
vatomic32_await_neq_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    vuint32_t old = 0;
    do {
        old = vatomic32_await_neq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, old, v) != old);
    return old;
}

#endif /* VATOMIC32_AWAIT_NEQ_SET_RLX */

#ifndef VATOMIC64_AWAIT_NEQ_ADD
    #define VATOMIC64_AWAIT_NEQ_ADD

static inline vuint64_t
vatomic64_await_neq_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq(a, c);
    } while (vatomic64_cmpxchg(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_ADD */

#ifndef VATOMIC64_AWAIT_NEQ_ADD_ACQ
    #define VATOMIC64_AWAIT_NEQ_ADD_ACQ

static inline vuint64_t
vatomic64_await_neq_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_NEQ_ADD_REL
    #define VATOMIC64_AWAIT_NEQ_ADD_REL

static inline vuint64_t
vatomic64_await_neq_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_ADD_REL */

#ifndef VATOMIC64_AWAIT_NEQ_ADD_RLX
    #define VATOMIC64_AWAIT_NEQ_ADD_RLX

static inline vuint64_t
vatomic64_await_neq_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, old, old + v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_ADD_RLX */

#ifndef VATOMIC64_AWAIT_NEQ_SUB
    #define VATOMIC64_AWAIT_NEQ_SUB

static inline vuint64_t
vatomic64_await_neq_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq(a, c);
    } while (vatomic64_cmpxchg(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SUB */

#ifndef VATOMIC64_AWAIT_NEQ_SUB_ACQ
    #define VATOMIC64_AWAIT_NEQ_SUB_ACQ

static inline vuint64_t
vatomic64_await_neq_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_NEQ_SUB_REL
    #define VATOMIC64_AWAIT_NEQ_SUB_REL

static inline vuint64_t
vatomic64_await_neq_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SUB_REL */

#ifndef VATOMIC64_AWAIT_NEQ_SUB_RLX
    #define VATOMIC64_AWAIT_NEQ_SUB_RLX

static inline vuint64_t
vatomic64_await_neq_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, old, old - v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SUB_RLX */

#ifndef VATOMIC64_AWAIT_NEQ_SET
    #define VATOMIC64_AWAIT_NEQ_SET

static inline vuint64_t
vatomic64_await_neq_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq(a, c);
    } while (vatomic64_cmpxchg(a, old, v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SET */

#ifndef VATOMIC64_AWAIT_NEQ_SET_ACQ
    #define VATOMIC64_AWAIT_NEQ_SET_ACQ

static inline vuint64_t
vatomic64_await_neq_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, old, v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SET_ACQ */

#ifndef VATOMIC64_AWAIT_NEQ_SET_REL
    #define VATOMIC64_AWAIT_NEQ_SET_REL

static inline vuint64_t
vatomic64_await_neq_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, old, v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SET_REL */

#ifndef VATOMIC64_AWAIT_NEQ_SET_RLX
    #define VATOMIC64_AWAIT_NEQ_SET_RLX

static inline vuint64_t
vatomic64_await_neq_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    vuint64_t old = 0;
    do {
        old = vatomic64_await_neq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, old, v) != old);
    return old;
}

#endif /* VATOMIC64_AWAIT_NEQ_SET_RLX */

#ifndef VATOMICPTR_AWAIT_NEQ_ADD
    #define VATOMICPTR_AWAIT_NEQ_ADD

#endif /* VATOMICPTR_AWAIT_NEQ_ADD */

#ifndef VATOMICPTR_AWAIT_NEQ_ADD_ACQ
    #define VATOMICPTR_AWAIT_NEQ_ADD_ACQ

#endif /* VATOMICPTR_AWAIT_NEQ_ADD_ACQ */

#ifndef VATOMICPTR_AWAIT_NEQ_ADD_REL
    #define VATOMICPTR_AWAIT_NEQ_ADD_REL

#endif /* VATOMICPTR_AWAIT_NEQ_ADD_REL */

#ifndef VATOMICPTR_AWAIT_NEQ_ADD_RLX
    #define VATOMICPTR_AWAIT_NEQ_ADD_RLX

#endif /* VATOMICPTR_AWAIT_NEQ_ADD_RLX */

#ifndef VATOMICPTR_AWAIT_NEQ_SUB
    #define VATOMICPTR_AWAIT_NEQ_SUB

#endif /* VATOMICPTR_AWAIT_NEQ_SUB */

#ifndef VATOMICPTR_AWAIT_NEQ_SUB_ACQ
    #define VATOMICPTR_AWAIT_NEQ_SUB_ACQ

#endif /* VATOMICPTR_AWAIT_NEQ_SUB_ACQ */

#ifndef VATOMICPTR_AWAIT_NEQ_SUB_REL
    #define VATOMICPTR_AWAIT_NEQ_SUB_REL

#endif /* VATOMICPTR_AWAIT_NEQ_SUB_REL */

#ifndef VATOMICPTR_AWAIT_NEQ_SUB_RLX
    #define VATOMICPTR_AWAIT_NEQ_SUB_RLX

#endif /* VATOMICPTR_AWAIT_NEQ_SUB_RLX */

#ifndef VATOMICPTR_AWAIT_NEQ_SET
    #define VATOMICPTR_AWAIT_NEQ_SET

static inline void *
vatomicptr_await_neq_set(vatomicptr_t *a, void *c, void *v)
{
    void *old = NULL;
    do {
        old = vatomicptr_await_neq(a, c);
    } while (vatomicptr_cmpxchg(a, old, v) != old);
    return old;
}

#endif /* VATOMICPTR_AWAIT_NEQ_SET */

#ifndef VATOMICPTR_AWAIT_NEQ_SET_ACQ
    #define VATOMICPTR_AWAIT_NEQ_SET_ACQ

static inline void *
vatomicptr_await_neq_set_acq(vatomicptr_t *a, void *c, void *v)
{
    void *old = NULL;
    do {
        old = vatomicptr_await_neq_rlx(a, c);
    } while (vatomicptr_cmpxchg_acq(a, old, v) != old);
    return old;
}

#endif /* VATOMICPTR_AWAIT_NEQ_SET_ACQ */

#ifndef VATOMICPTR_AWAIT_NEQ_SET_REL
    #define VATOMICPTR_AWAIT_NEQ_SET_REL

static inline void *
vatomicptr_await_neq_set_rel(vatomicptr_t *a, void *c, void *v)
{
    void *old = NULL;
    do {
        old = vatomicptr_await_neq_rlx(a, c);
    } while (vatomicptr_cmpxchg_rel(a, old, v) != old);
    return old;
}

#endif /* VATOMICPTR_AWAIT_NEQ_SET_REL */

#ifndef VATOMICPTR_AWAIT_NEQ_SET_RLX
    #define VATOMICPTR_AWAIT_NEQ_SET_RLX

static inline void *
vatomicptr_await_neq_set_rlx(vatomicptr_t *a, void *c, void *v)
{
    void *old = NULL;
    do {
        old = vatomicptr_await_neq_rlx(a, c);
    } while (vatomicptr_cmpxchg_rlx(a, old, v) != old);
    return old;
}

#endif /* VATOMICPTR_AWAIT_NEQ_SET_RLX */

#ifndef VATOMIC32_AWAIT_EQ_ADD
    #define VATOMIC32_AWAIT_EQ_ADD

static inline vuint32_t
vatomic32_await_eq_add(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq(a, c);
    } while (vatomic32_cmpxchg(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_ADD */

#ifndef VATOMIC32_AWAIT_EQ_ADD_ACQ
    #define VATOMIC32_AWAIT_EQ_ADD_ACQ

static inline vuint32_t
vatomic32_await_eq_add_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_ADD_ACQ */

#ifndef VATOMIC32_AWAIT_EQ_ADD_REL
    #define VATOMIC32_AWAIT_EQ_ADD_REL

static inline vuint32_t
vatomic32_await_eq_add_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_ADD_REL */

#ifndef VATOMIC32_AWAIT_EQ_ADD_RLX
    #define VATOMIC32_AWAIT_EQ_ADD_RLX

static inline vuint32_t
vatomic32_await_eq_add_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_ADD_RLX */

#ifndef VATOMIC32_AWAIT_EQ_SUB
    #define VATOMIC32_AWAIT_EQ_SUB

static inline vuint32_t
vatomic32_await_eq_sub(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq(a, c);
    } while (vatomic32_cmpxchg(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SUB */

#ifndef VATOMIC32_AWAIT_EQ_SUB_ACQ
    #define VATOMIC32_AWAIT_EQ_SUB_ACQ

static inline vuint32_t
vatomic32_await_eq_sub_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SUB_ACQ */

#ifndef VATOMIC32_AWAIT_EQ_SUB_REL
    #define VATOMIC32_AWAIT_EQ_SUB_REL

static inline vuint32_t
vatomic32_await_eq_sub_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SUB_REL */

#ifndef VATOMIC32_AWAIT_EQ_SUB_RLX
    #define VATOMIC32_AWAIT_EQ_SUB_RLX

static inline vuint32_t
vatomic32_await_eq_sub_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SUB_RLX */

#ifndef VATOMIC32_AWAIT_EQ_SET
    #define VATOMIC32_AWAIT_EQ_SET

static inline vuint32_t
vatomic32_await_eq_set(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq(a, c);
    } while (vatomic32_cmpxchg(a, c, v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SET */

#ifndef VATOMIC32_AWAIT_EQ_SET_ACQ
    #define VATOMIC32_AWAIT_EQ_SET_ACQ

static inline vuint32_t
vatomic32_await_eq_set_acq(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_acq(a, c, v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SET_ACQ */

#ifndef VATOMIC32_AWAIT_EQ_SET_REL
    #define VATOMIC32_AWAIT_EQ_SET_REL

static inline vuint32_t
vatomic32_await_eq_set_rel(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rel(a, c, v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SET_REL */

#ifndef VATOMIC32_AWAIT_EQ_SET_RLX
    #define VATOMIC32_AWAIT_EQ_SET_RLX

static inline vuint32_t
vatomic32_await_eq_set_rlx(vatomic32_t *a, vuint32_t c, vuint32_t v)
{
    do {
        (void)vatomic32_await_eq_rlx(a, c);
    } while (vatomic32_cmpxchg_rlx(a, c, v) != c);
    return c;
}

#endif /* VATOMIC32_AWAIT_EQ_SET_RLX */

#ifndef VATOMIC64_AWAIT_EQ_ADD
    #define VATOMIC64_AWAIT_EQ_ADD

static inline vuint64_t
vatomic64_await_eq_add(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq(a, c);
    } while (vatomic64_cmpxchg(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_ADD */

#ifndef VATOMIC64_AWAIT_EQ_ADD_ACQ
    #define VATOMIC64_AWAIT_EQ_ADD_ACQ

static inline vuint64_t
vatomic64_await_eq_add_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_ADD_ACQ */

#ifndef VATOMIC64_AWAIT_EQ_ADD_REL
    #define VATOMIC64_AWAIT_EQ_ADD_REL

static inline vuint64_t
vatomic64_await_eq_add_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_ADD_REL */

#ifndef VATOMIC64_AWAIT_EQ_ADD_RLX
    #define VATOMIC64_AWAIT_EQ_ADD_RLX

static inline vuint64_t
vatomic64_await_eq_add_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, c, c + v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_ADD_RLX */

#ifndef VATOMIC64_AWAIT_EQ_SUB
    #define VATOMIC64_AWAIT_EQ_SUB

static inline vuint64_t
vatomic64_await_eq_sub(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq(a, c);
    } while (vatomic64_cmpxchg(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SUB */

#ifndef VATOMIC64_AWAIT_EQ_SUB_ACQ
    #define VATOMIC64_AWAIT_EQ_SUB_ACQ

static inline vuint64_t
vatomic64_await_eq_sub_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SUB_ACQ */

#ifndef VATOMIC64_AWAIT_EQ_SUB_REL
    #define VATOMIC64_AWAIT_EQ_SUB_REL

static inline vuint64_t
vatomic64_await_eq_sub_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SUB_REL */

#ifndef VATOMIC64_AWAIT_EQ_SUB_RLX
    #define VATOMIC64_AWAIT_EQ_SUB_RLX

static inline vuint64_t
vatomic64_await_eq_sub_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, c, c - v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SUB_RLX */

#ifndef VATOMIC64_AWAIT_EQ_SET
    #define VATOMIC64_AWAIT_EQ_SET

static inline vuint64_t
vatomic64_await_eq_set(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq(a, c);
    } while (vatomic64_cmpxchg(a, c, v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SET */

#ifndef VATOMIC64_AWAIT_EQ_SET_ACQ
    #define VATOMIC64_AWAIT_EQ_SET_ACQ

static inline vuint64_t
vatomic64_await_eq_set_acq(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_acq(a, c, v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SET_ACQ */

#ifndef VATOMIC64_AWAIT_EQ_SET_REL
    #define VATOMIC64_AWAIT_EQ_SET_REL

static inline vuint64_t
vatomic64_await_eq_set_rel(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rel(a, c, v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SET_REL */

#ifndef VATOMIC64_AWAIT_EQ_SET_RLX
    #define VATOMIC64_AWAIT_EQ_SET_RLX

static inline vuint64_t
vatomic64_await_eq_set_rlx(vatomic64_t *a, vuint64_t c, vuint64_t v)
{
    do {
        (void)vatomic64_await_eq_rlx(a, c);
    } while (vatomic64_cmpxchg_rlx(a, c, v) != c);
    return c;
}

#endif /* VATOMIC64_AWAIT_EQ_SET_RLX */

#ifndef VATOMICPTR_AWAIT_EQ_ADD
    #define VATOMICPTR_AWAIT_EQ_ADD

#endif /* VATOMICPTR_AWAIT_EQ_ADD */

#ifndef VATOMICPTR_AWAIT_EQ_ADD_ACQ
    #define VATOMICPTR_AWAIT_EQ_ADD_ACQ

#endif /* VATOMICPTR_AWAIT_EQ_ADD_ACQ */

#ifndef VATOMICPTR_AWAIT_EQ_ADD_REL
    #define VATOMICPTR_AWAIT_EQ_ADD_REL

#endif /* VATOMICPTR_AWAIT_EQ_ADD_REL */

#ifndef VATOMICPTR_AWAIT_EQ_ADD_RLX
    #define VATOMICPTR_AWAIT_EQ_ADD_RLX

#endif /* VATOMICPTR_AWAIT_EQ_ADD_RLX */

#ifndef VATOMICPTR_AWAIT_EQ_SUB
    #define VATOMICPTR_AWAIT_EQ_SUB

#endif /* VATOMICPTR_AWAIT_EQ_SUB */

#ifndef VATOMICPTR_AWAIT_EQ_SUB_ACQ
    #define VATOMICPTR_AWAIT_EQ_SUB_ACQ

#endif /* VATOMICPTR_AWAIT_EQ_SUB_ACQ */

#ifndef VATOMICPTR_AWAIT_EQ_SUB_REL
    #define VATOMICPTR_AWAIT_EQ_SUB_REL

#endif /* VATOMICPTR_AWAIT_EQ_SUB_REL */

#ifndef VATOMICPTR_AWAIT_EQ_SUB_RLX
    #define VATOMICPTR_AWAIT_EQ_SUB_RLX

#endif /* VATOMICPTR_AWAIT_EQ_SUB_RLX */

#ifndef VATOMICPTR_AWAIT_EQ_SET
    #define VATOMICPTR_AWAIT_EQ_SET

static inline void *
vatomicptr_await_eq_set(vatomicptr_t *a, void *c, void *v)
{
    do {
        (void)vatomicptr_await_eq(a, c);
    } while (vatomicptr_cmpxchg(a, c, v) != c);
    return c;
}

#endif /* VATOMICPTR_AWAIT_EQ_SET */

#ifndef VATOMICPTR_AWAIT_EQ_SET_ACQ
    #define VATOMICPTR_AWAIT_EQ_SET_ACQ

static inline void *
vatomicptr_await_eq_set_acq(vatomicptr_t *a, void *c, void *v)
{
    do {
        (void)vatomicptr_await_eq_rlx(a, c);
    } while (vatomicptr_cmpxchg_acq(a, c, v) != c);
    return c;
}

#endif /* VATOMICPTR_AWAIT_EQ_SET_ACQ */

#ifndef VATOMICPTR_AWAIT_EQ_SET_REL
    #define VATOMICPTR_AWAIT_EQ_SET_REL

static inline void *
vatomicptr_await_eq_set_rel(vatomicptr_t *a, void *c, void *v)
{
    do {
        (void)vatomicptr_await_eq_rlx(a, c);
    } while (vatomicptr_cmpxchg_rel(a, c, v) != c);
    return c;
}

#endif /* VATOMICPTR_AWAIT_EQ_SET_REL */

#ifndef VATOMICPTR_AWAIT_EQ_SET_RLX
    #define VATOMICPTR_AWAIT_EQ_SET_RLX

static inline void *
vatomicptr_await_eq_set_rlx(vatomicptr_t *a, void *c, void *v)
{
    do {
        (void)vatomicptr_await_eq_rlx(a, c);
    } while (vatomicptr_cmpxchg_rlx(a, c, v) != c);
    return c;
}

#endif /* VATOMICPTR_AWAIT_EQ_SET_RLX */

#endif /* VATOMIC_FALLBACK_H */
