/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinTextPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinMenuUI
extends BasicMenuUI
implements NapkinTextPainter,
NapkinPainter {
    private DrawnLineHolder line;
    private Icon oldArrowIcon;
    private final PropertyChangeListener orientationListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ComponentOrientation orientation = (ComponentOrientation)evt.getNewValue();
            NapkinMenuUI.this.arrowIcon = NapkinIconFactory.createArrowIcon(orientation.isLeftToRight() ? 3 : 7, 8);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new NapkinMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.oldArrowIcon = this.arrowIcon;
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        this.arrowIcon = NapkinIconFactory.createArrowIcon(isLeftToRight ? 3 : 7, 8);
        c.addPropertyChangeListener("componentOrientation", this.orientationListener);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        this.arrowIcon = this.oldArrowIcon;
        c.removePropertyChangeListener("componentOrientation", this.orientationListener);
        super.uninstallUI(c);
    }

    protected void paintText(Graphics g, JMenuItem item, Rectangle textRect, String text) {
        if (this.line == null) {
            this.line = new DrawnLineHolder(new DrawnCubicLineGenerator());
        }
        NapkinUtil.paintButtonText(g, item, textRect, text, 0, this.line, false, this);
    }

    public void superPaintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        super.paintText(g, (JMenuItem)c, textRect, text);
    }

    private void updateDefaultSelectionColor(Component c) {
        this.selectionForeground = NapkinUtil.currentTheme(c).getSelectionColor();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        final PropertyChangeListener listener = super.createPropertyChangeListener(c);
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                listener.propertyChange(evt);
                if (evt.getPropertyName().equals("ancestor")) {
                    NapkinMenuUI.this.updateDefaultSelectionColor((JComponent)evt.getSource());
                }
            }
        };
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c) {
        super.update(g, c);
    }
}

