/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends javax.swing.undo.UndoManager {
    private static final Logger logger = Logger.getLogger(UndoManager.class.getName());
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public UndoManager() {
        this.setLimit(1000);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        logger.finest("Got undoable edit: " + e.getEdit());
        super.undoableEditHappened(e);
        logger.fine("Added edit " + this.edits.size() + "/" + this.getLimit());
    }

    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        super.undoTo(edit);
        this.fireStateChanged();
    }

    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        super.redoTo(edit);
        this.fireStateChanged();
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean added = super.addEdit(anEdit);
        this.fireStateChanged();
        return added;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            this.changeListeners.get(i).stateChanged(e);
        }
    }
}

