/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.VMDirectByteBuffer;

final class IntViewBufferImpl
extends IntBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    public final int get() {
        int p = this.position();
        int result = ByteBufferHelper.getInt(this.bb, (p << 2) + this.offset, this.endian);
        this.position(p + 1);
        return result;
    }

    public final int get(int index) {
        return ByteBufferHelper.getInt(this.bb, (index << 2) + this.offset, this.endian);
    }

    public final IntBuffer put(int value) {
        int p = this.position();
        ByteBufferHelper.putInt(this.bb, (p << 2) + this.offset, value, this.endian);
        this.position(p + 1);
        return this;
    }

    public final IntBuffer put(int index, int value) {
        ByteBufferHelper.putInt(this.bb, (index << 2) + this.offset, value, this.endian);
        return this;
    }

    public final IntBuffer compact() {
        if (this.position() > 0) {
            int count = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 4 * this.position(), 4 * count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final IntBuffer slice() {
        return new IntViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    final IntBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        return new IntViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), pos, mark, readOnly, this.endian);
    }

    public final IntBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public final IntBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public final ByteOrder order() {
        return this.endian;
    }

    IntViewBufferImpl(ByteBuffer bb, int capacity) {
        super(capacity, capacity, 0, -1);
        this.bb = bb;
        this.offset = bb.position();
        this.readOnly = bb.isReadOnly();
        this.endian = bb.order();
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, this.offset);
        }
    }

    public IntViewBufferImpl(ByteBuffer bb, int offset, int capacity, int limit, int position, int mark, boolean readOnly, ByteOrder endian) {
        super(capacity, limit, position, mark);
        this.bb = bb;
        this.offset = offset;
        this.readOnly = readOnly;
        this.endian = endian;
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, offset);
        }
    }
}

