/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int SIZE = 64;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('D');
    private final double value;

    public static final String toString(double d) {
        return VMDouble.toString(d, false);
    }

    public static final Double valueOf(double val) {
        return new Double(val);
    }

    public static final Double valueOf(String s) {
        return new Double(Double.parseDouble(s));
    }

    public static final double parseDouble(String str) {
        return VMDouble.parseDouble(str);
    }

    public static final boolean isNaN(double v) {
        boolean bl = false;
        if (v != v) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isInfinite(double v) {
        boolean bl = false;
        if (v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public final String toString() {
        return Double.toString(this.value);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return (long)this.value;
    }

    public final float floatValue() {
        return (float)this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Double)) {
            return false;
        }
        double d = ((Double)obj).value;
        if (this.value == d) {
            boolean bl = false;
            if (this.value != 0.0 || 1.0 / this.value == 1.0 / d) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (Double.isNaN(this.value) && Double.isNaN(d)) {
            bl = true;
        }
        return bl;
    }

    public static final long doubleToLongBits(double value) {
        return VMDouble.doubleToLongBits(value);
    }

    public static final long doubleToRawLongBits(double value) {
        return VMDouble.doubleToRawLongBits(value);
    }

    public static final double longBitsToDouble(long bits) {
        return VMDouble.longBitsToDouble(bits);
    }

    public final int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public final int compareTo(Object o) {
        return Double.compare(this.value, ((Double)o).value);
    }

    public static final int compare(double x, double y) {
        if (Double.isNaN(x)) {
            return 1 - Double.isNaN(y);
        }
        if (Double.isNaN(y)) {
            return -1;
        }
        if (x == 0.0 && y == 0.0) {
            return (int)(1.0 / x - 1.0 / y);
        }
        if (x == y) {
            return 0;
        }
        return x > y ? 1 : -1;
    }

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) {
        this.value = Double.parseDouble(s);
    }
}

