/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.highlighter.HAMLHighlighter;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public class HAMLEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public HAMLEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile file) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)HAMLLanguage.INSTANCE, (Project)project, (VirtualFile)file), scheme);
        Language javaScript;
        Language ruby = Language.findLanguageByID((String)"ruby");
        if (ruby != null) {
            try {
                SyntaxHighlighter rubyHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ruby, (Project)project, (VirtualFile)file);
                LayerDescriptor rubyLayer = new LayerDescriptor(rubyHighlighter, "\n", HAMLHighlighter.INJECTED_CODE);
                this.registerLayer(HAMLTokenTypes.INJECTION_CODE, rubyLayer);
            }
            catch (Throwable rubyHighlighter) {
                // empty catch block
            }
        }
        if ((javaScript = Language.findLanguageByID((String)"JavaScript")) != null) {
            try {
                SyntaxHighlighter jsHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)javaScript, (Project)project, (VirtualFile)file);
                LayerDescriptor jsLayer = new LayerDescriptor(jsHighlighter, "\n", HAMLHighlighter.INJECTED_CODE);
                this.registerLayer(HAMLTokenTypes.JAVASCRIPT_CODE, jsLayer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

