/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.idea.RareLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FilterDescendantVirtualFiles;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsAnnotationCachedProxy;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopiesRefreshManager;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnExceptionLogFilter;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdClientFactory;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExecutableChecker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;

public class SvnVcs
extends AbstractVcs<CommittedChangeList> {
    private static final String DO_NOT_LISTEN_TO_WC_DB = "svn.do.not.listen.to.wc.db";
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    public static boolean ourListenToWcDb = !Boolean.getBoolean("svn.do.not.listen.to.wc.db");
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance((String)"org.jetbrains.idea.svn.SvnVcs"));
    @NonNls
    public static final String VCS_NAME = "svn";
    public static final String VCS_DISPLAY_NAME = "Subversion";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    @NotNull
    private final SvnConfiguration myConfiguration;
    private final SvnEntriesFileListener myEntriesFileListener;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final SvnChangelistListener myChangeListListener;
    private SvnCopiesRefreshManager myCopiesRefreshManager;
    private SvnFileUrlMappingImpl myMapping;
    private final MyFrameStateListener myFrameStateListener;
    public static final Topic<Consumer> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Consumer.class);
    private VcsListener myVcsListener;
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final SvnAuthenticationNotifier myAuthNotifier;
    private final SvnLoadedBranchesStorage myLoadedBranchesStorage;
    private final SvnExecutableChecker myChecker;
    private SvnCheckoutProvider myCheckoutProvider;
    @NotNull
    private final ClientFactory cmdClientFactory;
    private final boolean myLogExceptions;

    public SvnVcs(@NotNull Project project, MessageBus bus, SvnConfiguration svnConfiguration, SvnLoadedBranchesStorage storage) {
        if (project == null) {
            SvnVcs.$$$reportNull$$$0(0);
        }
        super(project, VCS_NAME);
        this.myLoadedBranchesStorage = storage;
        this.myRootsToWorkingCopies = new RootsToWorkingCopies(this);
        this.myConfiguration = svnConfiguration;
        this.myAuthNotifier = new SvnAuthenticationNotifier(this);
        this.cmdClientFactory = new CmdClientFactory(this);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
            this.myEntriesFileListener = null;
        } else {
            this.myEntriesFileListener = new SvnEntriesFileListener(project);
            this.upgradeIfNeeded(bus);
            this.myChangeListListener = new SvnChangelistListener(this);
            this.myVcsListener = () -> this.invokeRefreshSvnRoots();
        }
        this.myFrameStateListener = project.isDefault() ? null : new MyFrameStateListener(ChangeListManager.getInstance((Project)project), VcsDirtyScopeManager.getInstance((Project)project));
        this.myChecker = new SvnExecutableChecker(this);
        Application app = ApplicationManager.getApplication();
        this.myLogExceptions = app != null && (app.isInternal() || app.isUnitTestMode());
    }

    public void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myCopiesRefreshManager = new SvnCopiesRefreshManager((SvnFileUrlMappingImpl)this.getSvnFileUrlMapping());
        if (!this.myConfiguration.isCleanupRun()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.cleanup17copies();
                this.myConfiguration.setCleanupRun(true);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.invokeRefreshSvnRoots();
        }
    }

    private void cleanup17copies() {
        Runnable callCleanupWorker = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            new CleanupWorker(this, Collections.emptyList()){

                @Override
                protected void fillRoots() {
                    for (WCInfo info : SvnVcs.this.getAllWcInfos()) {
                        if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat())) continue;
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(info.getRootInfo().getIoFile());
                        if (file == null) {
                            LOG.info("Wasn't able to find virtual file for wc root: " + info.getPath());
                            continue;
                        }
                        this.myRoots.add(file);
                    }
                }
            }.execute();
        };
        this.myCopiesRefreshManager.waitRefresh(() -> ApplicationManager.getApplication().invokeLater(callCleanupWorker));
    }

    public boolean checkCommandLineVersion() {
        return this.getFactory() != this.cmdClientFactory || this.myChecker.checkExecutableAndNotifyIfNeeded();
    }

    public void invokeRefreshSvnRoots() {
        if (REFRESH_LOG.isDebugEnabled()) {
            REFRESH_LOG.debug("refresh: ", new Throwable());
        }
        if (this.myCopiesRefreshManager != null) {
            this.myCopiesRefreshManager.asynchRequest();
        }
    }

    SvnCopiesRefreshManager getCopiesRefreshManager() {
        return this.myCopiesRefreshManager;
    }

    private void upgradeIfNeeded(MessageBus bus) {
        MessageBusConnection connection = bus.connect();
        connection.subscribe(ChangeListManagerImpl.LISTS_LOADED, lists -> {
            if (lists.isEmpty()) {
                return;
            }
            try {
                ChangeListManager.getInstance((Project)this.myProject).setReadOnly(LocalChangeList.DEFAULT_NAME, true);
                if (!this.myConfiguration.changeListsSynchronized()) {
                    this.processChangeLists(lists);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                this.myConfiguration.upgrade();
            }
            connection.disconnect();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeLists(List<LocalChangeList> lists) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject);
        plVcsManager.startBackgroundVcsOperation();
        try {
            for (LocalChangeList list : lists) {
                if (list.isDefault()) continue;
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    this.correctListForRevision(plVcsManager, change.getBeforeRevision(), list.getName());
                    this.correctListForRevision(plVcsManager, change.getAfterRevision(), list.getName());
                }
            }
        }
        finally {
            Application appManager = ApplicationManager.getApplication();
            if (appManager.isDispatchThread()) {
                appManager.executeOnPooledThread(() -> plVcsManager.stopBackgroundVcsOperation());
            } else {
                plVcsManager.stopBackgroundVcsOperation();
            }
        }
    }

    private void correctListForRevision(@NotNull ProjectLevelVcsManager plVcsManager, @Nullable ContentRevision revision, @NotNull String name) {
        FilePath path;
        AbstractVcs vcs;
        if (plVcsManager == null) {
            SvnVcs.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SvnVcs.$$$reportNull$$$0(2);
        }
        if (revision != null && (vcs = plVcsManager.getVcsFor(path = revision.getFile())) != null && VCS_NAME.equals(vcs.getName())) {
            try {
                this.getFactory(path.getIOFile()).createChangeListClient().add(name, path.getIOFile(), null);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
    }

    public void activate() {
        if (!this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangeListListener);
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
        }
        SvnApplicationSettings.getInstance().svnActivated();
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        LoadedRevisionsCache.getInstance(this.myProject);
        FrameStateManager.getInstance().addListener((FrameStateListener)this.myFrameStateListener);
        this.myAuthNotifier.init();
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.checkCommandLineVersion();
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> this.postStartup()));
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myRootsToWorkingCopies);
        this.myLoadedBranchesStorage.activate();
    }

    public static Logger wrapLogger(Logger logger) {
        return RareLogger.wrap((Logger)logger, (boolean)Boolean.getBoolean("svn.logger.fairsynch"), (RareLogger.LogFilter[])new RareLogger.LogFilter[]{new SvnExceptionLogFilter()});
    }

    public RootsToWorkingCopies getRootsToWorkingCopies() {
        return this.myRootsToWorkingCopies;
    }

    public SvnAuthenticationNotifier getAuthNotifier() {
        return this.myAuthNotifier;
    }

    public void deactivate() {
        FrameStateManager.getInstance().removeListener((FrameStateListener)this.myFrameStateListener);
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        SvnApplicationSettings.getInstance().svnDeactivated();
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        if (this.myChangeListListener != null && !this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangeListListener);
        }
        this.myRootsToWorkingCopies.clear();
        this.myAuthNotifier.stop();
        this.myAuthNotifier.clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        this.myLoadedBranchesStorage.deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        ChangeProvider changeProvider = this.myChangeProvider;
        if (changeProvider == null) {
            SvnVcs.$$$reportNull$$$0(3);
        }
        return changeProvider;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    @NotNull
    public String getDisplayName() {
        if (VCS_DISPLAY_NAME == null) {
            SvnVcs.$$$reportNull$$$0(4);
        }
        return VCS_DISPLAY_NAME;
    }

    @NotNull
    public String getShortName() {
        if ("SVN" == null) {
            SvnVcs.$$$reportNull$$$0(5);
        }
        return "SVN";
    }

    public Configurable getConfigurable() {
        return null;
    }

    @NotNull
    public SvnConfiguration getSvnConfiguration() {
        SvnConfiguration svnConfiguration = this.myConfiguration;
        if (svnConfiguration == null) {
            SvnVcs.$$$reportNull$$$0(6);
        }
        return svnConfiguration;
    }

    public static SvnVcs getInstance(@NotNull Project project) {
        if (project == null) {
            SvnVcs.$$$reportNull$$$0(7);
        }
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            SvnVcs.$$$reportNull$$$0(8);
        }
        return checkinEnvironment;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            SvnVcs.$$$reportNull$$$0(9);
        }
        return rollbackEnvironment;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return new VcsAnnotationCachedProxy((AbstractVcs)this, this.myAnnotationProvider);
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    @Nullable
    public PropertyValue getPropertyWithCaching(@NotNull VirtualFile file, @NotNull String propName) throws VcsException {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(10);
        }
        if (propName == null) {
            SvnVcs.$$$reportNull$$$0(11);
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        PropertyClient client = this.getFactory(ioFile).createPropertyClient();
        return client.getProperty(Target.on(ioFile, Revision.WORKING), propName, false, Revision.WORKING);
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            Status status = this.getFactory(file).createStatusClient().doStatus(file, false);
            if (status != null) {
                return status.is(StatusType.STATUS_ADDED) ? status.isCopied() : !status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_IGNORED, StatusType.STATUS_OBSTRUCTED);
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return false;
    }

    public boolean fileIsUnderVcs(@NotNull FilePath path) {
        VirtualFile file;
        if (path == null) {
            SvnVcs.$$$reportNull$$$0(12);
        }
        return (file = path.getVirtualFile()) != null && SvnStatusUtil.isUnderControl(this, file);
    }

    @Nullable
    public Info getInfo(@NotNull Url url, Revision pegRevision, Revision revision) throws SvnBindException {
        if (url == null) {
            SvnVcs.$$$reportNull$$$0(13);
        }
        return this.getFactory().createInfoClient().doInfo(Target.on(url, pegRevision), revision);
    }

    @Nullable
    public Info getInfo(@NotNull Url url, Revision revision) throws SvnBindException {
        if (url == null) {
            SvnVcs.$$$reportNull$$$0(14);
        }
        return this.getInfo(url, Revision.UNDEFINED, revision);
    }

    @Nullable
    public Info getInfo(@NotNull VirtualFile file) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(15);
        }
        return this.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    public Info getInfo(@NotNull String path) {
        if (path == null) {
            SvnVcs.$$$reportNull$$$0(16);
        }
        return this.getInfo(new File(path));
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(17);
        }
        return this.getInfo(ioFile, Revision.UNDEFINED);
    }

    public void collectInfo(@NotNull Collection<File> files, @Nullable InfoConsumer handler) {
        File first;
        if (files == null) {
            SvnVcs.$$$reportNull$$$0(18);
        }
        if ((first = (File)ContainerUtil.getFirstItem(files)) != null) {
            ClientFactory factory = this.getFactory(first);
            try {
                if (factory instanceof CmdClientFactory) {
                    factory.createInfoClient().doInfo(files, handler);
                } else {
                    for (File file : files) {
                        Info info = this.getInfo(file);
                        if (handler == null) continue;
                        handler.consume(info);
                    }
                }
            }
            catch (SvnBindException e) {
                this.handleInfoException(e);
            }
        }
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile, @NotNull Revision revision) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(19);
        }
        if (revision == null) {
            SvnVcs.$$$reportNull$$$0(20);
        }
        Info result = null;
        try {
            result = this.getFactory(ioFile).createInfoClient().doInfo(ioFile, revision);
        }
        catch (SvnBindException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    private void handleInfoException(@NotNull SvnBindException e) {
        if (e == null) {
            SvnVcs.$$$reportNull$$$0(21);
        }
        if (!this.myLogExceptions || SvnUtil.isUnversionedOrNotFound(e) || e.contains(ErrorCode.WC_UNSUPPORTED_FORMAT) || e.contains(ErrorCode.WC_UPGRADE_REQUIRED)) {
            LOG.debug((Throwable)((Object)e));
        } else {
            LOG.error((Throwable)((Object)e));
        }
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(22);
        }
        WorkingCopyFormat workingCopyFormat = this.getWorkingCopyFormat(ioFile, true);
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(23);
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile, boolean useMapping) {
        if (ioFile == null) {
            SvnVcs.$$$reportNull$$$0(24);
        }
        WorkingCopyFormat format = WorkingCopyFormat.UNKNOWN;
        if (useMapping) {
            RootUrlInfo rootInfo = this.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((File)ioFile));
            format = rootInfo != null ? rootInfo.getFormat() : WorkingCopyFormat.UNKNOWN;
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.findRootAndGetFormat(ioFile) : format;
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(25);
        }
        return workingCopyFormat;
    }

    public boolean isWcRoot(@NotNull FilePath filePath) {
        WorkingCopy wcRoot;
        if (filePath == null) {
            SvnVcs.$$$reportNull$$$0(26);
        }
        boolean isWcRoot = false;
        VirtualFile file = filePath.getVirtualFile();
        WorkingCopy workingCopy = wcRoot = file != null ? this.myRootsToWorkingCopies.getWcRoot(file) : null;
        if (wcRoot != null) {
            isWcRoot = wcRoot.getFile().getAbsolutePath().equals(filePath.getPath());
        }
        return isWcRoot;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this);
        }
        SvnCommittedChangesProvider svnCommittedChangesProvider = this.myCommittedChangesProvider;
        if (svnCommittedChangesProvider == null) {
            SvnVcs.$$$reportNull$$$0(27);
        }
        return svnCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        Revision revision = Revision.parse(revisionNumberString);
        if (revision.equals(Revision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        if (this.myMapping == null) {
            this.myMapping = SvnFileUrlMappingImpl.getInstance(this.myProject);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = this.myMapping;
        if (svnFileUrlMappingImpl == null) {
            SvnVcs.$$$reportNull$$$0(28);
        }
        return svnFileUrlMappingImpl;
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info : infoList) {
            File file = info.getIoFile();
            infos.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this, file)));
        }
        return infos;
    }

    public List<WCInfo> getWcInfosWithErrors() {
        ArrayList<WCInfo> result = new ArrayList<WCInfo>(this.getAllWcInfos());
        for (RootUrlInfo info : this.getSvnFileUrlMapping().getErrorRoots()) {
            result.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(info.getIoFile()), Depth.UNKNOWN));
        }
        return result;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.getSvnFileUrlMapping();
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            SvnVcs.$$$reportNull$$$0(29);
        }
        if (convertor == null) {
            SvnVcs.$$$reportNull$$$0(30);
        }
        if (in.size() <= 1) {
            List<S> list = in;
            if (list == null) {
                SvnVcs.$$$reportNull$$$0(31);
            }
            return list;
        }
        List<S> list = Registry.is((String)"svn.filter.unique.roots.by.url") ? this.filterUniqueByUrl(in, convertor) : this.filterUniqueByWorkingCopy(in, convertor);
        if (list == null) {
            SvnVcs.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private <S> List<S> filterUniqueByUrl(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            SvnVcs.$$$reportNull$$$0(33);
        }
        if (convertor == null) {
            SvnVcs.$$$reportNull$$$0(34);
        }
        ArrayList infos = ContainerUtil.newArrayList();
        ArrayList notMatched = ContainerUtil.newArrayList();
        for (S s : in) {
            VirtualFile vf = convertor.apply(s);
            if (vf == null) continue;
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
            Url url = this.getSvnFileUrlMapping().getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(this, ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair(vf, url, s));
        }
        List filtered = new UniqueRootsFilter().filter(infos);
        List converted = ContainerUtil.map(filtered, MyPair::getSrc);
        List list = ContainerUtil.concat((List)converted, (List)notMatched);
        if (list == null) {
            SvnVcs.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private <S> List<S> filterUniqueByWorkingCopy(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        if (in == null) {
            SvnVcs.$$$reportNull$$$0(36);
        }
        if (convertor == null) {
            SvnVcs.$$$reportNull$$$0(37);
        }
        Map filesMap = StreamEx.of(in).mapToEntry(convertor, Function.identity()).distinctKeys().toMap();
        Map byWorkingCopy = StreamEx.of(filesMap.keySet()).mapToEntry(file -> {
            RootUrlInfo wcRoot = this.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)file));
            return wcRoot != null ? wcRoot.getVirtualFile() : SvnUtil.getWorkingCopyRoot(file);
        }, Function.identity()).nonNullKeys().grouping();
        List list = EntryStream.of((Map)byWorkingCopy).flatMapToValue((workingCopy, files) -> {
            FilterDescendantVirtualFiles.filter((List)files);
            return files.stream();
        }).values().map(filesMap::get).toList();
        if (list == null) {
            SvnVcs.$$$reportNull$$$0(38);
        }
        return list;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(@NotNull VirtualFile root) {
        ClientFactory factory;
        if (root == null) {
            SvnVcs.$$$reportNull$$$0(39);
        }
        return ThreeState.YES.equals((Object)this.myAuthNotifier.isAuthenticatedFor(root, (factory = this.getFactory(VfsUtilCore.virtualToIoFile((VirtualFile)root))) == this.cmdClientFactory ? factory : null));
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public CheckoutProvider getCheckoutProvider() {
        if (this.myCheckoutProvider == null) {
            this.myCheckoutProvider = new SvnCheckoutProvider();
        }
        return this.myCheckoutProvider;
    }

    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(40);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            SvnVcs.$$$reportNull$$$0(41);
        }
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(42);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(43);
        }
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(44);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file, boolean useMapping) {
        if (file == null) {
            SvnVcs.$$$reportNull$$$0(45);
        }
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(46);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull Target target) {
        if (target == null) {
            SvnVcs.$$$reportNull$$$0(47);
        }
        ClientFactory clientFactory = target.isFile() ? this.getFactory(target.getFile()) : this.getFactory();
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(48);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactoryFromSettings() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(49);
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getCommandLineFactory() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            SvnVcs.$$$reportNull$$$0(50);
        }
        return clientFactory;
    }

    @NotNull
    public WorkingCopyFormat getLowestSupportedFormatForCommandLine() {
        WorkingCopyFormat result;
        try {
            result = WorkingCopyFormat.from(CmdVersionClient.parseVersion(Registry.stringValue((String)"svn.lowest.supported.format.for.command.line")));
        }
        catch (SvnBindException ignore) {
            result = WorkingCopyFormat.ONE_DOT_SEVEN;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            SvnVcs.$$$reportNull$$$0(51);
        }
        return workingCopyFormat;
    }

    public boolean isSupportedByCommandLine(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            SvnVcs.$$$reportNull$$$0(52);
        }
        return format.isOrGreater(this.getLowestSupportedFormatForCommandLine());
    }

    public boolean is16SupportedByCommandLine() {
        return this.isSupportedByCommandLine(WorkingCopyFormat.ONE_DOT_SIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plVcsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnVcs";
                break;
            }
            case 10: 
            case 15: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 41: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnVcs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRollbackEnvironment";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingCopyFormat";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChangesProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnFileUrlMapping";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueRoots";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueByUrl";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUniqueByWorkingCopy";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryFromSettings";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineFactory";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowestSupportedFormatForCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctListForRevision";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyWithCaching";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileIsUnderVcs";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleInfoException";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingCopyFormat";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isWcRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueRoots";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueByUrl";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterUniqueByWorkingCopy";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isVcsBackgroundOperationsAllowed";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedByCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFrameStateListener
    implements FrameStateListener {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static class MyPair<T>
    implements RootUrlPair {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final Url myUrl;
        private final T mySrc;

        private MyPair(@NotNull VirtualFile file, @NotNull Url url, T src) {
            if (file == null) {
                MyPair.$$$reportNull$$$0(0);
            }
            if (url == null) {
                MyPair.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                MyPair.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @Override
        @NotNull
        public Url getUrl() {
            Url url = this.myUrl;
            if (url == null) {
                MyPair.$$$reportNull$$$0(3);
            }
            return url;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnVcs$MyPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnVcs$MyPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

