/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.parsing;

import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMathParser
implements OperationParserHelper.BinaryOperationParser {
    public static final TokenSet OPERATORS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH, CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    private static final TokenSet[] OPERATOR_PRIORITIES = new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH}), TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_PLUS, CssElementTypes.CSS_MINUS})};
    private static final TokenSet STOP_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH, CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_RBRACE});
    private static final TokenSet PREFIX_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    @NotNull
    private final CssParser myParser;
    @NotNull
    private final IElementType[] myOperationElementTypes;

    public CssMathParser(@NotNull CssParser parser) {
        if (parser == null) {
            CssMathParser.$$$reportNull$$$0(0);
        }
        this.myParser = parser;
        this.myOperationElementTypes = new IElementType[OPERATOR_PRIORITIES.length];
        for (int i = 0; i < OPERATOR_PRIORITIES.length; ++i) {
            this.myOperationElementTypes[i] = CssElementTypes.CSS_BINARY_OPERATION;
        }
    }

    public boolean parse() {
        return OperationParserHelper.callParsingBinaryOperation((OperationParserHelper.BinaryOperationParser)this, (int)(OPERATOR_PRIORITIES.length - 1));
    }

    public boolean parseSimpleExpression() {
        IElementType prevOperation = this.lookBehind(1);
        if (PREFIX_OPERATORS.contains(prevOperation)) {
            IElementType lookBehind2 = this.lookBehind(2);
            if (PREFIX_OPERATORS.contains(lookBehind2) && !this.getWhitespaceTokenSet().contains(this.lookBehindAndGetTokenBefore(1))) {
                this.expectedError("whitespace");
            } else if (!this.myParser.hasWhitespaceBefore()) {
                if (lookBehind2 != CssElementTypes.CSS_LPAREN && !OPERATORS.contains(lookBehind2)) {
                    this.expectedError("whitespace");
                }
            } else if (OPERATORS.contains(lookBehind2) || lookBehind2 == CssElementTypes.CSS_LPAREN) {
                this.expectedError("unexpected whitespace");
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.advance();
            boolean result = this.parse();
            if (this.getTokenType() == CssElementTypes.CSS_RPAREN) {
                this.advance();
            } else {
                this.expectedError("')'");
            }
            return result;
        }
        PsiBuilder.Marker term = this.mark();
        boolean result = this.parseTerm(prevOperation);
        if (!STOP_ELEMENTS.contains(this.getTokenType())) {
            PsiBuilder.Marker error = this.mark();
            this.myParser.advanceUntil(STOP_ELEMENTS.getTypes());
            error.error("unexpected term");
        }
        if (result) {
            term.done(CssElementTypes.CSS_TERM);
        } else {
            term.error(CssBundle.message((String)"expected", (Object[])new Object[]{"term"}));
        }
        return result;
    }

    protected boolean parseTerm(IElementType prevOperation) {
        if (this.getTokenType() == CssElementTypes.CSS_NUMBER) {
            PsiBuilder.Marker numberTerm = this.mark();
            this.advance();
            if (!this.myParser.hasWhitespaceBefore()) {
                IElementType type = this.getTokenType();
                boolean markAsError = prevOperation == CssElementTypes.CSS_SLASH;
                PsiBuilder.Marker possibleError = this.mark();
                if (this.myParser.isIdent() && type != CssElementTypes.CSS_MINUS) {
                    this.myParser.addIdentOrError();
                } else if (this.getTokenType() == CssElementTypes.CSS_PERCENT) {
                    this.advance();
                } else {
                    markAsError = false;
                }
                if (markAsError) {
                    possibleError.error("divider should be a number");
                } else {
                    possibleError.drop();
                }
            }
            numberTerm.done(CssElementTypes.CSS_NUMBER_TERM);
        } else if (this.getTokenType() == CssElementTypes.CSS_IDENT) {
            this.advance();
        } else if (!this.myParser.parseFunction(true)) {
            return false;
        }
        return true;
    }

    protected void expectedError(@NotNull String message) {
        if (message == null) {
            CssMathParser.$$$reportNull$$$0(1);
        }
        this.mark().error(CssBundle.message((String)"expected", (Object[])new Object[]{message}));
    }

    @Nullable
    private IElementType lookBehind(int steps) {
        int rawSteps = 0;
        IElementType type = null;
        for (int i = 0; i < steps; ++i) {
            type = this.myParser.rawLookup(--rawSteps);
            while (this.getWhitespaceTokenSet().contains(type)) {
                type = this.myParser.rawLookup(--rawSteps);
            }
        }
        return type;
    }

    @Nullable
    private IElementType lookBehindAndGetTokenBefore(int steps) {
        int rawSteps = 0;
        for (int i = 0; i < steps; ++i) {
            IElementType type = this.myParser.rawLookup(--rawSteps);
            while (this.getWhitespaceTokenSet().contains(type)) {
                type = this.myParser.rawLookup(--rawSteps);
            }
        }
        return this.myParser.rawLookup(rawSteps - 1);
    }

    public IElementType getTokenType() {
        return this.myParser.getTokenType();
    }

    public boolean isNewLine() {
        return false;
    }

    public void advance() {
        this.myParser.addSingleToken();
    }

    public IElementType rawLookup(int step) {
        return this.myParser.rawLookup(step);
    }

    public IElementType lookAhead(int step) {
        return this.myParser.lookAhead(step);
    }

    public PsiBuilder.Marker mark() {
        return this.myParser.createCompositeElement();
    }

    public void done(PsiBuilder.Marker marker, IElementType elementType) {
        marker.done(elementType);
    }

    public TokenSet getWhitespaceTokenSet() {
        return CssElementTypes.WHITESPACES;
    }

    public TokenSet getPrefixOperators() {
        return PREFIX_OPERATORS;
    }

    public TokenSet getPostfixOperators() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet[] getOperatorsByPriority() {
        if (OPERATOR_PRIORITIES == null) {
            CssMathParser.$$$reportNull$$$0(2);
        }
        return OPERATOR_PRIORITIES;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return null;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return CssElementTypes.CSS_UNARY_OPERATION;
    }

    @NotNull
    public IElementType[] getOperationElementTypes() {
        if (this.myOperationElementTypes == null) {
            CssMathParser.$$$reportNull$$$0(3);
        }
        return this.myOperationElementTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/parsing/CssMathParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/parsing/CssMathParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsByPriority";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expectedError";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

