/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.IconUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware {
    protected final Project myProject;

    public static DirectoryGroupingRule getInstance(Project project) {
        return ServiceManager.getService(project, DirectoryGroupingRule.class);
    }

    public DirectoryGroupingRule(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        UsageInFile usageInFile;
        VirtualFile file;
        if (usage == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null) {
            VirtualFile dir;
            if (file instanceof VirtualFileWindow) {
                file = ((VirtualFileWindow)((Object)file)).getDelegate();
            }
            if ((dir = file.getParent()) == null) {
                return null;
            }
            return this.getGroupForFile(dir);
        }
        return null;
    }

    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(2);
        }
        return new DirectoryGroup(dir);
    }

    public String getActionTitle() {
        return "Group by directory";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/rules/DirectoryGroupingRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentGroupFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DirectoryGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final VirtualFile myDir;
        private Icon myIcon;

        private DirectoryGroup(VirtualFile dir) {
            if (dir == null) {
                DirectoryGroup.$$$reportNull$$$0(0);
            }
            this.myDir = dir;
            this.update();
        }

        @Override
        public void update() {
            if (this.isValid()) {
                this.myIcon = IconUtil.getIcon(this.myDir, 0, DirectoryGroupingRule.this.myProject);
            }
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            VirtualFile baseDir = ProjectUtil.guessProjectDir(DirectoryGroupingRule.this.myProject);
            String relativePath = baseDir == null ? null : VfsUtilCore.getRelativePath(this.myDir, baseDir, File.separatorChar);
            String string = relativePath == null ? this.myDir.getPresentableUrl() : relativePath;
            if (string == null) {
                DirectoryGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.isValid() ? FileStatusManager.getInstance(DirectoryGroupingRule.this.myProject).getStatus(this.myDir) : null;
        }

        @Override
        public boolean isValid() {
            return this.myDir.isValid();
        }

        @Override
        public void navigate(boolean focus) throws UnsupportedOperationException {
            PsiDirectory directory = this.getDirectory();
            if (directory != null && directory.canNavigate()) {
                directory.navigate(focus);
            }
        }

        private PsiDirectory getDirectory() {
            return this.myDir.isValid() ? PsiManager.getInstance(DirectoryGroupingRule.this.myProject).findDirectory(this.myDir) : null;
        }

        @Override
        public boolean canNavigate() {
            PsiDirectory directory = this.getDirectory();
            return directory != null && directory.canNavigate();
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                DirectoryGroup.$$$reportNull$$$0(2);
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DirectoryGroup)) {
                return false;
            }
            return this.myDir.equals(((DirectoryGroup)o).myDir);
        }

        public int hashCode() {
            return this.myDir.hashCode();
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                DirectoryGroup.$$$reportNull$$$0(3);
            }
            if (sink == null) {
                DirectoryGroup.$$$reportNull$$$0(4);
            }
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.VIRTUAL_FILE == key) {
                sink.put(CommonDataKeys.VIRTUAL_FILE, this.myDir);
            }
            if (CommonDataKeys.PSI_ELEMENT == key) {
                sink.put(CommonDataKeys.PSI_ELEMENT, this.getDirectory());
            }
        }

        public String toString() {
            return "Directory:" + this.myDir.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

