/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts;

import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtSymbolInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class RubyFactIndexer
implements PuppetFactDataIndexer {
    private static final Pattern RUBY_ADD_FACT_PATTERN = Pattern.compile("Facter\\s*\\.\\s*add\\s*\\((?:\"|'|:)([^ )\"']+)(?:\"|')?\\s*(?:\\)|,)");

    RubyFactIndexer() {
    }

    @NotNull
    public Map<String, PuppetExtSymbolInfo> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            RubyFactIndexer.$$$reportNull$$$0(0);
        }
        HashMap<String, PuppetExtSymbolInfo> result = new HashMap<String, PuppetExtSymbolInfo>();
        Matcher matcher = RUBY_ADD_FACT_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String factName = matcher.group(1);
            result.put(factName, new PuppetExtSymbolInfo(inputData.getFile().getUrl(), matcher.start(1)));
        }
        HashMap<String, PuppetExtSymbolInfo> hashMap = result;
        if (hashMap == null) {
            RubyFactIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            RubyFactIndexer.$$$reportNull$$$0(2);
        }
        if (parentDirName == null) {
            RubyFactIndexer.$$$reportNull$$$0(3);
        }
        return parentDirName.equals("facter") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".rb");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/RubyFactIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/RubyFactIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

