/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        Promise<String> textPromise;
        if (session2 == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(0);
        }
        if ((textPromise = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2)).getState() == Promise.State.PENDING) {
            return true;
        }
        if (textPromise.getState() == Promise.State.REJECTED) {
            return false;
        }
        try {
            return textPromise.blockingGet(0) != null;
        }
        catch (ExecutionException | TimeoutException e) {
            return false;
        }
    }

    @NotNull
    protected static Promise<String> getTextToEvaluate(DataContext dataContext, XDebugSession session2) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            Promise promise2 = Promise.resolve(null);
            if (promise2 == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(1);
            }
            return promise2;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text != null) {
            Promise promise3 = Promise.resolve((Object)StringUtil.nullize((String)text, (boolean)true));
            if (promise3 == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(2);
            }
            return promise3;
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator != null) {
            Promise promise4 = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor).then(s -> StringUtil.nullize((String)s, (boolean)true));
            if (promise4 == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(3);
            }
            return promise4;
        }
        Promise promise5 = Promise.resolve(null);
        if (promise5 == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(4);
        }
        return promise5;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(5);
        }
        XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2).onSuccess(text -> {
            if (session2 == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(6);
            }
            if (text == null) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                XDebugSessionTab tab;
                if (session2 == null) {
                    XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(7);
                }
                if ((tab = ((XDebugSessionImpl)session2).getSessionTab()) != null) {
                    tab.getWatchesView().addWatchExpression(XExpressionImpl.fromText(text), -1, true);
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToEvaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$perform$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

