/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GutterIntentionMenuContributor
implements IntentionMenuContributor {
    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        if (hostEditor == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(0);
        }
        if (hostFile == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(1);
        }
        if (intentions == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(2);
        }
        Project project = hostFile.getProject();
        Document hostDocument = hostEditor.getDocument();
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project, true);
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), (Processor<? super RangeHighlighterEx>)processor2);
        for (RangeHighlighterEx highlighter : result2) {
            GutterIntentionMenuContributor.addActions(project, highlighter, intentions.guttersToShow, ((EditorEx)hostEditor).getDataContext());
        }
    }

    private static void addActions(@NotNull Project project, @NotNull RangeHighlighterEx info, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull DataContext dataContext) {
        GutterIconRenderer r;
        if (project == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(3);
        }
        if (info == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(6);
        }
        if ((r = info.getGutterIconRenderer()) == null || DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)r)) {
            return;
        }
        ArrayList list2 = new ArrayList();
        AtomicInteger order = new AtomicInteger();
        Object[] actions = new AnAction[]{r.getClickAction(), r.getMiddleButtonClickAction(), r.getRightButtonClickAction()};
        if (r.getPopupMenuActions() != null) {
            actions = (AnAction[])ArrayUtil.mergeArrays((Object[])actions, (Object[])r.getPopupMenuActions().getChildren(null));
        }
        for (Object action : actions) {
            if (action == null) continue;
            GutterIntentionMenuContributor.addActions((AnAction)action, list2, r, order, dataContext);
        }
        descriptors.addAll(list2);
    }

    private static void addActions(@NotNull AnAction action, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, AtomicInteger order, @NotNull DataContext dataContext) {
        GutterIntentionAction gutterAction;
        Icon icon;
        if (action == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(8);
        }
        if (renderer == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(10);
        }
        if (action instanceof ActionGroup) {
            for (AnAction child2 : ((ActionGroup)action).getChildren(null)) {
                GutterIntentionMenuContributor.addActions(child2, descriptors, renderer, order, dataContext);
            }
        }
        if ((icon = action.getTemplatePresentation().getIcon()) == null) {
            icon = renderer.getIcon();
        }
        if (icon.getIconWidth() < 16) {
            icon = IconUtil.toSize((Icon)icon, (int)16, (int)16);
        }
        if (!(gutterAction = new GutterIntentionAction(action, order.getAndIncrement(), icon)).isAvailable(dataContext)) {
            return;
        }
        descriptors.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = gutterAction.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionMenuContributor$1", "getDisplayName"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GutterIntentionMenuContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

