<html><h1>caselist.p</h1><pre>

//<b> Usage: pltab caselist.tab </b>

// <b> This ploticus script will be invoked by pltab to embed graphics
// within the table <a href="caselist.tab">caselist.tab</a>

#declare ID

//<b> get data using <a href="../doc/getdata.html">proc getdata</a></b>
#proc getdata
  file: ../gallery/vf.dat

//<b> set up plotting area using <a href="../doc/areadef.html">proc areadef</a></b>
#proc areadef
  yscaletype: pltab
  xrange: 0 12

//<b> do bottom X axis using <a href="../doc/xaxis.html">proc xaxis</a></b>
#proc xaxis
  stubs: inc 2
  label: Number of months
  location: min-0.2
  #saveas XAX

//<b> do top X axis using <a href="../doc/xaxis.html">proc xaxis</a></b>
#proc xaxis
  #clone XAX
  location: max+0.4
  ticlen: -0.05
  stubdetails: adjust=0,0.3
  labeldetails: adjust=0,0.8


//<b> now loop through the row stubs.. </b>
#loop
  //<b> get the next stub.. </b>
  #set ID = $nextstub(5)
  //<b> when end of page is reached, $nextstub will return a zero length string .. </b>
  #if $strlen(@ID) < 1 
    #break
  #endif

  #proc print
  label: @ID

  //<b> select the case of interest; it alone will become the 'current' data
  // however the original data set will still reside in memory <a href="../doc/transform.html">(proc transform)</a></b>
  #proc transform
    action: select
    select: @@1 = @ID
    stack: yes

  //<b> change from one row of data to one column of data, since proc lineplot
  // uses data by field position <a href="../doc/transform.html">(proc transform)</a></b>
  #proc transform
    action: rotate
    rejectfields: 1 2 3 4
    stack: yes

  //<b> now set up a little plotting area using pltabrow scale type <a href="../doc/areadef.html">(proc areadef)</a></b>
  #proc areadef
    yscaletype: pltabrow @ID
    xrange: 0 12
    yrange: 0 100
    pltabrowy: -.2 .1
    yaxis.stubs: none
    yaxis.tics: none

  //<b> do the lineplot for the case using <a href="../doc/lineplot.html">proc lineplot</a></b>
  #proc lineplot
    yfield: 1
    stairstep: yes
    lastseglen: 1(s)

  //<b> do the dotted reference line using <a href="../doc/lineplot.html">proc lineplot</a></b>
  #proc line
    notation: scaled
    linedetails: color=green width=0.2 style=1 dashscale=2
    points: @XSTART @YSTART 12 @YSTART

  //<b> reset so that we are referencing the original (big) data set again <a href="../doc/originaldata.html">proc originaldata</a></b>
  #proc originaldata
  
#endloop
