/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.ui.JBColor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.TableWithFixedWidth;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PieChartLegend<T>
extends JPanel {
    @NotNull
    private final List<T> myData;
    @NotNull
    private final Convertor<? super T, Integer> myDataConvertor;
    @NotNull
    private final Convertor<? super T, ? extends JBColor> myColorConvertor;
    @NotNull
    private final TableCellRenderer myNameRenderer;
    @NotNull
    private final TableCellRenderer myValueRenderer;
    @NotNull
    private final TableCellRenderer myColorRenderer;
    private final List<JLabel> myIconCache;

    public PieChartLegend(@NotNull List<T> data, @NotNull Convertor<? super T, Integer> convertor, @NotNull Convertor<? super T, ? extends JBColor> colorConvertor, @NotNull TableCellRenderer nameRenderer, @NotNull TableCellRenderer valueRenderer) {
        if (data == null) {
            PieChartLegend.$$$reportNull$$$0(0);
        }
        if (convertor == null) {
            PieChartLegend.$$$reportNull$$$0(1);
        }
        if (colorConvertor == null) {
            PieChartLegend.$$$reportNull$$$0(2);
        }
        if (nameRenderer == null) {
            PieChartLegend.$$$reportNull$$$0(3);
        }
        if (valueRenderer == null) {
            PieChartLegend.$$$reportNull$$$0(4);
        }
        super(new BorderLayout());
        this.myData = new ArrayList<T>(data);
        Collections.reverse(this.myData);
        this.myDataConvertor = convertor;
        this.myColorConvertor = colorConvertor;
        this.myNameRenderer = nameRenderer;
        this.myValueRenderer = valueRenderer;
        this.myColorRenderer = this.createColorRenderer();
        this.myIconCache = new ArrayList<JLabel>();
        for (T t : this.myData) {
            this.myIconCache.add(new JLabel((Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(10, (Color)this.myColorConvertor.convert(t)))));
        }
        TableWithFixedWidth table = new TableWithFixedWidth(new MyTableModel()){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 0) {
                    return PieChartLegend.this.myColorRenderer;
                }
                if (column == 1) {
                    return PieChartLegend.this.myNameRenderer;
                }
                if (column == 2) {
                    return PieChartLegend.this.myValueRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        }.fixWidth();
        table.setBackground(UIUtil.getPanelBackground());
        table.setRowSelectionAllowed(false);
        table.setShowColumns(false);
        table.setShowGrid(false);
        V8Utils.adjustTableColumnWidths(table);
        this.add((Component)((Object)table), "North");
    }

    private TableCellRenderer createColorRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (Component)PieChartLegend.this.myIconCache.get(row);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "convertor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "colorConvertor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "nameRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "valueRenderer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/cpu/view/PieChartLegend";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return PieChartLegend.this.myData.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return PieChartLegend.this.myColorConvertor.convert(PieChartLegend.this.myData.get(rowIndex));
            }
            if (columnIndex == 1) {
                return PieChartLegend.this.myData.get(rowIndex);
            }
            if (columnIndex == 2) {
                return V8Utils.formatPercent((Integer)PieChartLegend.this.myDataConvertor.convert(PieChartLegend.this.myData.get(rowIndex)));
            }
            return null;
        }
    }
}

