/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.doc.NodeDoc;
import com.jetbrains.nodejs.doc.NodeDocSplitter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDocManager {
    public static final Logger LOG = Logger.getInstance(NodeDocManager.class);
    private static final NodeDocManager INSTANCE = new NodeDocManager();

    @NotNull
    public NodeDoc getDoc(@NotNull Project project, @NotNull SemVer nodeVersion) {
        if (project == null) {
            NodeDocManager.$$$reportNull$$$0(0);
        }
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(1);
        }
        File docDir = NodeDocManager.getDocDir(nodeVersion);
        this.downloadIfNeeded(project, nodeVersion, docDir);
        NodeDoc nodeDoc = new NodeDoc(nodeVersion, docDir);
        if (nodeDoc == null) {
            NodeDocManager.$$$reportNull$$$0(2);
        }
        return nodeDoc;
    }

    @NotNull
    private static File getDocDir(@NotNull SemVer nodeVersion) {
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(3);
        }
        File rootDir = new File(new File(PathManager.getSystemPath(), "extLibs"), "nodejs" + File.separator + "documentation");
        File file = new File(rootDir, nodeVersion.getParsedVersion());
        if (file == null) {
            NodeDocManager.$$$reportNull$$$0(4);
        }
        return file;
    }

    public void downloadIfNeeded(@NotNull Project project, @NotNull SemVer nodeVersion, @NotNull File docDir) {
        File allDocJson;
        if (project == null) {
            NodeDocManager.$$$reportNull$$$0(5);
        }
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(6);
        }
        if (docDir == null) {
            NodeDocManager.$$$reportNull$$$0(7);
        }
        if (!(allDocJson = new File(docDir, "all.json")).isFile()) {
            NodeDocManager.downloadWithProgressSync(project, nodeVersion, docDir, allDocJson);
        }
    }

    private static void downloadWithProgressSync(@NotNull Project project, @NotNull SemVer nodeVersion, @NotNull File docDir, File allDocJson) {
        if (project == null) {
            NodeDocManager.$$$reportNull$$$0(8);
        }
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(9);
        }
        if (docDir == null) {
            NodeDocManager.$$$reportNull$$$0(10);
        }
        Semaphore semaphore = new Semaphore(0, true);
        NodeDocManager.downloadWithProgressAsync(project, nodeVersion, docDir, allDocJson, semaphore);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException ignored) {
            Thread.interrupted();
        }
    }

    private static void downloadWithProgressAsync(@NotNull Project project, final @NotNull SemVer nodeVersion, final @NotNull File docDir, final @NotNull File allDocJson, final @Nullable Semaphore semaphore) {
        if (project == null) {
            NodeDocManager.$$$reportNull$$$0(11);
        }
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(12);
        }
        if (docDir == null) {
            NodeDocManager.$$$reportNull$$$0(13);
        }
        if (allDocJson == null) {
            NodeDocManager.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                NodeDocManager.$$$reportNull$$$0(18);
            }
            if (nodeVersion == null) {
                NodeDocManager.$$$reportNull$$$0(19);
            }
            if (docDir == null) {
                NodeDocManager.$$$reportNull$$$0(20);
            }
            if (allDocJson == null) {
                NodeDocManager.$$$reportNull$$$0(21);
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Node.js Documentation", false, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        NodeDocManager.downloadAllDocJson(nodeVersion, docDir, allDocJson);
                        new NodeDocSplitter(allDocJson, docDir).split();
                    }
                    catch (IOException e) {
                        LOG.warn("Cannot download Node.js " + nodeVersion.getParsedVersion() + " documentation", (Throwable)e);
                    }
                    finally {
                        if (semaphore != null) {
                            semaphore.release();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/doc/NodeDocManager$1", "run"));
                }
            });
        });
    }

    private static void downloadAllDocJson(@NotNull SemVer nodeVersion, @NotNull File docDir, @NotNull File allDocJson) throws IOException {
        if (nodeVersion == null) {
            NodeDocManager.$$$reportNull$$$0(15);
        }
        if (docDir == null) {
            NodeDocManager.$$$reportNull$$$0(16);
        }
        if (allDocJson == null) {
            NodeDocManager.$$$reportNull$$$0(17);
        }
        long startTime = System.nanoTime();
        FileUtil.delete((File)docDir);
        if (!FileUtil.createDirectory((File)docDir)) {
            throw new IOException("Cannot create directory for Node.js documentation " + docDir.getAbsolutePath());
        }
        String parsedVersion = nodeVersion.getParsedVersion();
        String url = "http://nodejs.org/dist/v" + parsedVersion + "/docs/api/all.json";
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setText("Getting Node.js " + parsedVersion + " documentation" + "${content-length}" + " ...");
        DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)url, (File)allDocJson);
        long duration = System.nanoTime() - startTime;
        LOG.info(String.format("Node.js %s documentation %s downloaded in %.2f ms", parsedVersion, url, (double)duration / 1000000.0));
    }

    public static NodeDocManager getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersion";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/doc/NodeDocManager";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docDir";
                break;
            }
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDocJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/doc/NodeDocManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDoc";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocDir";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadIfNeeded";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithProgressSync";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithProgressAsync";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "downloadAllDocJson";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadWithProgressAsync$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

