/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.com.intellij.sql.formatter.model.SqlColumnAliasCortegeBlock;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FindPhraseResult;
import com.intellij.sql.formatter.model.SqlAS;
import com.intellij.sql.formatter.model.SqlAlias;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlAssignmentBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockComment;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlCaseExpressionBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlConstraintDetailBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlCreateExoticBlock;
import com.intellij.sql.formatter.model.SqlCreateSchemaBlock;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlCreateTypeBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlDropRoutineBlock;
import com.intellij.sql.formatter.model.SqlElsifSectionBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlExternalParameter;
import com.intellij.sql.formatter.model.SqlFileBlock;
import com.intellij.sql.formatter.model.SqlForeignKeyReferencesBlock;
import com.intellij.sql.formatter.model.SqlForkBlock;
import com.intellij.sql.formatter.model.SqlForkSectionBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlFunctionCallBlock;
import com.intellij.sql.formatter.model.SqlGenericSettingBlock;
import com.intellij.sql.formatter.model.SqlIdentifier;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineComment;
import com.intellij.sql.formatter.model.SqlLiteral;
import com.intellij.sql.formatter.model.SqlLoopBlock;
import com.intellij.sql.formatter.model.SqlMergeBlock;
import com.intellij.sql.formatter.model.SqlNamedConstraintDefinitionBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlNullabilityCheckBlock;
import com.intellij.sql.formatter.model.SqlOraPackageBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedExpressionBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlock;
import com.intellij.sql.formatter.model.SqlSimpleTypeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.SqlTableTypeBlock;
import com.intellij.sql.formatter.model.SqlTriggerBlock;
import com.intellij.sql.formatter.model.SqlTypeParameterListBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.formatter.model.SqlViewBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00a0\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0006\u0010 \u001a\u00020!\u001a\u0006\u0010\"\u001a\u00020!\u001a\u0006\u0010#\u001a\u00020!\u001a\u0012\u0010$\u001a\u00020\u00072\b\b\u0001\u0010%\u001a\u00020\u0007H\u0007\u001a3\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020\u00150(2\b\b\u0002\u0010)\u001a\u00020\u00072\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020+\"\u00020\u0002\u00a2\u0006\u0002\u0010,\u001a%\u0010-\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0086\b\u001a&\u0010-\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000e0\u000e0\f*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010.\u001a\u00020\u0002\u001a&\u0010-\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000e0\u000e0\f*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010/\u001a\u000200\u001a.\u0010-\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000e0\u000e0\f*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000200\u001a7\u0010-\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000e0\u000e0\f*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020+\"\u00020\u0002\u00a2\u0006\u0002\u00104\u001a&\u00105\u001a\u0004\u0018\u0001H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0086\b\u00a2\u0006\u0002\u00106\u001a\u001a\u00105\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010.\u001a\u00020\u0002\u001a\u001a\u00105\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010/\u001a\u000200\u001a0\u00107\u001a\u0004\u0018\u00010\b*\b\u0012\u0004\u0012\u00020\u00150(2\b\b\u0002\u00108\u001a\u00020\u00072\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020'0:\u001a \u0010;\u001a\u0004\u0018\u0001H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e*\u00020\u000eH\u0080\b\u00a2\u0006\u0002\u0010<\u001a5\u0010=\u001a\u0004\u0018\u00010>*\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010?\u001a\u00020\u00072\u0014\u0010@\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020+0+\u00a2\u0006\u0002\u0010A\u001a\u000e\u0010B\u001a\u0004\u0018\u00010C*\u0004\u0018\u00010D\u001a6\u0010E\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010.\u001a\u00020\u00022\b\b\u0002\u00108\u001a\u00020\u00072\b\b\u0002\u0010F\u001a\u00020\u00072\b\b\u0002\u0010G\u001a\u00020\u0007\u001a<\u0010E\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00150(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u00108\u001a\u00020\u00072\b\b\u0002\u0010F\u001a\u00020\u00072\b\b\u0002\u0010G\u001a\u00020\u0007\u001aI\u0010H\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\u0002H\r2,\u0010I\u001a(\u0012\u0004\u0012\u0002H\r\u0012\u0013\u0012\u0011H\r\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\u0004\u0012\u00020N0J\u00a2\u0006\u0002\bOH\u0000\u00a2\u0006\u0002\u0010P\u001a\f\u0010Q\u001a\u00020'*\u0004\u0018\u00010D\u001a\u0012\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00150(*\u00020\u0015H\u0000\u001a&\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00150(*\u00020\u00152\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020'0:H\u0000\u001a\u000e\u0010T\u001a\u0004\u0018\u00010\u0002*\u00020\u000eH\u0000\u001a\u000e\u0010U\u001a\u0004\u0018\u00010\u0015*\u00020\u000eH\u0000\u001a&\u0010V\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u000e0\u000e0\f*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010W\u001a\u00020\u0007\"\"\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\",\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006X"}, d2={"CONSTRAINT_TYPES", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "getCONSTRAINT_TYPES", "()Ljava/util/Set;", "finish", "", "Lkotlin/ranges/IntRange;", "getFinish", "(Lkotlin/ranges/IntRange;)I", "jbi", "Lcom/intellij/util/containers/JBIterable;", "B", "Lcom/intellij/sql/formatter/model/SqlBlock;", "", "getJbi", "(Ljava/lang/Iterable;)Lcom/intellij/util/containers/JBIterable;", "createBlockForBinaryExpression", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "node", "Lcom/intellij/lang/ASTNode;", "createBlockForConstraint", "createBlockForIdentifier", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "createBlockForParenthesizedExpression", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "createBlockForStatement", "createDropBlock", "instantiateDefaultBlock", "makeDefaultBlock", "parent", "makeLeftAlignment", "Lcom/intellij/formatting/Alignment;", "makeLeftAlignmentBS", "makeRightAlignment", "openingToElLine", "opening", "checkSubSequence", "", "", "from", "subSequence", "", "(Ljava/util/List;I[Lcom/intellij/psi/tree/IElementType;)Z", "filter", "type", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "role1", "role2", "types", "(Ljava/lang/Iterable;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/util/containers/JBIterable;", "find", "(Ljava/lang/Iterable;)Lcom/intellij/sql/formatter/model/SqlBlock;", "findConsequence", "since", "predicate", "Lkotlin/Function1;", "findParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)Lcom/intellij/sql/formatter/model/SqlBlock;", "findPhrase", "Lcom/intellij/sql/formatter/model/FindPhraseResult;", "offset", "patterns", "(Ljava/util/List;I[[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/sql/formatter/model/FindPhraseResult;", "getType", "Lcom/intellij/formatting/WrapImpl$Type;", "Lcom/intellij/formatting/Wrap;", "indexOf", "till", "notFound", "init", "initializer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "that", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/sql/formatter/model/SqlBlock;Lkotlin/jvm/functions/Function2;)Lcom/intellij/sql/formatter/model/SqlBlock;", "isAlways", "listChildren", "flatten", "primaryElementType", "primaryNode", "skip", "count", "intellij.database.sql.impl"})
public final class SqlFormattingModelFunKt {
    @NotNull
    private static final Set<IElementType> CONSTRAINT_TYPES = SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCompositeElementTypes.SQL_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION, (IElementType)SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION});

    @NotNull
    public static final Set<IElementType> getCONSTRAINT_TYPES() {
        return CONSTRAINT_TYPES;
    }

    @NotNull
    public static final SqlBlock makeDefaultBlock(@NotNull SqlBlock parent2, @NotNull ASTNode node) {
        SqlBlock block;
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        SqlBlock sqlBlock = block = SqlFormattingModelFunKt.instantiateDefaultBlock(node);
        if (sqlBlock instanceof SqlNodeBlock) {
            SqlNodeBlock $receiver$iv = (SqlNodeBlock)block;
            $receiver$iv.setup$intellij_database_sql_impl(parent2, node);
        } else if (sqlBlock instanceof SqlLeafBlock) {
            SqlLeafBlock $receiver$iv = (SqlLeafBlock)block;
            $receiver$iv.setup$intellij_database_sql_impl(parent2, node);
        } else if (sqlBlock instanceof SqlRangeBlock) {
            SqlRangeBlock $receiver$iv = (SqlRangeBlock)block;
            TextRange textRange = node.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"outerNode.textRange");
            $receiver$iv.setup$intellij_database_sql_impl(parent2, textRange, SqlFormattingModelFunKt.listChildren(node));
        }
        return block;
    }

    @NotNull
    public static final SqlBlock instantiateDefaultBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType type = iElementType;
        if (type instanceof SqlKeywordTokenType) {
            IElementType iElementType2 = type;
            sqlBlock = Intrinsics.areEqual((Object)iElementType2, (Object)SqlCommonKeywords.SQL_AS) ? (SqlKeyword)new SqlAS() : new SqlKeyword();
        } else if (SqlUtilFun.isSymbol(node)) {
            IElementType iElementType3 = type;
            sqlBlock = Intrinsics.areEqual((Object)iElementType3, (Object)SqlCommonTokens.SQL_COMMA) ? (SqlSymbol)new SqlComma() : new SqlSymbol();
        } else if (node instanceof IsExternal) {
            sqlBlock = new SqlLeafBlock();
        } else if (node instanceof PsiErrorElement) {
            sqlBlock = new SqlErrorNodeBlock();
        } else if (node instanceof SqlColumnAliasListImpl) {
            sqlBlock = new SqlColumnAliasCortegeBlock();
        } else {
            IElementType iElementType4 = type;
            if (iElementType4 instanceof IsExternal) {
                sqlBlock = new SqlLeafBlock();
            } else if (SqlFormattingFunKt.getLITERAL_TYPES().contains(iElementType4)) {
                sqlBlock = new SqlLiteral();
            } else if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)iElementType4)) {
                sqlBlock = new SqlLineComment();
            } else if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getBLOCK_COMMENT_TYPES(), (Object)iElementType4)) {
                sqlBlock = new SqlBlockComment();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT)) {
                sqlBlock = new SqlBlockStatementBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_SELECT_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_UNION_EXPRESSION)) {
                sqlBlock = new SqlQueryBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_INSERT_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_UPDATE_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_DELETE_STATEMENT)) {
                sqlBlock = new SqlQueryBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION)) {
                sqlBlock = new SqlQueryBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_MERGE_STATEMENT)) {
                sqlBlock = new SqlMergeBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION)) {
                sqlBlock = new SqlParenthesizedSubqueryBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForIdentifier(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_BINARY_EXPRESSION)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForBinaryExpression(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_CASE_EXPRESSION)) {
                sqlBlock = new SqlCaseExpressionBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_REFERENCE_LIST)) {
                sqlBlock = new SqlCortegeBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlElementTypes.SQL_PARENTHESIZED_EXPRESSION)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForParenthesizedExpression(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_FUNCTION_CALL)) {
                sqlBlock = new SqlFunctionCallBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT))) {
                sqlBlock = new SqlCreateTableBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_SCHEMA_STATEMENT))) {
                sqlBlock = new SqlCreateSchemaBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_COLUMN_DEFINITION))) {
                sqlBlock = new SqlColumnBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_REFERENCES_CLAUSE)) {
                sqlBlock = new SqlForeignKeyReferencesBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_FOREIGN_KEY_CASCADE_OPTION) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE)) {
                sqlBlock = new SqlConstraintDetailBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_TABLE_STATEMENT))) {
                sqlBlock = new SqlAlterTableBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION))) {
                sqlBlock = new SqlAlterInstructionBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_VIEW_STATEMENT)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_MATERIALIZED_VIEW_STATEMENT))) {
                sqlBlock = new SqlViewBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_PROCEDURE_STATEMENT)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_FUNCTION_STATEMENT))) {
                sqlBlock = new SqlRoutineBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_PROCEDURE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_FUNCTION_DEFINITION))) {
                sqlBlock = new SqlRoutineBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_IF_STATEMENT)) {
                sqlBlock = new SqlForkBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_THEN_CLAUSE) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_ELSE_CLAUSE)) {
                sqlBlock = new SqlForkSectionBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_ELSEIF_CLAUSE)) {
                sqlBlock = new SqlElsifSectionBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_LOOP_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT) || Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT)) {
                sqlBlock = new SqlLoopBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_SET_ASSIGNMENT)) {
                sqlBlock = new SqlAssignmentBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_STATEMENT)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForStatement(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK)) {
                sqlBlock = new SqlBatchBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT))) {
                sqlBlock = new SqlTriggerBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)((Object)SqlCompositeElementTypes.SQL_CREATE_ASSERTION_STATEMENT))) {
                sqlBlock = new SqlCreateExoticBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) {
                sqlBlock = new SqlGenericSettingBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_GENERIC_DROP_STATEMENT)) {
                sqlBlock = SqlFormattingModelFunKt.createDropBlock(node);
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT)) {
                sqlBlock = SqlUtilFun.firstLeaf(node).getElementType() == SqlCommonKeywords.SQL_TABLE ? (SqlNodeBlock)new SqlTableTypeBlock() : (SqlNodeBlock)new SqlSimpleTypeBlock();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE)) {
                sqlBlock = new SqlExternalParameter();
            } else if (Intrinsics.areEqual((Object)iElementType4, (Object)SqlCompositeElementTypes.SQL_TYPE_PARAMETER_LIST)) {
                sqlBlock = new SqlTypeParameterListBlock();
            } else if (CONSTRAINT_TYPES.contains(iElementType4)) {
                sqlBlock = SqlFormattingModelFunKt.createBlockForConstraint(node);
            } else if (iElementType4 instanceof SqlFileElementType) {
                sqlBlock = new SqlFileBlock();
            } else {
                String string = type.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.toString()");
                String code = string;
                sqlBlock = (SqlBlock)(Intrinsics.areEqual((Object)code, (Object)"ORA_CREATE_PACKAGE_STATEMENT") || Intrinsics.areEqual((Object)code, (Object)"ORA_CREATE_PACKAGE_BODY_STATEMENT") || Intrinsics.areEqual((Object)code, (Object)"ORA_CREATE_TYPE_BODY_STATEMENT") ? (Block)new SqlOraPackageBlock() : (Intrinsics.areEqual((Object)code, (Object)"ORA_CREATE_TYPE_STATEMENT") || Intrinsics.areEqual((Object)code, (Object)"MSSQL_CREATE_TYPE_STATEMENT") ? (Block)new SqlCreateTypeBlock() : (Intrinsics.areEqual((Object)code, (Object)"ORA_CONDITIONAL_FLAG_REFERENCE") ? (Block)new SqlIdentifier() : (Intrinsics.areEqual((Object)code, (Object)"SQLITE_CREATE_VIRTUAL_TABLE_STATEMENT") ? (Block)new SqlCreateTableBlock() : (node instanceof SqlBlockStatementImpl ? (Block)new SqlBlockStatementBlock() : (node instanceof SqlDdlStatement ? (Block)new SqlDdlStatementBlock() : (SqlUtilFun.isKeyWord(node) ? (Block)new SqlKeyword() : (SqlUtilFun.isComplex(node) ? (Block)new SqlUnsortedBlock() : (Block)new SqlLeafBlock()))))))));
            }
        }
        return sqlBlock;
    }

    private static final SqlRangeBlock createBlockForParenthesizedExpression(ASTNode node) {
        return SqlUtilFun.getMeaningfulChildType(node, 2) == SqlCommonTokens.SQL_COMMA ? (SqlRangeBlock)new SqlCortegeBlock() : (SqlRangeBlock)new SqlParenthesizedExpressionBlock();
    }

    private static final SqlNodeBlock createBlockForBinaryExpression(ASTNode node) {
        IElementType t2 = SqlUtilFun.getMeaningfulChildType(node, 1);
        if (t2 == SqlCommonTokens.SQL_OP_ASSIGN) {
            return new SqlAssignmentBlock();
        }
        IElementType t3 = SqlUtilFun.getMeaningfulChildType(node, 2);
        if (!(t3 != SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && t3 != SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL || t2 != SqlCompositeElementTypes.SQL_GENERIC_ELEMENT && t2 != SqlCommonKeywords.SQL_IS)) {
            return new SqlNullabilityCheckBlock();
        }
        return new SqlBinaryExpressionBlock();
    }

    private static final SqlBlock createBlockForStatement(ASTNode node) {
        ASTNode firstChildType;
        ASTNode aSTNode = node.getFirstChildNode();
        if (aSTNode == null || (aSTNode = aSTNode.getElementType()) == null) {
            return new SqlStatementBlock();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.firstChildNode?.ele\u2026eturn SqlStatementBlock()");
        ASTNode aSTNode2 = firstChildType = aSTNode;
        return Intrinsics.areEqual((Object)aSTNode2, (Object)SqlCompositeElementTypes.SQL_WITH_CLAUSE) ? (SqlBlock)new SqlQueryBlock() : (SqlBlock)new SqlStatementBlock();
    }

    private static final SqlLeafBlock createBlockForIdentifier(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.treeParent");
        return aSTNode.getElementType() == SqlCompositeElementTypes.SQL_AS_EXPRESSION ? (SqlLeafBlock)new SqlAlias() : (SqlLeafBlock)new SqlIdentifier();
    }

    private static final SqlBlock createBlockForConstraint(ASTNode node) {
        IElementType iElementType = SqlUtilFun.firstLeaf(node).getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.firstLeaf().elementType");
        IElementType firstLeafElementType = iElementType;
        IElementType iElementType2 = SqlUtilFun.lastLeaf(node).getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"node.lastLeaf().elementType");
        IElementType lastLeafElementType = iElementType2;
        return firstLeafElementType == SqlCommonKeywords.SQL_CONSTRAINT ? (SqlBlock)new SqlNamedConstraintDefinitionBlock() : (firstLeafElementType == SqlCommonKeywords.SQL_DEFAULT ? (SqlBlock)new SqlColumnDefaultBlock() : (lastLeafElementType == SqlCommonKeywords.SQL_NULL ? (SqlBlock)new SqlColumnNullabilityBlock() : (SqlBlock)new SqlConstraintDefinitionBlock()));
    }

    private static final SqlBlock createDropBlock(ASTNode node) {
        SqlDropStatementImpl targetKind;
        SqlDropStatementImpl sqlDropStatementImpl;
        ASTNode aSTNode = node;
        if (!(aSTNode instanceof SqlDropStatementImpl)) {
            aSTNode = null;
        }
        if ((sqlDropStatementImpl = (SqlDropStatementImpl)aSTNode) == null || (sqlDropStatementImpl = sqlDropStatementImpl.getTargetType()) == null) {
            sqlDropStatementImpl = ObjectKind.UNKNOWN_OBJECT;
        }
        SqlDropStatementImpl sqlDropStatementImpl2 = targetKind = sqlDropStatementImpl;
        return Intrinsics.areEqual((Object)((Object)sqlDropStatementImpl2), (Object)ObjectKind.ROUTINE) ? (SqlBlock)new SqlDropRoutineBlock() : (SqlBlock)new SqlStatementBlock();
    }

    @NotNull
    public static final <B extends SqlBlock> B init(@NotNull B $receiver, @NotNull Function2<? super B, ? super B, Unit> initializer) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        initializer.invoke($receiver, $receiver);
        return $receiver;
    }

    private static final <B extends SqlBlock> B findParent(@NotNull SqlBlock $receiver) {
        for (SqlBlock p2 = $receiver.getParent(); p2 != null; p2 = p2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"B");
            if (!(p2 instanceof SqlBlock)) continue;
            return (B)p2;
        }
        return null;
    }

    @Nullable
    public static final ASTNode primaryNode(@NotNull SqlBlock $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        SqlBlock sqlBlock = $receiver;
        if (sqlBlock instanceof SqlLeafBlock) {
            object = ((SqlLeafBlock)$receiver).getNode();
        } else if (sqlBlock instanceof SqlNodeBlock) {
            object = ((SqlNodeBlock)$receiver).getBlockNode();
        } else if (sqlBlock instanceof SqlRangeBlock) {
            object = ((SqlRangeBlock)$receiver).getNestedBlocks().size() == 1 ? SqlFormattingModelFunKt.primaryNode(((SqlRangeBlock)$receiver).getNestedBlocks().get(0)) : null;
        } else if (sqlBlock instanceof SqlRootBlock) {
            object = ((SqlRootBlock)$receiver).getBlockNode();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final IElementType primaryElementType(@NotNull SqlBlock $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = SqlFormattingModelFunKt.primaryNode($receiver);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SqlFormattingModelFunKt.listChildren($receiver, (Function1<? super ASTNode, Boolean>)((Function1)listChildren.1.INSTANCE));
    }

    @NotNull
    public static final List<ASTNode> listChildren(@NotNull ASTNode $receiver, @NotNull Function1<? super ASTNode, Boolean> flatten) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(flatten, (String)"flatten");
        List list = new ArrayList();
        Function1<ASTNode, Unit> listChildrenRecursively$ = new Function1<ASTNode, Unit>(flatten, list){
            final /* synthetic */ Function1 $flatten;
            final /* synthetic */ List $list;

            public final void invoke(@NotNull ASTNode parentNode) {
                Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
                for (ASTNode node = parentNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
                    IElementType type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node.getElementType(), (String)"node.elementType");
                    if (type == SqlElementTypes.SQL_DUMMY_BLOCK || ((Boolean)this.$flatten.invoke((Object)node)).booleanValue()) {
                        this.invoke(node);
                        continue;
                    }
                    if (SqlUtilFun.isWhitespace(node)) continue;
                    Collection collection = this.$list;
                    collection.add(node);
                }
            }
            {
                this.$flatten = function1;
                this.$list = list;
                super(1);
            }
        };
        listChildrenRecursively$.invoke($receiver);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOf(@NotNull List<? extends ASTNode> $receiver, @NotNull IElementType type, int since, int till, int notFound) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        int n = $receiver.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw (Throwable)new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = since;
        int n3 = Math.min(till, n);
        while (n2 < n3) {
            void i2;
            if ($receiver.get((int)i2).getElementType() == type) {
                return (int)i2;
            }
            ++i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, IElementType iElementType, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFunKt.indexOf((List<? extends ASTNode>)list, iElementType, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOf(@NotNull List<? extends ASTNode> $receiver, @NotNull Set<? extends IElementType> types, int since, int till, int notFound) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        int n = $receiver.size();
        if (since >= n) {
            return notFound;
        }
        if (since < 0) {
            throw (Throwable)new IllegalArgumentException("Negative since = " + since);
        }
        int n2 = since;
        int n3 = Math.min(till, n);
        while (n2 < n3) {
            void i2;
            if (types.contains($receiver.get((int)i2).getElementType())) {
                return (int)i2;
            }
            ++i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, Set set, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = list.size();
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return SqlFormattingModelFunKt.indexOf((List<? extends ASTNode>)list, set, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkSubSequence(@NotNull List<? extends ASTNode> $receiver, int from, IElementType ... subSequence) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subSequence, (String)"subSequence");
        int m = subSequence.length;
        if (m < 1) {
            throw (Throwable)new IllegalArgumentException("subSequence is empty");
        }
        int n = $receiver.size();
        if (from + m > n) {
            return false;
        }
        int n2 = 0;
        int n3 = m;
        while (n2 < n3) {
            void i2;
            if ($receiver.get(from + i2).getElementType() != subSequence[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static /* synthetic */ boolean checkSubSequence$default(List list, int n, IElementType[] iElementTypeArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return SqlFormattingModelFunKt.checkSubSequence(list, n, iElementTypeArray);
    }

    @Nullable
    public static final IntRange findConsequence(@NotNull List<? extends ASTNode> $receiver, int since, @NotNull Function1<? super ASTNode, Boolean> predicate) {
        int f;
        int s;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        int n = $receiver.size();
        for (s = since; s < n && !((Boolean)predicate.invoke((Object)$receiver.get(s))).booleanValue(); ++s) {
        }
        if (s == n) {
            return null;
        }
        for (f = s + 1; f < n && ((Boolean)predicate.invoke((Object)$receiver.get(f))).booleanValue(); ++f) {
        }
        return RangesKt.until((int)s, (int)f);
    }

    @Nullable
    public static /* synthetic */ IntRange findConsequence$default(List list, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return SqlFormattingModelFunKt.findConsequence(list, n, (Function1<? super ASTNode, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FindPhraseResult findPhrase(@NotNull List<? extends ASTNode> $receiver, int offset, @NotNull IElementType[][] patterns2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)patterns2, (String)"patterns");
        int n = $receiver.size();
        int k = offset;
        while (k < n) {
            int begin;
            ASTNode node;
            if (SqlUtilFun.isWhitespaceOrComment(node = $receiver.get(begin = k++))) continue;
            int n2 = 0;
            int n3 = ((Object[])patterns2).length;
            while (n2 < n3) {
                void i2;
                IElementType[] iElementTypeArray = patterns2[i2];
                int m = SqlUtilFun.matchPhrase($receiver, begin, Arrays.copyOf(iElementTypeArray, iElementTypeArray.length));
                if (m > 0) {
                    return new FindPhraseResult((int)i2, begin, begin + m);
                }
                ++i2;
            }
        }
        return null;
    }

    public static final int getFinish(@NotNull IntRange $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getEndInclusive();
    }

    @NotNull
    public static final Alignment makeLeftAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeLeftAlignmentBS() {
        Alignment alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026e, Alignment.Anchor.LEFT)");
        return alignment;
    }

    @NotNull
    public static final Alignment makeRightAlignment() {
        Alignment alignment = Alignment.createAlignment((boolean)false, (Alignment.Anchor)Alignment.Anchor.RIGHT);
        Intrinsics.checkExpressionValueIsNotNull((Object)alignment, (String)"Alignment.createAlignmen\u2026, Alignment.Anchor.RIGHT)");
        return alignment;
    }

    @SqlCodeStyleConst.ElementsLineMagicValues
    public static final int openingToElLine(@SqlCodeStyleConst.OpeningMagicValues int opening) {
        int n;
        switch (opening) {
            case 1: {
                n = 1;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Nullable
    public static final WrapImpl.Type getType(@Nullable Wrap $receiver) {
        Wrap wrap = $receiver;
        if (!(wrap instanceof WrapImpl)) {
            wrap = null;
        }
        WrapImpl wrapImpl = (WrapImpl)wrap;
        return wrapImpl != null ? wrapImpl.getType() : null;
    }

    public static final boolean isAlways(@Nullable Wrap $receiver) {
        return SqlFormattingModelFunKt.getType($receiver) == WrapImpl.Type.WRAP_ALWAYS;
    }

    @NotNull
    public static final JBIterable<SqlBlock> skip(@NotNull Iterable<? extends SqlBlock> $receiver, int count2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.skip(count2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.skip(count)");
        return jBIterable2;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $receiver, @NotNull BlockRole role) {
        SqlBlock sqlBlock;
        block1: {
            Iterable<? extends SqlBlock> iterable;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
            Iterable<? extends SqlBlock> iterable2 = iterable = $receiver;
            for (SqlBlock sqlBlock2 : iterable2) {
                SqlBlock it = sqlBlock2;
                if (!(it.getRole() == role)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    @Nullable
    public static final SqlBlock find(@NotNull Iterable<? extends SqlBlock> $receiver, @NotNull IElementType type) {
        SqlBlock sqlBlock;
        block1: {
            Iterable<? extends SqlBlock> iterable;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Iterable<? extends SqlBlock> iterable2 = iterable = $receiver;
            for (SqlBlock sqlBlock2 : iterable2) {
                SqlBlock it = sqlBlock2;
                if (!(SqlFormattingModelFunKt.primaryElementType(it) == type)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        return sqlBlock;
    }

    private static final <B extends SqlBlock> B find(@NotNull Iterable<? extends SqlBlock> $receiver) {
        SqlBlock sqlBlock;
        block1: {
            Iterable<? extends SqlBlock> iterable;
            Iterable<? extends SqlBlock> iterable2 = iterable = $receiver;
            Iterator<? extends SqlBlock> iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                SqlBlock sqlBlock2;
                SqlBlock it = sqlBlock2 = iterator.next();
                Intrinsics.reifiedOperationMarker((int)3, (String)"B");
                if (!(it instanceof SqlBlock)) continue;
                sqlBlock = sqlBlock2;
                break block1;
            }
            sqlBlock = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"B");
        return (B)sqlBlock;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $receiver, @NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter((Condition)new Condition<SqlBlock>(role){
            final /* synthetic */ BlockRole $role;

            public final boolean value(SqlBlock it) {
                return it.getRole() == this.$role;
            }
            {
                this.$role = blockRole;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter { it.role == role }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $receiver, @NotNull BlockRole role1, @NotNull BlockRole role2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role1), (String)"role1");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role2), (String)"role2");
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter((Condition)new Condition<SqlBlock>(role1, role2){
            final /* synthetic */ BlockRole $role1;
            final /* synthetic */ BlockRole $role2;

            public final boolean value(SqlBlock it) {
                return it.getRole() == this.$role1 || it.getRole() == this.$role2;
            }
            {
                this.$role1 = blockRole;
                this.$role2 = blockRole2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter { it.rol\u2026le1 || it.role == role2 }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $receiver, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter((Condition)new Condition<SqlBlock>(type){
            final /* synthetic */ IElementType $type;

            public final boolean value(SqlBlock it) {
                return it instanceof SqlSingleNodeBlock && ((SqlSingleNodeBlock)((Object)it)).getBlockElementTypes() == this.$type;
            }
            {
                this.$type = iElementType;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter { it is \u2026ckElementTypes === type }");
        return jBIterable2;
    }

    @NotNull
    public static final JBIterable<SqlBlock> filter(@NotNull Iterable<? extends SqlBlock> $receiver, IElementType ... types) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter((Condition)new Condition<SqlBlock>(types){
            final /* synthetic */ IElementType[] $types;

            public final boolean value(SqlBlock it) {
                return it instanceof SqlSingleNodeBlock && ArraysKt.contains((Object[])this.$types, (Object)((SqlSingleNodeBlock)((Object)it)).getBlockElementTypes());
            }
            {
                this.$types = iElementTypeArray;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter { it is \u2026ckElementTypes in types }");
        return jBIterable2;
    }

    private static final <B extends SqlBlock> JBIterable<B> filter(@NotNull Iterable<? extends SqlBlock> $receiver) {
        Iterable<? extends SqlBlock> $receiver$iv = $receiver;
        JBIterable jBIterable = JBIterable.from($receiver$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        Intrinsics.reifiedOperationMarker((int)4, (String)"B");
        JBIterable jBIterable2 = jBIterable.filter(SqlBlock.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
        return jBIterable2;
    }

    @NotNull
    public static final <B extends SqlBlock> JBIterable<B> getJbi(@NotNull Iterable<? extends B> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        JBIterable jBIterable = JBIterable.from($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        return jBIterable;
    }
}

